/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.codeInsight.editorActions.TypingActionsExtension;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyHandler
extends EditorActionHandler
implements CopyAction.TransferableProvider {
    private static final Logger LOG = Logger.getInstance(CopyHandler.class);
    private final EditorActionHandler myOriginalAction;

    public CopyHandler(EditorActionHandler originalHandler) {
        this.myOriginalAction = originalHandler;
    }

    public void doExecute(@NotNull Editor editor2, Caret caret, DataContext dataContext) {
        EditorEx ex;
        Transferable transferable;
        if (editor2 == null) {
            CopyHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'copy' operation for specific caret is not supported";
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor2.getComponent()));
        if (project2 == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor2, null, dataContext);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor2, null, dataContext);
            }
            return;
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (!selectionModel.hasSelection(true)) {
            if (CopyAction.isSkipCopyPasteForEmptySelection()) {
                return;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.copy.line");
            editor2.getCaretModel().runForEachCaret(__ -> selectionModel.selectLineAtCaret());
            if (!selectionModel.hasSelection(true)) {
                return;
            }
            editor2.getCaretModel().runForEachCaret(__ -> EditorActionUtil.moveCaretToLineStartIgnoringSoftWraps((Editor)editor2));
        }
        if ((transferable = CopyHandler.getSelection(editor2, project2, file2)) == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents(transferable);
        if (editor2 instanceof EditorEx && (ex = (EditorEx)editor2).isStickySelection()) {
            ex.setStickySelection(false);
        }
    }

    @Nullable
    public Transferable getSelection(@NotNull Editor editor2) {
        Project project2;
        if (editor2 == null) {
            CopyHandler.$$$reportNull$$$0(1);
        }
        if ((project2 = editor2.getProject()) == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null) {
            return null;
        }
        return CopyHandler.getSelection(editor2, project2, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Transferable getSelection(@NotNull Editor editor2, @NotNull Project project2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            CopyHandler.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            CopyHandler.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            CopyHandler.$$$reportNull$$$0(4);
        }
        TypingActionsExtension typingActionsExtension = TypingActionsExtension.findForContext(project2, editor2);
        try {
            typingActionsExtension.startCopy(project2, editor2);
            Transferable transferable = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.compute(() -> CopyHandler.getSelectionAction(editor2, project2, file2)), ActionsBundle.message((String)"action.EditorCopy.text", (Object[])new Object[0]), true, project2);
            return transferable;
        }
        finally {
            typingActionsExtension.endCopy(project2, editor2);
        }
    }

    @NotNull
    private static Transferable getSelectionAction(@NotNull Editor editor2, @NotNull Project project2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            CopyHandler.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            CopyHandler.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            CopyHandler.$$$reportNull$$$0(7);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        int[] startOffsets = selectionModel.getBlockSelectionStarts();
        int[] endOffsets = selectionModel.getBlockSelectionEnds();
        ArrayList transferableDataList = new ArrayList();
        DumbService.getInstance(project2).withAlternativeResolveEnabled(() -> {
            for (CopyPastePostProcessor<? extends TextBlockTransferableData> processor : CopyPastePostProcessor.EP_NAME.getExtensionList()) {
                try {
                    transferableDataList.addAll(processor.collectTransferableData(file2, editor2, startOffsets, endOffsets));
                }
                catch (ProcessCanceledException ex) {
                    throw ex;
                }
                catch (IndexNotReadyException e) {
                    LOG.debug(e);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        });
        String text2 = editor2.getCaretModel().supportsMultipleCarets() ? EditorCopyPasteHelperImpl.getSelectedTextForClipboard((Editor)editor2, transferableDataList) : selectionModel.getSelectedText();
        String rawText = TextBlockTransferable.convertLineSeparators((String)text2, (String)"\n", transferableDataList);
        String escapedText = null;
        for (CopyPastePreProcessor processor : CopyPastePreProcessor.EP_NAME.getExtensionList()) {
            try {
                escapedText = processor.preprocessOnCopy(file2, startOffsets, endOffsets, rawText);
            }
            catch (ProcessCanceledException ex) {
                throw ex;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (escapedText == null) continue;
            break;
        }
        return new TextBlockTransferable(escapedText != null ? escapedText : rawText, transferableDataList, escapedText != null ? new RawText(rawText) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/CopyHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelection";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

