/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DocRenderSelectionManager
implements CaretListener,
SelectionListener,
Disposable {
    private static final Key<DocRenderSelectionManager> OUR_KEY = Key.create("DocRenderSelectionManager");
    private final Editor myEditor;
    private DocRenderer.EditorPane myPaneWithSelection;
    private boolean mySkipSelectionEvents;

    DocRenderSelectionManager(Editor editor2) {
        this.myEditor = editor2;
        editor2.getCaretModel().addCaretListener((CaretListener)this, (Disposable)this);
        editor2.getSelectionModel().addSelectionListener((SelectionListener)this, (Disposable)this);
        editor2.putUserData(OUR_KEY, (Object)this);
    }

    @Override
    public void dispose() {
        this.myEditor.putUserData(OUR_KEY, null);
    }

    void setPaneWithSelection(DocRenderer.EditorPane pane) {
        if (pane != this.myPaneWithSelection) {
            if (this.myPaneWithSelection != null) {
                this.myPaneWithSelection.removeSelection();
            }
            this.myPaneWithSelection = pane;
            if (this.myPaneWithSelection != null) {
                this.mySkipSelectionEvents = true;
                try {
                    this.myEditor.getSelectionModel().removeSelection(true);
                }
                finally {
                    this.mySkipSelectionEvents = false;
                }
            }
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        if (event == null) {
            DocRenderSelectionManager.$$$reportNull$$$0(0);
        }
        this.setPaneWithSelection(null);
    }

    public void caretAdded(@NotNull CaretEvent event) {
        if (event == null) {
            DocRenderSelectionManager.$$$reportNull$$$0(1);
        }
        this.setPaneWithSelection(null);
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        if (event == null) {
            DocRenderSelectionManager.$$$reportNull$$$0(2);
        }
        this.setPaneWithSelection(null);
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        if (e == null) {
            DocRenderSelectionManager.$$$reportNull$$$0(3);
        }
        if (!this.mySkipSelectionEvents) {
            this.setPaneWithSelection(null);
        }
    }

    @Nullable
    public static DocRenderer.EditorPane getPaneWithSelection(@NotNull Editor editor2) {
        DocRenderSelectionManager selectionManager;
        if (editor2 == null) {
            DocRenderSelectionManager.$$$reportNull$$$0(4);
        }
        return (selectionManager = (DocRenderSelectionManager)editor2.getUserData(OUR_KEY)) == null ? null : selectionManager.myPaneWithSelection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderSelectionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "caretPositionChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "caretAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "caretRemoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPaneWithSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

