/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.render.DocRenderDummyLineMarkerProvider;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.codeInsight.documentation.render.InlineDocumentationImplKt;
import com.intellij.lang.documentation.InlineDocumentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocRenderPassFactory
implements TextEditorHighlightingPassFactoryRegistrar,
TextEditorHighlightingPassFactory,
DumbAware {
    private static final Key<Long> MODIFICATION_STAMP = Key.create("doc.render.modification.stamp");
    private static final Key<Boolean> RESET_TO_DEFAULT = Key.create("doc.render.reset.to.default");
    private static final Key<Boolean> ICONS_ENABLED = Key.create("doc.render.icons.enabled");

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        if (registrar == null) {
            DocRenderPassFactory.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.AFTER, 1, false, false);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(3);
        }
        long current = PsiModificationTracker.getInstance(file2.getProject()).getModificationCount();
        boolean iconsEnabled = DocRenderDummyLineMarkerProvider.isGutterIconEnabled();
        Long existing = (Long)editor2.getUserData(MODIFICATION_STAMP);
        Boolean iconsWereEnabled = (Boolean)editor2.getUserData(ICONS_ENABLED);
        return editor2.getProject() == null || existing != null && existing == current && iconsWereEnabled != null && iconsWereEnabled == iconsEnabled ? null : new DocRenderPass(editor2, file2);
    }

    static void forceRefreshOnNextPass(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(4);
        }
        editor2.putUserData(MODIFICATION_STAMP, null);
        editor2.putUserData(RESET_TO_DEFAULT, (Object)Boolean.TRUE);
    }

    @NotNull
    public static Items calculateItemsToRender(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (editor2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            DocRenderPassFactory.$$$reportNull$$$0(6);
        }
        boolean enabled = DocRenderManager.isDocRenderingEnabled(editor2);
        Items items = new Items();
        for (InlineDocumentation documentation : InlineDocumentationImplKt.inlineDocumentationItems(psiFile)) {
            TextRange range = documentation.getDocumentationRange();
            if (!DocRenderItem.isValidRange(editor2, range)) continue;
            String textToRender = enabled ? DocRenderPassFactory.calcText(documentation) : null;
            items.addItem(new Item(range, textToRender));
        }
        Items items2 = items;
        if (items2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(7);
        }
        return items2;
    }

    @NotNull
    @Nls
    static String calcText(@Nullable InlineDocumentation documentation) {
        String string2;
        try {
            String text2 = documentation == null ? null : documentation.renderText();
            string2 = text2 == null ? CodeInsightBundle.message("doc.render.not.available.text", new Object[0]) : DocRenderPassFactory.preProcess(text2);
        }
        catch (IndexNotReadyException e) {
            String string3 = CodeInsightBundle.message("doc.render.dumb.mode.text", new Object[0]);
            if (string3 == null) {
                DocRenderPassFactory.$$$reportNull$$$0(9);
            }
            return string3;
        }
        if (string2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(8);
        }
        return string2;
    }

    private static String preProcess(String text2) {
        return DocumentationManager.addExternalLinksIcon(text2);
    }

    public static void applyItemsToRender(@NotNull Editor editor2, @NotNull Project project2, @NotNull Items items, boolean collapseNewRegions) {
        if (editor2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(11);
        }
        if (items == null) {
            DocRenderPassFactory.$$$reportNull$$$0(12);
        }
        editor2.putUserData(MODIFICATION_STAMP, (Object)PsiModificationTracker.getInstance(project2).getModificationCount());
        editor2.putUserData(ICONS_ENABLED, (Object)DocRenderDummyLineMarkerProvider.isGutterIconEnabled());
        DocRenderItem.setItemsToEditor(editor2, items, collapseNewRegions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateItemsToRender";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forceRefreshOnNextPass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateItemsToRender";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyItemsToRender";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Item {
        final TextRange textRange;
        @Nls
        final String textToRender;

        private Item(@NotNull TextRange textRange, @Nullable @Nls String textToRender) {
            if (textRange == null) {
                Item.$$$reportNull$$$0(0);
            }
            this.textRange = textRange;
            this.textToRender = textToRender;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/documentation/render/DocRenderPassFactory$Item", "<init>"));
        }
    }

    public static class Items
    implements Iterable<Item> {
        private final Map<TextRange, Item> myItems = new LinkedHashMap<TextRange, Item>();

        boolean isEmpty() {
            return this.myItems.isEmpty();
        }

        private void addItem(@NotNull Item item) {
            if (item == null) {
                Items.$$$reportNull$$$0(0);
            }
            this.myItems.put(item.textRange, item);
        }

        @Nullable
        Item removeItem(@NotNull Segment textRange) {
            if (textRange == null) {
                Items.$$$reportNull$$$0(1);
            }
            return this.myItems.remove(TextRange.create(textRange));
        }

        @Override
        @NotNull
        public Iterator<Item> iterator() {
            Iterator<Item> iterator = this.myItems.values().iterator();
            if (iterator == null) {
                Items.$$$reportNull$$$0(2);
            }
            return iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory$Items";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory$Items";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeItem";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DocRenderPass
    extends EditorBoundHighlightingPass
    implements DumbAware {
        private Items items;

        DocRenderPass(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
            if (editor2 == null) {
                DocRenderPass.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                DocRenderPass.$$$reportNull$$$0(1);
            }
            super(editor2, psiFile, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                DocRenderPass.$$$reportNull$$$0(2);
            }
            this.items = DocRenderPassFactory.calculateItemsToRender(this.myEditor, this.myFile);
        }

        @Override
        public void doApplyInformationToEditor() {
            boolean resetToDefault = this.myEditor.getUserData(RESET_TO_DEFAULT) != null;
            this.myEditor.putUserData(RESET_TO_DEFAULT, null);
            DocRenderPassFactory.applyItemsToRender(this.myEditor, this.myProject, this.items, resetToDefault && DocRenderManager.isDocRenderingEnabled(this.myEditor));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory$DocRenderPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

