/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocRenderManager {
    private static final Key<Boolean> DOC_RENDER_ENABLED = Key.create("doc.render.enabled");

    public static void setDocRenderingEnabled(@NotNull Editor editor2, @Nullable Boolean value) {
        if (editor2 == null) {
            DocRenderManager.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean enabledBefore = DocRenderManager.isDocRenderingEnabled(editor2);
        editor2.putUserData(DOC_RENDER_ENABLED, (Object)value);
        boolean enabledAfter = DocRenderManager.isDocRenderingEnabled(editor2);
        if (enabledAfter != enabledBefore) {
            DocRenderManager.resetEditorToDefaultState(editor2);
        }
    }

    public static boolean isDocRenderingEnabled(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocRenderManager.$$$reportNull$$$0(1);
        }
        if (editor2.getEditorKind() == EditorKind.DIFF) {
            return false;
        }
        Boolean value = (Boolean)editor2.getUserData(DOC_RENDER_ENABLED);
        return value == null ? EditorSettingsExternalizable.getInstance().isDocCommentRenderingEnabled() : value.booleanValue();
    }

    public static void resetAllEditorsToDefaultState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (Editor editor2 : EditorFactory.getInstance().getAllEditors()) {
            DocRenderItem.resetToDefaultState(editor2);
            DocRenderPassFactory.forceRefreshOnNextPass(editor2);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance(project2).restart();
        }
    }

    public static void resetEditorToDefaultState(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocRenderManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocRenderItem.resetToDefaultState(editor2);
        DocRenderPassFactory.forceRefreshOnNextPass(editor2);
        Project project2 = editor2.getProject();
        if (project2 != null) {
            DaemonCodeAnalyzer.getInstance(project2).restart();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setDocRenderingEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocRenderingEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorToDefaultState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

