/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.documentation.ide.actions.ActionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00112\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/codeInsight/hint/HintManagerImpl$ActionToIgnore;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/PopupAction;", "Lcom/intellij/openapi/actionSystem/PerformWithDocumentsCommitted;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformedV2", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.platform.lang.impl"})
public class ShowQuickDocInfoAction
extends AnAction
implements HintManagerImpl.ActionToIgnore,
DumbAware,
PopupAction,
PerformWithDocumentsCommitted {
    @NotNull
    public static final String CODEASSISTS_QUICKJAVADOC_FEATURE = "codeassists.quickjavadoc";
    @NotNull
    public static final String CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE = "codeassists.quickjavadoc.lookup";
    @NotNull
    public static final String CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE = "codeassists.quickjavadoc.ctrln";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (QuickDocUtil.isDocumentationV2Enabled()) {
            Collection collection;
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            List list2 = (List)e.getDataContext().getData(ActionsKt.DOCUMENTATION_TARGETS);
            presentation2.setEnabled(list2 != null ? !(collection = (Collection)list2).isEmpty() : false);
            return;
        }
        Presentation presentation3 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
        Presentation presentation4 = presentation3;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        DataContext dataContext2 = dataContext;
        presentation4.setEnabled(false);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"CommonDataKeys.PROJECT.g\u2026ta(dataContext) ?: return");
        Project project3 = project2;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
        if (editor2 == null && element2 == null) {
            return;
        }
        LookupManager lookupManager = LookupManager.getInstance(project3);
        Intrinsics.checkNotNullExpressionValue((Object)lookupManager, (String)"LookupManager.getInstance(project)");
        if (lookupManager.getActiveLookup() != null) {
            presentation4.setEnabled(true);
        } else {
            if (editor2 != null) {
                if (e.getData(EditorGutter.KEY) != null) {
                    return;
                }
                PsiFile file2 = PsiDocumentManager.getInstance(project3).getPsiFile(editor2.getDocument());
                if (file2 == null && element2 == null) {
                    return;
                }
            }
            presentation4.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (QuickDocUtil.isDocumentationV2Enabled()) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
            this.actionPerformedV2(dataContext);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        DataContext dataContext2 = dataContext;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"CommonDataKeys.PROJECT.g\u2026ta(dataContext) ?: return");
        Project project3 = project2;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 != null) {
            DocumentationManager documentationManager;
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_FEATURE);
            LookupEx activeLookup = LookupManager.getActiveLookup(editor2);
            if (activeLookup != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE);
            }
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor2, project3);
            if (psiFile == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiUtilBase.getPsiFileIn\u2026ditor, project) ?: return");
            PsiFile psiFile2 = psiFile;
            DocumentationManager documentationManager2 = documentationManager = DocumentationManager.getInstance(project3);
            Intrinsics.checkNotNullExpressionValue((Object)documentationManager2, (String)"documentationManager");
            JBPopup hint = documentationManager2.getDocInfoHint();
            documentationManager.showJavaDocInfo(editor2, psiFile2, hint != null || activeLookup == null);
            return;
        }
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
        if (element2 != null) {
            DocumentationManager documentationManager;
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE);
            DocumentationManager documentationManager3 = documentationManager = DocumentationManager.getInstance(project3);
            Intrinsics.checkNotNullExpressionValue((Object)documentationManager3, (String)"documentationManager");
            JBPopup hint = documentationManager3.getDocInfoHint();
            documentationManager.showJavaDocInfo(element2, null, hint != null, null);
        }
    }

    private final void actionPerformedV2(DataContext dataContext) {
        Project project2 = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"dataContext.getData(Comm\u2026taKeys.PROJECT) ?: return");
        Project project3 = project2;
        com.intellij.lang.documentation.ide.impl.DocumentationManager.Companion.instance(project3).actionPerformed(dataContext);
    }

    public ShowQuickDocInfoAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction$Companion;", "", "()V", "CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE", "", "CODEASSISTS_QUICKJAVADOC_FEATURE", "CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

