/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.DocPreviewUtil;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorMouseHoverPopupManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.ui.HintHint;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.UIUtil;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuickDocUtil {
    public static final Object CUT_AT_CMD = ObjectUtils.sentinel("CUT_AT_CMD");
    private static volatile boolean useDocumentationV1 = false;

    @Deprecated
    public static void updateQuickDoc(@NotNull Project project2, @NotNull PsiElement element2, @Nullable @Nls String documentation) {
        if (project2 == null) {
            QuickDocUtil.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            QuickDocUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty(documentation)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            DocumentationComponent component2 = QuickDocUtil.getActiveDocComponent(project2);
            if (component2 != null) {
                component2.replaceText(documentation, element2);
            }
        });
    }

    @Deprecated
    @Nullable
    public static DocumentationComponent getActiveDocComponent(@NotNull Project project2) {
        DocumentationComponent component2;
        DocumentationManager documentationManager;
        JBPopup hint;
        if (project2 == null) {
            QuickDocUtil.$$$reportNull$$$0(2);
        }
        if ((hint = (documentationManager = DocumentationManager.getInstance(project2)).getDocInfoHint()) != null) {
            component2 = (DocumentationComponent)((AbstractPopup)hint).getComponent();
        } else if (documentationManager.hasActiveDockedDocWindow()) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow("Documentation");
            Content selectedContent = toolWindow == null ? null : toolWindow.getContentManager().getSelectedContent();
            component2 = selectedContent == null ? null : (DocumentationComponent)selectedContent.getComponent();
        } else {
            component2 = EditorMouseHoverPopupManager.getInstance().getDocumentationComponent();
        }
        return component2;
    }

    @Nls
    @Contract(value="_, _, _, null -> null")
    public static String inferLinkFromFullDocumentation(@NotNull DocumentationProvider provider2, PsiElement element2, PsiElement originalElement, @Nullable @Nls String navigationInfo) {
        if (provider2 == null) {
            QuickDocUtil.$$$reportNull$$$0(3);
        }
        if (navigationInfo != null) {
            String fqn = element2 instanceof PsiQualifiedNamedElement ? ((PsiQualifiedNamedElement)element2).getQualifiedName() : null;
            String fullText = provider2.generateDoc(element2, originalElement);
            return HintUtil.prepareHintText((String)DocPreviewUtil.buildPreview(navigationInfo, fqn, fullText), (HintHint)HintUtil.getInformationHint());
        }
        return null;
    }

    @Deprecated
    public static void updateQuickDocAsync(@NotNull PsiElement element2, @NotNull CharSequence prefix, @NotNull Consumer<? super Consumer<Object>> provider2) {
        if (element2 == null) {
            QuickDocUtil.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            QuickDocUtil.$$$reportNull$$$0(5);
        }
        if (provider2 == null) {
            QuickDocUtil.$$$reportNull$$$0(6);
        }
        Project project2 = element2.getProject();
        StringBuilder sb = new StringBuilder(prefix);
        ConcurrentLinkedQueue queue2 = new ConcurrentLinkedQueue();
        Disposable alarmDisposable = Disposer.newDisposable();
        Disposer.register(project2, alarmDisposable);
        AtomicBoolean stop2 = new AtomicBoolean(false);
        Ref<Object> cutAt = Ref.create(null);
        SingleAlarm alarm2 = new SingleAlarm(() -> {
            String prevText;
            String newText;
            DocumentationComponent component2 = QuickDocUtil.getActiveDocComponent(project2);
            if (component2 == null) {
                stop2.set(true);
                Disposer.dispose(alarmDisposable);
                return;
            }
            Object s = queue2.poll();
            while (s != null) {
                if (s == CUT_AT_CMD || cutAt.get() == CUT_AT_CMD) {
                    cutAt.set(s);
                    s = "";
                } else if (!cutAt.isNull()) {
                    int idx = StringUtil.indexOf((CharSequence)sb, cutAt.get().toString());
                    if (idx >= 0) {
                        sb.setLength(idx);
                    }
                    cutAt.set(null);
                }
                sb.append(s);
                s = queue2.poll();
            }
            if (stop2.get()) {
                Disposer.dispose(alarmDisposable);
            }
            if (!Objects.equals(newText = sb + "<br><br><br>", prevText = component2.getText())) {
                component2.replaceText(newText, element2);
            }
        }, 100, alarmDisposable);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                provider2.consume(str -> {
                    ProgressManager.checkCanceled();
                    if (stop2.get()) {
                        throw new ProcessCanceledException();
                    }
                    queue2.add(str);
                    alarm2.cancelAndRequest();
                });
            }
            finally {
                if (stop2.compareAndSet(false, true)) {
                    alarm2.cancelAndRequest();
                }
            }
        });
    }

    @ApiStatus.Internal
    public static void forceEnableDocumentationV1() {
        useDocumentationV1 = true;
    }

    @ApiStatus.Internal
    public static boolean isDocumentationV2Enabled() {
        return !useDocumentationV1 && Registry.is("documentation.v2");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/QuickDocUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateQuickDoc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveDocComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inferLinkFromFullDocumentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateQuickDocAsync";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

