/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;

public class DocumentationManagerUtil {
    public static DocumentationManagerUtil getInstance() {
        return ApplicationManager.getApplication().getService(DocumentationManagerUtil.class);
    }

    protected void createHyperlinkImpl(StringBuilder buffer, PsiElement refElement, String refText, String label2, boolean plainLink, boolean isRendered) {
        buffer.append("<a href=\"");
        buffer.append("psi_element://");
        buffer.append(refText);
        buffer.append("\">");
        if (!plainLink) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                buffer.append(isRendered ? "<code style='font-size:96%;'>" : "<code>");
            } else {
                buffer.append("<code style='font-size:");
                buffer.append(DocumentationManagerUtil.getMonospaceFontSizeCorrection(isRendered));
                buffer.append("%;'>");
            }
        }
        buffer.append(label2);
        if (!plainLink) {
            buffer.append("</code>");
        }
        buffer.append("</a>");
    }

    private static int getMonospaceFontSizeCorrection(boolean isRendered) {
        if (isRendered) {
            return SystemInfo.isWin10OrNewer && !ApplicationManager.getApplication().isUnitTestMode() ? 90 : 96;
        }
        return SystemInfo.isWin10OrNewer && !ApplicationManager.getApplication().isUnitTestMode() ? 90 : 100;
    }

    public static void createHyperlink(StringBuilder buffer, String refText, String label2, boolean plainLink) {
        DocumentationManagerUtil.getInstance().createHyperlinkImpl(buffer, null, refText, label2, plainLink, false);
    }

    public static void createHyperlink(StringBuilder buffer, String refText, String label2, boolean plainLink, boolean isRendered) {
        DocumentationManagerUtil.getInstance().createHyperlinkImpl(buffer, null, refText, label2, plainLink, isRendered);
    }

    public static void createHyperlink(StringBuilder buffer, PsiElement refElement, String refText, String label2, boolean plainLink) {
        DocumentationManagerUtil.getInstance().createHyperlinkImpl(buffer, refElement, refText, label2, plainLink, false);
    }

    public static void createHyperlink(StringBuilder buffer, PsiElement refElement, String refText, String label2, boolean plainLink, boolean isRendered) {
        DocumentationManagerUtil.getInstance().createHyperlinkImpl(buffer, refElement, refText, label2, plainLink, isRendered);
    }
}

