/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.DocumentationRenderableImage;
import com.intellij.lang.documentation.DocumentationImageResolver;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.renderable.RenderableImageProducer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

final class DocumentationImageProvider
extends Dictionary<URL, Image> {
    @NotNull
    private final Component myReferenceComponent;
    @NotNull
    private final DocumentationImageResolver myImageResolver;

    DocumentationImageProvider(@NotNull Component referenceComponent, @NotNull DocumentationImageResolver imageResolver2) {
        if (referenceComponent == null) {
            DocumentationImageProvider.$$$reportNull$$$0(0);
        }
        if (imageResolver2 == null) {
            DocumentationImageProvider.$$$reportNull$$$0(1);
        }
        this.myReferenceComponent = referenceComponent;
        this.myImageResolver = imageResolver2;
    }

    @Override
    public Image get(Object key) {
        if (key == null) {
            return null;
        }
        return this.getImage((URL)key);
    }

    @Nullable
    private Image getImage(@NotNull URL url) {
        Image inMemory;
        if (url == null) {
            DocumentationImageProvider.$$$reportNull$$$0(2);
        }
        if ((inMemory = this.myImageResolver.resolveImage(url.toExternalForm())) != null) {
            return inMemory;
        }
        return Toolkit.getDefaultToolkit().createImage(new RenderableImageProducer(new DocumentationRenderableImage(Objects.requireNonNullElse(DocumentationImageProvider.builtinServerUrl(url), url), this.myReferenceComponent), null));
    }

    @Nullable
    private static URL builtinServerUrl(@NotNull URL url) {
        Url parsedUrl;
        if (url == null) {
            DocumentationImageProvider.$$$reportNull$$$0(3);
        }
        if ((parsedUrl = Urls.parseEncoded((String)url.toExternalForm())) == null) {
            return null;
        }
        BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
        if (!builtInServerManager.isOnBuiltInWebServer(parsedUrl)) {
            return null;
        }
        try {
            return new URL(builtInServerManager.addAuthToken(parsedUrl).toExternalForm());
        }
        catch (MalformedURLException e) {
            DocumentationManager.LOG.warn(e);
            return null;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<URL> keys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<Image> elements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image put(URL key, Image value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image remove(Object key) {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageResolver";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationImageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getImage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "builtinServerUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

