/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationHtmlUtil;
import com.intellij.codeInsight.documentation.DocumentationImageProvider;
import com.intellij.codeInsight.documentation.DocumentationLinkHighlightPainter;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.documentation.DocumentationImageResolver;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.impl.EditorCssFontResolver;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.CSSFontResolver;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class DocumentationEditorPane
extends JEditorPane {
    private static final Color BACKGROUND_COLOR = JBColor.lazy(() -> {
        ColorKey colorKey = DocumentationComponent.COLOR_KEY;
        EditorColorsScheme scheme = EditorColorsUtil.getColorSchemeForBackground(null);
        Color color = scheme.getColor(colorKey);
        if (color != null) {
            return color;
        }
        color = colorKey.getDefaultColor();
        if (color != null) {
            return color;
        }
        return scheme.getDefaultBackground();
    });
    private final Map<KeyStroke, ActionListener> myKeyboardActions;
    @NotNull
    private final DocumentationImageResolver myImageResolver;
    @Nls
    private String myText;
    private Object myHighlightedTag;

    protected DocumentationEditorPane(@NotNull Map<KeyStroke, ActionListener> keyboardActions, @NotNull DocumentationImageResolver imageResolver2, @NotNull @NotNull Function<@NotNull String, @Nullable Icon> iconResolver) {
        if (keyboardActions == null) {
            DocumentationEditorPane.$$$reportNull$$$0(0);
        }
        if (imageResolver2 == null) {
            DocumentationEditorPane.$$$reportNull$$$0(1);
        }
        if (iconResolver == null) {
            DocumentationEditorPane.$$$reportNull$$$0(2);
        }
        this.myText = "";
        this.myKeyboardActions = keyboardActions;
        this.myImageResolver = imageResolver2;
        this.enableEvents(8L);
        this.setEditable(false);
        if (ScreenReader.isActive()) {
            this.getCaret().setVisible(true);
        } else {
            this.putClientProperty("caretWidth", 0);
            UIUtil.doNotScrollToCaret(this);
        }
        this.setBackground(BACKGROUND_COLOR);
        HTMLEditorKit editorKit = new HTMLEditorKitBuilder().replaceViewFactoryExtensions(DocumentationHtmlUtil.getIconsExtension(iconResolver), ExtendableHTMLViewFactory.Extensions.BASE64_IMAGES).withFontResolver((CSSFontResolver)EditorCssFontResolver.getGlobalInstance()).build();
        DocumentationHtmlUtil.addDocumentationPaneDefaultCssRules(editorKit);
        this.setEditorKit(editorKit);
        this.setBorder(JBUI.Borders.empty());
    }

    @Override
    @Nls
    public String getText() {
        return this.myText;
    }

    @Override
    public void setText(@Nls String t) {
        this.myText = t;
        super.setText(t);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        ActionListener listener2 = this.myKeyboardActions.get(keyStroke);
        if (listener2 != null) {
            listener2.actionPerformed(new ActionEvent(this, 0, ""));
            e.consume();
            return;
        }
        super.processKeyEvent(e);
    }

    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing(g);
        super.paintComponent(g);
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        if (doc instanceof StyledDocument) {
            doc.putProperty("imageCache", new DocumentationImageProvider(this, this.myImageResolver));
        }
    }

    @NotNull
    Dimension getPackedSize(int minWidth, int maxWidth) {
        int width = Math.max(Math.max(this.definitionPreferredWidth(), this.getMinimumSize().width), minWidth);
        int height = this.getPreferredHeightByWidth(Math.min(width, maxWidth));
        return new Dimension(width, height);
    }

    private int getPreferredHeightByWidth(int width) {
        this.setSize(width, Short.MAX_VALUE);
        return this.getPreferredSize().height;
    }

    int getPreferredWidth() {
        int definitionPreferredWidth = this.definitionPreferredWidth();
        return definitionPreferredWidth < 0 ? this.getPreferredSize().width : Math.max(definitionPreferredWidth, this.getMinimumSize().width);
    }

    private int definitionPreferredWidth() {
        int preferredDefinitionWidth = this.getPreferredSectionWidth("definition");
        int preferredLocationWidth = Math.max(this.getPreferredSectionWidth("bottom-no-content"), this.getPreferredSectionWidth("bottom"));
        if (preferredDefinitionWidth < 0) {
            return -1;
        }
        int preferredContentWidth = DocumentationEditorPane.getPreferredContentWidth(this.getDocument().getLength());
        return Math.max(preferredContentWidth, Math.max(preferredDefinitionWidth, preferredLocationWidth));
    }

    private int getPreferredSectionWidth(String sectionClassName) {
        View definition = DocumentationEditorPane.findSection(this.getUI().getRootView(this), sectionClassName);
        return definition == null ? -1 : (int)definition.getPreferredSpan(0);
    }

    private static int getPreferredContentWidth(int textLength) {
        int contentLengthPreferredSize = textLength < 200 ? JBUIScale.scale(300) : (textLength > 200 && textLength < 1000 ? JBUIScale.scale(300) + JBUIScale.scale(1) * (textLength - 200) * 200 / 800 : JBUIScale.scale(500));
        return contentLengthPreferredSize;
    }

    @Nullable
    private static View findSection(@NotNull View view, @NotNull String sectionClassName) {
        if (view == null) {
            DocumentationEditorPane.$$$reportNull$$$0(3);
        }
        if (sectionClassName == null) {
            DocumentationEditorPane.$$$reportNull$$$0(4);
        }
        if (sectionClassName.equals(view.getElement().getAttributes().getAttribute(HTML.Attribute.CLASS))) {
            return view;
        }
        for (int i = 0; i < view.getViewCount(); ++i) {
            View definition = DocumentationEditorPane.findSection(view.getView(i), sectionClassName);
            if (definition == null) continue;
            return definition;
        }
        return null;
    }

    @ApiStatus.Internal
    public void applyFontProps(@NotNull FontSize size) {
        Document document;
        if (size == null) {
            DocumentationEditorPane.$$$reportNull$$$0(5);
        }
        if (!((document = this.getDocument()) instanceof StyledDocument)) {
            return;
        }
        String fontName = Registry.is("documentation.component.editor.font") ? EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName() : this.getFont().getFontName();
        this.setFont(UIUtil.getFontWithFallback(fontName, 0, JBUIScale.scale(size.getSize())));
    }

    @Nullable
    private HTMLDocument.Iterator getLink(int n) {
        if (n >= 0) {
            HTMLDocument document = (HTMLDocument)this.getDocument();
            int linkCount = 0;
            HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
            while (it.isValid()) {
                if (it.getAttributes().isDefined(HTML.Attribute.HREF) && linkCount++ == n) {
                    return it;
                }
                it.next();
            }
        }
        return null;
    }

    void highlightLink(int n) {
        Highlighter highlighter = this.getHighlighter();
        HTMLDocument.Iterator link = this.getLink(n);
        if (link != null) {
            int startOffset = link.getStartOffset();
            int endOffset = link.getEndOffset();
            try {
                if (this.myHighlightedTag == null) {
                    this.myHighlightedTag = highlighter.addHighlight(startOffset, endOffset, DocumentationLinkHighlightPainter.INSTANCE);
                } else {
                    highlighter.changeHighlight(this.myHighlightedTag, startOffset, endOffset);
                }
                this.setCaretPosition(startOffset);
                if (!ScreenReader.isActive()) {
                    this.scrollRectToVisible(this.modelToView(startOffset));
                }
            }
            catch (BadLocationException e) {
                DocumentationManager.LOG.warn("Error highlighting link", e);
            }
        } else if (this.myHighlightedTag != null) {
            highlighter.removeHighlight(this.myHighlightedTag);
            this.myHighlightedTag = null;
        }
    }

    @Nullable
    String getLinkHref(int n) {
        HTMLDocument.Iterator link = this.getLink(n);
        return link != null ? (String)link.getAttributes().getAttribute(HTML.Attribute.HREF) : null;
    }

    int getLinkCount() {
        HTMLDocument document = (HTMLDocument)this.getDocument();
        int linkCount = 0;
        HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
        while (it.isValid()) {
            if (it.getAttributes().isDefined(HTML.Attribute.HREF)) {
                ++linkCount;
            }
            it.next();
        }
        return linkCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyboardActions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationEditorPane";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findSection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFontProps";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

