/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.quickFix.AbstractCreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFilePathFix
extends AbstractCreateFileFix {
    private final String myText;
    @Nullable
    private Supplier<String> myFileTextSupplier;

    public CreateFilePathFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation, @Nullable String fileText, @NotNull String fixLocaleKey) {
        if (psiElement == null) {
            CreateFilePathFix.$$$reportNull$$$0(0);
        }
        if (newFileLocation == null) {
            CreateFilePathFix.$$$reportNull$$$0(1);
        }
        if (fixLocaleKey == null) {
            CreateFilePathFix.$$$reportNull$$$0(2);
        }
        super(psiElement, newFileLocation, fixLocaleKey);
        this.myText = fileText;
        this.myIsAvailable = !FileTypeManager.getInstance().getFileTypeByFileName(this.myNewFileName).isBinary();
        this.myIsAvailableTimeStamp = System.currentTimeMillis();
    }

    public CreateFilePathFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation) {
        if (psiElement == null) {
            CreateFilePathFix.$$$reportNull$$$0(3);
        }
        if (newFileLocation == null) {
            CreateFilePathFix.$$$reportNull$$$0(4);
        }
        this(psiElement, newFileLocation, null, "create.file.text");
    }

    public CreateFilePathFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation, @NotNull Supplier<String> fileTextSupplier) {
        if (psiElement == null) {
            CreateFilePathFix.$$$reportNull$$$0(5);
        }
        if (newFileLocation == null) {
            CreateFilePathFix.$$$reportNull$$$0(6);
        }
        if (fileTextSupplier == null) {
            CreateFilePathFix.$$$reportNull$$$0(7);
        }
        this(psiElement, newFileLocation, null, "create.file.text");
        this.myFileTextSupplier = fileTextSupplier;
    }

    private void createFile(@NotNull Project project2, @NotNull PsiDirectory currentDirectory, @NotNull String fileName) throws IncorrectOperationException {
        if (project2 == null) {
            CreateFilePathFix.$$$reportNull$$$0(8);
        }
        if (currentDirectory == null) {
            CreateFilePathFix.$$$reportNull$$$0(9);
        }
        if (fileName == null) {
            CreateFilePathFix.$$$reportNull$$$0(10);
        }
        String newFileName = fileName;
        String newDirectories = null;
        if (fileName.contains("/")) {
            int pos = fileName.lastIndexOf(47);
            newFileName = fileName.substring(pos + 1);
            newDirectories = fileName.substring(0, pos);
        }
        PsiDirectory directory = currentDirectory;
        if (newDirectories != null) {
            try {
                VfsUtil.createDirectoryIfMissing(currentDirectory.getVirtualFile(), newDirectories);
                VirtualFile vfsDir = VfsUtil.findRelativeFile(currentDirectory.getVirtualFile(), ArrayUtilRt.toStringArray(StringUtil.split(newDirectories, "/")));
                if (vfsDir == null) {
                    Logger.getInstance(AbstractCreateFileFix.class).warn("Unable to find relative file" + currentDirectory.getVirtualFile().getPath());
                    return;
                }
                directory = currentDirectory.getManager().findDirectory(vfsDir);
                if (directory == null) {
                    throw new IOException("Couldn't create directory '" + newDirectories + "'");
                }
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e.getMessage());
            }
        }
        PsiFile newFile = directory.createFile(newFileName);
        String text2 = this.getFileText();
        if (text2 != null) {
            FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(newFileName);
            PsiFile psiFile = PsiFileFactory.getInstance(project2).createFileFromText("_" + newFileName, type, (CharSequence)text2);
            PsiElement psiElement = CodeStyleManager.getInstance(project2).reformat(psiFile);
            text2 = psiElement.getText();
        }
        this.openFile(project2, directory, newFile, text2);
    }

    protected void openFile(@NotNull Project project2, PsiDirectory directory, PsiFile newFile, String text2) {
        if (project2 == null) {
            CreateFilePathFix.$$$reportNull$$$0(11);
        }
        FileEditorManager editorManager = FileEditorManager.getInstance(directory.getProject());
        FileEditor[] fileEditors = editorManager.openFile(newFile.getVirtualFile(), true);
        if (text2 != null) {
            for (FileEditor fileEditor : fileEditors) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                document.setText(text2);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                PsiDocumentManager.getInstance(project2).commitDocument(document);
                break;
            }
        }
    }

    @Nullable
    protected String getFileText() {
        if (this.myFileTextSupplier != null) {
            return this.myFileTextSupplier.get();
        }
        return this.myText;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = CodeInsightBundle.message(this.myKey, this.myNewFileName);
        if (string2 == null) {
            CreateFilePathFix.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message("create.file.family", new Object[0]);
        if (string2 == null) {
            CreateFilePathFix.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            CreateFilePathFix.$$$reportNull$$$0(14);
        }
        return null;
    }

    @Override
    protected void apply(@NotNull Project project2, @NotNull PsiDirectory targetDirectory, @Nullable Editor editor2) throws IncorrectOperationException {
        if (project2 == null) {
            CreateFilePathFix.$$$reportNull$$$0(15);
        }
        if (targetDirectory == null) {
            CreateFilePathFix.$$$reportNull$$$0(16);
        }
        this.createFile(project2, targetDirectory, this.myNewFileName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileLocation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixLocaleKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTextSupplier";
                break;
            }
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/CreateFilePathFix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/CreateFilePathFix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

