/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.EditorNotificationActions;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.AssignShortcutToIntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.EditIntentionSettingsAction;
import com.intellij.codeInsight.intention.impl.EditShortcutToIntentionAction;
import com.intellij.codeInsight.intention.impl.EnableDisableIntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionShortcutManager;
import com.intellij.codeInsight.intention.impl.RemoveIntentionActionShortcut;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShowIntentionsPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myPassIdToShowIntentionsFor;
    private final IntentionsInfo myIntentionsInfo;
    private final boolean myQueryIntentionActions;
    private volatile CachedIntentions myCachedIntentions;
    private volatile boolean myActionsChanged;

    ShowIntentionsPass(@NotNull PsiFile psiFile, @NotNull Editor editor2, boolean queryIntentionActions) {
        if (psiFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(1);
        }
        super(psiFile.getProject(), editor2.getDocument(), false);
        this.myIntentionsInfo = new IntentionsInfo();
        this.myQueryIntentionActions = queryIntentionActions;
        this.myPassIdToShowIntentionsFor = -1;
        this.myEditor = editor2;
        this.myFile = psiFile;
        assert (this.myFile != null) : FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
    }

    @NotNull
    public static List<HighlightInfo.IntentionActionDescriptor> getAvailableFixes(@NotNull Editor editor2, @NotNull PsiFile file2, int passId, int offset) {
        if (editor2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(3);
        }
        Project project2 = file2.getProject();
        ArrayList<HighlightInfo.IntentionActionDescriptor> result2 = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor2.getDocument(), project2, HighlightSeverity.INFORMATION, offset, true, info -> {
            ShowIntentionsPass.addAvailableFixesForGroups(info, editor2, file2, result2, passId, offset);
            return true;
        });
        ArrayList<HighlightInfo.IntentionActionDescriptor> arrayList = result2;
        if (arrayList == null) {
            ShowIntentionsPass.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static boolean markActionInvoked(@NotNull Project project2, @NotNull Editor editor2, @NotNull IntentionAction action2) {
        if (project2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(7);
        }
        int offset = ((EditorEx)editor2).getExpectedCaretOffset();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor2.getDocument(), project2, HighlightSeverity.INFORMATION, offset, true, new CommonProcessors.CollectProcessor(infos));
        boolean removed = false;
        for (HighlightInfo info : infos) {
            if (info.quickFixActionMarkers == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                if (actionInGroup.getAction() != action2) continue;
                removed |= info.quickFixActionMarkers.remove(pair);
            }
        }
        return removed;
    }

    private static void addAvailableFixesForGroups(@NotNull HighlightInfo info, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> outList, int group, int offset) {
        HighlightInfo.IntentionActionDescriptor emptyActionDescriptor;
        if (info == null) {
            ShowIntentionsPass.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(10);
        }
        if (outList == null) {
            ShowIntentionsPass.$$$reportNull$$$0(11);
        }
        if (info.quickFixActionMarkers == null) {
            return;
        }
        if (group != -1 && group != info.getGroup()) {
            return;
        }
        boolean fixRangeIsNotEmpty = !info.getFixTextRange().isEmpty();
        Editor injectedEditor = null;
        PsiFile injectedFile = null;
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        boolean hasAvailableAction = false;
        HighlightInfo.IntentionActionDescriptor unavailableAction = null;
        for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
            PsiFile fileToUse;
            Editor editorToUse;
            HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
            RangeMarker range = (RangeMarker)pair.second;
            if (!range.isValid() || fixRangeIsNotEmpty && ShowIntentionsPass.isEmpty(range) || DumbService.isDumb(file2.getProject()) && !DumbService.isDumbAware(actionInGroup.getAction())) continue;
            int start2 = range.getStartOffset();
            int end = range.getEndOffset();
            Project project2 = file2.getProject();
            if (start2 > offset || offset > end) continue;
            if (info.isFromInjection()) {
                if (injectedEditor == null) {
                    injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
                    injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor2, injectedFile);
                }
                editorToUse = injectedFile == null ? editor2 : injectedEditor;
                fileToUse = injectedFile == null ? file2 : injectedFile;
            } else {
                editorToUse = editor2;
                fileToUse = file2;
            }
            if (indicator != null) {
                indicator.setText(actionInGroup.getDisplayName());
            }
            if (actionInGroup.getAction().isAvailable(project2, editorToUse, fileToUse)) {
                outList.add(actionInGroup);
                hasAvailableAction = true;
                continue;
            }
            if (unavailableAction != null) continue;
            unavailableAction = actionInGroup;
        }
        if (!hasAvailableAction && unavailableAction != null && (emptyActionDescriptor = unavailableAction.copyWithEmptyAction()) != null) {
            outList.add(emptyActionDescriptor);
        }
    }

    private static boolean isEmpty(@NotNull Segment segment) {
        if (segment == null) {
            ShowIntentionsPass.$$$reportNull$$$0(12);
        }
        return segment.getEndOffset() <= segment.getStartOffset();
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ShowIntentionsPass.$$$reportNull$$$0(13);
        }
        if (!UIUtil.hasFocus(this.myEditor.getContentComponent())) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (state != null && !state.isFinished()) {
            return;
        }
        ShowIntentionsPass.getActionsToShow(this.myEditor, this.myFile, this.myIntentionsInfo, this.myPassIdToShowIntentionsFor, this.myQueryIntentionActions);
        this.myCachedIntentions = IntentionsUI.getInstance(this.myProject).getCachedIntentions(this.myEditor, this.myFile);
        this.myActionsChanged = this.myCachedIntentions.wrapAndUpdateActions(this.myIntentionsInfo, false);
    }

    @Override
    public void doApplyInformationToEditor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CachedIntentions cachedIntentions = this.myCachedIntentions;
        boolean actionsChanged = this.myActionsChanged;
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if ((state == null || state.isFinished()) && cachedIntentions != null) {
            IntentionsInfo syncInfo = new IntentionsInfo();
            ShowIntentionsPass.getActionsToShowSync(this.myEditor, this.myFile, syncInfo);
            IntentionsUI.getInstance(this.myProject).update(cachedIntentions, actionsChanged |= cachedIntentions.addActions(syncInfo));
        }
    }

    @NotNull
    public static IntentionsInfo getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, boolean includeSyncActions) {
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(14);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(15);
        }
        IntentionsInfo result2 = new IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(hostEditor, hostFile, result2, -1);
        if (includeSyncActions) {
            ShowIntentionsPass.getActionsToShowSync(hostEditor, hostFile, result2);
        }
        IntentionsInfo intentionsInfo = result2;
        if (intentionsInfo == null) {
            ShowIntentionsPass.$$$reportNull$$$0(16);
        }
        return intentionsInfo;
    }

    @ApiStatus.Internal
    public static void getActionsToShowSync(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions) {
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(17);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(18);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorNotificationActions.collectActions(hostEditor, intentions);
        intentions.filterActions(hostFile);
    }

    public static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor) {
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(20);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(21);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(22);
        }
        ShowIntentionsPass.getActionsToShow(hostEditor, hostFile, intentions, passIdToShowIntentionsFor, true);
    }

    private static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor, boolean queryIntentionActions) {
        int offset;
        PsiElement psiElement;
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(23);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(24);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(25);
        }
        if ((psiElement = hostFile.findElementAt(offset = hostEditor.getCaretModel().getOffset())) != null) {
            PsiUtilCore.ensureValid(psiElement);
        }
        intentions.setOffset(offset);
        ArrayList fixes = new ArrayList();
        DaemonCodeAnalyzerImpl.HighlightByOffsetProcessor highestPriorityInfoFinder = new DaemonCodeAnalyzerImpl.HighlightByOffsetProcessor(true);
        CommonProcessors.CollectProcessor infos = new CommonProcessors.CollectProcessor();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(hostEditor.getDocument(), hostFile.getProject(), HighlightSeverity.INFORMATION, offset, true, infos);
        for (HighlightInfo info : infos.getResults()) {
            ShowIntentionsPass.addAvailableFixesForGroups(info, hostEditor, hostFile, fixes, passIdToShowIntentionsFor, offset);
            highestPriorityInfoFinder.process(info);
        }
        HighlightInfo infoAtCursor = highestPriorityInfoFinder.getResult();
        intentions.setHighlightInfoType(infoAtCursor != null ? infoAtCursor.type : null);
        if (infoAtCursor == null) {
            intentions.errorFixesToShow.addAll(fixes);
        } else {
            ShowIntentionsPass.fillIntentionsInfoForHighlightInfo(infoAtCursor, intentions, fixes);
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (queryIntentionActions) {
            PsiFile injectedFile = InjectedLanguageUtilBase.findInjectedPsiNoCommit(hostFile, offset);
            for (IntentionAction action2 : IntentionManager.getInstance().getAvailableIntentions()) {
                HighlightInfo.IntentionActionDescriptor descriptor;
                Pair<PsiFile, Editor> place;
                if (indicator != null) {
                    indicator.setText(action2.getFamilyName());
                }
                if ((place = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, injectedFile, (psiFile, editor2) -> ShowIntentionActionsHandler.availableFor(psiFile, editor2, action2))) == null) continue;
                ArrayList<IntentionAction> enableDisableIntentionAction = new ArrayList<IntentionAction>();
                enableDisableIntentionAction.add(new EnableDisableIntentionAction(action2));
                enableDisableIntentionAction.add(new EditIntentionSettingsAction(action2));
                if (IntentionShortcutManager.getInstance().hasShortcut(action2)) {
                    enableDisableIntentionAction.add(new EditShortcutToIntentionAction(action2));
                    enableDisableIntentionAction.add(new RemoveIntentionActionShortcut(action2));
                } else {
                    enableDisableIntentionAction.add(new AssignShortcutToIntentionAction(action2));
                }
                if (fixes.contains(descriptor = new HighlightInfo.IntentionActionDescriptor(action2, enableDisableIntentionAction, null, null, null, null, null))) continue;
                intentions.intentionsToShow.add(descriptor);
            }
            if (indicator != null) {
                indicator.setText(CodeInsightBundle.message("progress.text.searching.for.additional.intention.actions.quick.fixes", new Object[0]));
            }
            for (IntentionMenuContributor extension2 : IntentionMenuContributor.EP_NAME.getExtensionList()) {
                try {
                    extension2.collectActions(hostEditor, hostFile, intentions, passIdToShowIntentionsFor, offset);
                }
                catch (IntentionPreviewUnsupportedOperationException intentionPreviewUnsupportedOperationException) {}
            }
        }
        intentions.filterActions(hostFile);
    }

    public static void fillIntentionsInfoForHighlightInfo(@NotNull HighlightInfo infoAtCursor, @NotNull IntentionsInfo intentions, @NotNull List<? extends HighlightInfo.IntentionActionDescriptor> fixes) {
        if (infoAtCursor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(26);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(27);
        }
        if (fixes == null) {
            ShowIntentionsPass.$$$reportNull$$$0(28);
        }
        boolean isError = infoAtCursor.getSeverity() == HighlightSeverity.ERROR;
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : fixes) {
            if (intentionActionDescriptor.isError() && isError) {
                intentions.errorFixesToShow.add(intentionActionDescriptor);
                continue;
            }
            if (intentionActionDescriptor.isInformation()) {
                intentions.intentionsToShow.add(intentionActionDescriptor);
                continue;
            }
            intentions.inspectionFixesToShow.add(intentionActionDescriptor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoAtCursor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFixes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionsToShow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableFixes";
                break;
            }
            case 4: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markActionInvoked";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAvailableFixesForGroups";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getActionsToShow";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getActionsToShowSync";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fillIntentionsInfoForHighlightInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntentionsInfo {
        public final List<HighlightInfo.IntentionActionDescriptor> intentionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> errorFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> inspectionFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<AnAction> guttersToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> notificationActionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        private int myOffset;
        private HighlightInfoType myHighlightInfoType;

        public void filterActions(@Nullable PsiFile psiFile) {
            IntentionActionFilter[] filters = IntentionActionFilter.EXTENSION_POINT_NAME.getExtensions();
            IntentionsInfo.filter(this.intentionsToShow, psiFile, filters);
            IntentionsInfo.filter(this.errorFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.inspectionFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.notificationActionsToShow, psiFile, filters);
        }

        public void setOffset(int offset) {
            this.myOffset = offset;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public HighlightInfoType getHighlightInfoType() {
            return this.myHighlightInfoType;
        }

        public void setHighlightInfoType(HighlightInfoType highlightInfoType) {
            this.myHighlightInfoType = highlightInfoType;
        }

        private static void filter(@NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @Nullable PsiFile psiFile, IntentionActionFilter @NotNull [] filters) {
            if (descriptors == null) {
                IntentionsInfo.$$$reportNull$$$0(0);
            }
            if (filters == null) {
                IntentionsInfo.$$$reportNull$$$0(1);
            }
            Iterator<HighlightInfo.IntentionActionDescriptor> it = descriptors.iterator();
            block0: while (it.hasNext()) {
                HighlightInfo.IntentionActionDescriptor actionDescriptor = it.next();
                for (IntentionActionFilter filter2 : filters) {
                    if (filter2.accept(actionDescriptor.getAction(), psiFile)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }

        public boolean isEmpty() {
            return this.intentionsToShow.isEmpty() && this.errorFixesToShow.isEmpty() && this.inspectionFixesToShow.isEmpty() && this.guttersToShow.isEmpty() && this.notificationActionsToShow.isEmpty();
        }

        @NonNls
        public String toString() {
            return "Errors: " + this.errorFixesToShow + "; Inspection fixes: " + this.inspectionFixesToShow + "; Intentions: " + this.intentionsToShow + "; Gutters: " + this.guttersToShow + "; Notifications: " + this.notificationActionsToShow;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo";
            objectArray[2] = "filter";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

