/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.HintAction;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean hasDirtyTextRange;

    ShowAutoImportPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(1);
        }
        super(file2.getProject(), editor2.getDocument(), false);
        this.myEditor = editor2;
        ProperTextRange range = HighlightingSessionImpl.getFromCurrentIndicator(file2).getVisibleRange();
        this.myStartOffset = range.getStartOffset();
        this.myEndOffset = range.getEndOffset();
        this.myFile = file2;
        this.hasDirtyTextRange = FileStatusMap.getDirtyTextRange(editor2, 4) != null;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ShowAutoImportPass.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        ApplicationManager.getApplication().invokeLater(this::showImports);
    }

    private void showImports() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!UIUtil.hasFocus(this.myEditor.getContentComponent())) {
            return;
        }
        if (DumbService.isDumb(this.myProject) || !this.myFile.isValid()) {
            return;
        }
        if (this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid()) {
            return;
        }
        SlowOperations.allowSlowOperations(() -> this.doShowImports());
    }

    private void doShowImports() {
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        this.importUnambiguousImports(caretOffset);
        if (this.isImportHintEnabled()) {
            List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myStartOffset, this.myEndOffset, this.myProject, this.myEditor, this.hasDirtyTextRange);
            for (int i = visibleHighlights.size() - 1; i >= 0; --i) {
                HighlightInfo info = visibleHighlights.get(i);
                if (info.startOffset > caretOffset || !this.showAddImportHint(info)) continue;
                return;
            }
            for (HighlightInfo visibleHighlight : visibleHighlights) {
                if (visibleHighlight.startOffset <= caretOffset || !this.showAddImportHint(visibleHighlight)) continue;
                return;
            }
        }
    }

    private void importUnambiguousImports(int caretOffset) {
        if (!ShowAutoImportPass.mayAutoImportNow(this.myFile)) {
            return;
        }
        Document document = this.myEditor.getDocument();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, this.myProject, null, 0, document.getTextLength(), info -> {
            if (info.hasHint() && info.getSeverity() == HighlightSeverity.ERROR && !info.getFixTextRange().containsOffset(caretOffset)) {
                infos.add(info);
            }
            return true;
        });
        for (HighlightInfo info2 : infos) {
            HintAction action2;
            Iterator<HintAction> iterator = ShowAutoImportPass.extractHints(info2).iterator();
            while (!(!iterator.hasNext() || (action2 = iterator.next()).isAvailable(this.myProject, this.myEditor, this.myFile) && action2.fixSilently(this.myEditor))) {
            }
        }
    }

    public static boolean mayAutoImportNow(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ShowAutoImportPass.$$$reportNull$$$0(3);
        }
        return ShowAutoImportPass.isAddUnambiguousImportsOnTheFlyEnabled(psiFile) && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently(psiFile)) && ShowAutoImportPass.isInModelessContext(psiFile.getProject());
    }

    private static boolean isInModelessContext(@NotNull Project project2) {
        if (project2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(4);
        }
        return Registry.is("ide.perProjectModality") ? !LaterInvocator.isInModalContextForProject(project2) : !LaterInvocator.isInModalContext();
    }

    public static boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile psiFile) {
        PsiFile templateFile;
        if (psiFile == null) {
            ShowAutoImportPass.$$$reportNull$$$0(5);
        }
        if ((templateFile = PsiUtilCore.getTemplateLanguageFile(psiFile)) == null) {
            return false;
        }
        return ContainerUtil.exists(ReferenceImporter.EP_NAME.getExtensionList(), importer -> importer.isAddUnambiguousImportsOnTheFlyEnabled(psiFile));
    }

    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(int startOffset, int endOffset, @NotNull Project project2, @NotNull Editor editor2, boolean isDirty) {
        if (project2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(7);
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        int offset = editor2.getCaretModel().getOffset();
        DaemonCodeAnalyzerEx.processHighlights(editor2.getDocument(), project2, null, startOffset, endOffset, info -> {
            if (!isDirty && !info.getFixTextRange().contains(offset)) {
                return true;
            }
            if (info.hasHint() && !editor2.getFoldingModel().isOffsetCollapsed(info.startOffset)) {
                highlights.add((HighlightInfo)info);
            }
            return true;
        });
        ArrayList<HighlightInfo> arrayList = highlights;
        if (arrayList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private boolean showAddImportHint(@NotNull HighlightInfo info) {
        PsiElement element2;
        if (info == null) {
            ShowAutoImportPass.$$$reportNull$$$0(9);
        }
        if ((element2 = this.myFile.findElementAt(info.startOffset)) == null || !element2.isValid()) {
            return false;
        }
        for (HintAction action2 : ShowAutoImportPass.extractHints(info)) {
            if (!action2.isAvailable(this.myProject, this.myEditor, this.myFile) || !action2.showHint(this.myEditor)) continue;
            return true;
        }
        return false;
    }

    public static void fixAllImportsSilently(@NotNull PsiFile file2, @NotNull List<? extends HintAction> actions2) {
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(10);
        }
        if (actions2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(11);
        }
        if (actions2.isEmpty()) {
            return;
        }
        Document document = PsiDocumentManager.getInstance(file2.getProject()).getDocument(file2);
        if (document == null) {
            return;
        }
        ImaginaryEditor editor2 = new ImaginaryEditor(file2.getProject(), document);
        for (HintAction hintAction : actions2) {
            hintAction.fixSilently((Editor)editor2);
        }
    }

    @NotNull
    public static List<HintAction> getImportHints(@NotNull PsiFile file2) {
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(12);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            throw new IllegalStateException("Must not be run from within EDT");
        }
        Project project2 = file2.getProject();
        Document document = PsiDocumentManager.getInstance(project2).getDocument(file2);
        if (document == null || InjectedLanguageManager.getInstance(project2).isInjectedFragment(file2) || !ShowAutoImportPass.hasUnresolvedReferences(file2)) {
            List<HintAction> list2 = Collections.emptyList();
            if (list2 == null) {
                ShowAutoImportPass.$$$reportNull$$$0(13);
            }
            return list2;
        }
        ArrayList<HintAction> result2 = new ArrayList<HintAction>();
        HighlightInfo fakeInfo = new HighlightInfo(null, null, HighlightInfoType.ERROR, 0, 0, null, null, HighlightSeverity.ERROR, false, null, false, 0, null, null, null, -1);
        final QuickFixActionRegistrarImpl registrar = new QuickFixActionRegistrarImpl(fakeInfo);
        file2.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (element2 instanceof PsiReference && ((PsiReference)((Object)element2)).resolve() == null) {
                    UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)((Object)element2), registrar);
                }
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass$1", "visitElement"));
            }
        });
        if (fakeInfo.quickFixActionRanges != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> marker : fakeInfo.quickFixActionRanges) {
                ProgressManager.checkCanceled();
                IntentionAction action2 = ((HighlightInfo.IntentionActionDescriptor)marker.first).getAction();
                if (!(action2 instanceof HintAction) || !action2.isAvailable(project2, null, file2)) continue;
                result2.add((HintAction)action2);
            }
        }
        ArrayList<HintAction> arrayList = result2;
        if (arrayList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static boolean hasUnresolvedReferences(@NotNull PsiFile file2) {
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(15);
        }
        if (file2 instanceof PsiCompiledElement) {
            return false;
        }
        final Ref<Boolean> result2 = new Ref<Boolean>(false);
        file2.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (PsiReference reference2 : element2.getReferences()) {
                    if (reference2.resolve() != null) continue;
                    result2.set(true);
                    this.stopWalking();
                    break;
                }
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass$2", "visitElement"));
            }
        });
        return result2.get();
    }

    private boolean isImportHintEnabled() {
        return DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled() && DaemonCodeAnalyzer.getInstance(this.myProject).isImportHintsEnabled(this.myFile);
    }

    @NotNull
    private static List<HintAction> extractHints(@NotNull HighlightInfo info) {
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> list2;
        if (info == null) {
            ShowAutoImportPass.$$$reportNull$$$0(16);
        }
        if ((list2 = info.quickFixActionRanges) == null) {
            List<HintAction> list3 = Collections.emptyList();
            if (list3 == null) {
                ShowAutoImportPass.$$$reportNull$$$0(17);
            }
            return list3;
        }
        SmartList<HintAction> hintActions = new SmartList<HintAction>();
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : list2) {
            IntentionAction action2 = pair.getFirst().getAction();
            if (!(action2 instanceof HintAction)) continue;
            hintActions.add((HintAction)action2);
        }
        SmartList<HintAction> smartList = hintActions;
        if (smartList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    @NotNull
    @NlsContexts.HintText
    public static String getMessage(boolean multiple, @NotNull String name2) {
        if (name2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(19);
        }
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        Object hintText = DaemonBundle.message(messageKey, name2);
        Object object = hintText = (String)hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (object == null) {
            ShowAutoImportPass.$$$reportNull$$$0(20);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleHighlights";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportHints";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHints";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mayAutoImportNow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInModelessContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAddUnambiguousImportsOnTheFlyEnabled";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleHighlights";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showAddImportHint";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixAllImportsSilently";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getImportHints";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedReferences";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractHints";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

