/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainPassesRunner {
    private static final Logger LOG = Logger.getInstance(MainPassesRunner.class);
    private final Project myProject;
    @NlsContexts.DialogTitle
    private final String myTitle;
    private final InspectionProfile myInspectionProfile;

    public MainPassesRunner(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title, @Nullable InspectionProfile inspectionProfile) {
        if (project2 == null) {
            MainPassesRunner.$$$reportNull$$$0(0);
        }
        if (title == null) {
            MainPassesRunner.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myTitle = title;
        this.myInspectionProfile = inspectionProfile;
    }

    @NotNull
    public Map<Document, List<HighlightInfo>> runMainPasses(final @NotNull List<? extends VirtualFile> filesToCheck) {
        if (filesToCheck == null) {
            MainPassesRunner.$$$reportNull$$$0(2);
        }
        final HashMap<Document, List<HighlightInfo>> result2 = new HashMap<Document, List<HighlightInfo>>();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                throw new RuntimeException("Must not run under write action");
            }
            final Ref exception = Ref.create();
            ProgressManager.getInstance().run(new Task.Modal(this.myProject, this.myTitle, true){

                @Override
                public void run(@NotNull ProgressIndicator progress) {
                    if (progress == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        MainPassesRunner.this.runMainPasses(filesToCheck, (Map<? super Document, List<HighlightInfo>>)result2, progress);
                    }
                    catch (ProcessCanceledException e) {
                        LOG.info("Code analysis canceled", e);
                        exception.set(e);
                    }
                    catch (Exception e) {
                        LOG.error(e);
                        exception.set(e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/MainPassesRunner$1", "run"));
                }
            });
            if (!exception.isNull()) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)exception.get());
            }
        } else if (ProgressManager.getInstance().hasProgressIndicator()) {
            this.runMainPasses(filesToCheck, result2, ProgressManager.getInstance().getProgressIndicator());
        } else {
            throw new RuntimeException("Must run from Event Dispatch Thread or with a progress indicator");
        }
        HashMap<Document, List<HighlightInfo>> hashMap = result2;
        if (hashMap == null) {
            MainPassesRunner.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMainPasses(@NotNull List<? extends VirtualFile> files2, @NotNull Map<? super Document, List<HighlightInfo>> result2, @NotNull ProgressIndicator progress) {
        if (files2 == null) {
            MainPassesRunner.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            MainPassesRunner.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            MainPassesRunner.$$$reportNull$$$0(6);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        block5: for (int i = 0; i < files2.size(); ++i) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)progress);
            VirtualFile file2 = files2.get(i);
            progress.setText(ProjectUtil.calcRelativeToProjectPath((VirtualFile)file2, (Project)this.myProject));
            progress.setFraction((double)i / (double)files2.size());
            while (true) {
                Disposable disposable = Disposer.newDisposable();
                try {
                    final DaemonProgressIndicator daemonIndicator = new DaemonProgressIndicator();
                    GlobalInspectionContextImpl.setupCancelOnWriteProgress(disposable, daemonIndicator);
                    ((ProgressIndicatorEx)progress).addStateDelegate(new AbstractProgressIndicatorExBase(){

                        @Override
                        public void cancel() {
                            super.cancel();
                            daemonIndicator.cancel();
                        }
                    });
                    this.runMainPasses(file2, result2, daemonIndicator);
                    continue block5;
                }
                catch (ProcessCanceledException e) {
                    if (!progress.isCanceled()) continue;
                    throw e;
                }
                finally {
                    Disposer.dispose(disposable);
                    continue;
                }
                break;
            }
        }
    }

    private void runMainPasses(@NotNull VirtualFile file2, @NotNull Map<? super Document, List<HighlightInfo>> result2, @NotNull DaemonProgressIndicator daemonIndicator) {
        if (file2 == null) {
            MainPassesRunner.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            MainPassesRunner.$$$reportNull$$$0(8);
        }
        if (daemonIndicator == null) {
            MainPassesRunner.$$$reportNull$$$0(9);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        PsiFile psiFile = ReadAction.compute(() -> PsiManager.getInstance(this.myProject).findFile(file2));
        Document document = ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file2));
        if (psiFile == null || document == null || !ReadAction.compute(() -> ProblemHighlightFilter.shouldProcessFileInBatch(psiFile)).booleanValue()) {
            return;
        }
        ProperTextRange range = ReadAction.compute(() -> ProperTextRange.create(0, document.getTextLength()));
        HighlightingSessionImpl.createHighlightingSession(psiFile, daemonIndicator, null, range, false);
        ProgressManager.getInstance().runProcess(() -> this.runMainPasses(daemonIndicator, result2, psiFile, document), (ProgressIndicator)daemonIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMainPasses(@NotNull ProgressIndicator daemonIndicator, @NotNull Map<? super Document, List<HighlightInfo>> result2, @NotNull PsiFile psiFile, @NotNull Document document) {
        if (daemonIndicator == null) {
            MainPassesRunner.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            MainPassesRunner.$$$reportNull$$$0(11);
        }
        if (psiFile == null) {
            MainPassesRunner.$$$reportNull$$$0(12);
        }
        if (document == null) {
            MainPassesRunner.$$$reportNull$$$0(13);
        }
        Project project2 = psiFile.getProject();
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
        ProcessCanceledException exception = null;
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        int retries = 100;
        for (int i = 0; i < retries; ++i) {
            int oldDelay = settings.getAutoReparseDelay();
            try {
                InspectionProfile currentProfile = this.myInspectionProfile;
                settings.setAutoReparseDelay(0);
                Function<InspectionProfile, InspectionProfileWrapper> profileProvider = p -> currentProfile == null ? new InspectionProfileWrapper((InspectionProfileImpl)p) : new InspectionProfileWrapper(currentProfile, ((InspectionProfileImpl)p).getProfileManager());
                InspectionProfileWrapper.runWithCustomInspectionWrapper(psiFile, profileProvider, () -> {
                    List<HighlightInfo> infos = codeAnalyzer.runMainPasses(psiFile, document, daemonIndicator);
                    result2.computeIfAbsent(document, __ -> new ArrayList()).addAll(infos);
                });
                break;
            }
            catch (ProcessCanceledException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause.getClass() != Throwable.class) {
                    throw e;
                }
                exception = e;
                continue;
            }
            finally {
                settings.setAutoReparseDelay(oldDelay);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToCheck";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/MainPassesRunner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonIndicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/MainPassesRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runMainPasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runMainPasses";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

