/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.InspectionRunner;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.diagnostic.PluginException;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.markup.UnmodifiableTextAttributes;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Interner;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(LocalInspectionsPass.class);
    private final TextRange myPriorityRange;
    private final boolean myIgnoreSuppressed;
    private volatile List<? extends HighlightInfo> myInfos;
    private final InspectionProfileWrapper myProfileWrapper;
    private final Map<String, Set<PsiElement>> mySuppressedElements;
    private final boolean myInspectInjectedPsi;
    private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES = new UnmodifiableTextAttributes(){

        @Override
        public boolean isEmpty() {
            return false;
        }
    };
    private final Long2ObjectMap<RangeMarker> ranges2markersCache;
    private final InjectedLanguageManager myInjectedLanguageManager;
    private final List<HighlightInfo> infos;
    private final PsiDocumentManager documentManager;
    private final Set<Pair<TextRange, String>> emptyActionRegistered;
    private static final Interner<String> tooltips = Interner.createWeakInterner();

    LocalInspectionsPass(@NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, @NotNull TextRange priorityRange, boolean ignoreSuppressed, @NotNull HighlightInfoProcessor highlightInfoProcessor, boolean inspectInjectedPsi) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            LocalInspectionsPass.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(2);
        }
        if (highlightInfoProcessor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(3);
        }
        super(file2.getProject(), document, DaemonBundle.message("pass.inspection", new Object[0]), file2, null, new TextRange(startOffset, endOffset), true, highlightInfoProcessor);
        this.myInfos = Collections.emptyList();
        this.mySuppressedElements = new ConcurrentHashMap<String, Set<PsiElement>>();
        this.ranges2markersCache = new Long2ObjectOpenHashMap<RangeMarker>();
        this.myInjectedLanguageManager = InjectedLanguageManager.getInstance(this.myProject);
        this.infos = new ArrayList<HighlightInfo>(2);
        this.documentManager = PsiDocumentManager.getInstance(this.myProject);
        this.emptyActionRegistered = Collections.synchronizedSet(new HashSet());
        assert (file2.isPhysical()) : "can't inspect non-physical file: " + file2 + "; " + file2.getVirtualFile();
        this.myPriorityRange = priorityRange;
        this.myIgnoreSuppressed = ignoreSuppressed;
        this.setId(7);
        InspectionProfileImpl profileToUse = ProjectInspectionProfileManager.getInstance(this.myProject).getCurrentProfile();
        Function<? super InspectionProfile, ? extends InspectionProfileWrapper> custom = InspectionProfileWrapper.getCustomInspectionProfileWrapper(file2);
        InspectionProfileWrapper inspectionProfileWrapper = this.myProfileWrapper = custom == null ? new InspectionProfileWrapper(profileToUse) : custom.apply(profileToUse);
        assert (this.myProfileWrapper != null);
        this.myInspectInjectedPsi = inspectInjectedPsi;
        this.setProgressLimit(600L);
    }

    @NotNull
    private static String getShortcutText() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        Object myShortcutText = keymapManager == null ? "" : "(" + KeymapUtil.getShortcutsText((Shortcut[])keymapManager.getActiveKeymap().getShortcuts("ShowErrorDescription")) + ")";
        String string2 = myShortcutText;
        if (string2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            LocalInspectionsPass.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        List<LocalInspectionToolWrapper> toolWrappers;
        if (progress == null) {
            LocalInspectionsPass.$$$reportNull$$$0(6);
        }
        if ((toolWrappers = this.getInspectionTools(this.myProfileWrapper)).isEmpty()) {
            return;
        }
        Consumer<InspectionRunner.InspectionContext> afterInsideProcessedCallback = context2 -> {
            InspectionRunner.InspectionProblemHolder holder = context2.holder;
            holder.applyIncrementally = false;
            this.advanceProgress(1L);
        };
        Consumer<InspectionRunner.InspectionContext> afterOutsideProcessedCallback = __ -> this.advanceProgress(1L);
        BiPredicate<ProblemDescriptor, LocalInspectionToolWrapper> applyIncrementallyCallback = (descriptor, wrapper2) -> {
            this.addDescriptorIncrementally((ProblemDescriptor)descriptor, (LocalInspectionToolWrapper)wrapper2, progress);
            return true;
        };
        InspectionRunner runner = new InspectionRunner(this.getFile(), this.myRestrictRange, this.myPriorityRange, this.myInspectInjectedPsi, true, progress, this.myIgnoreSuppressed, this.myProfileWrapper, this.mySuppressedElements);
        List<? extends InspectionRunner.InspectionContext> contexts = runner.inspect(toolWrappers, true, applyIncrementallyCallback, afterInsideProcessedCallback, afterOutsideProcessedCallback);
        ProgressManager.checkCanceled();
        this.myInfos = this.createHighlightsFromContexts(contexts);
    }

    @Nullable
    private HighlightInfo highlightInfoFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightInfoType highlightInfoType, @NotNull @NlsContexts.DetailedDescription String message2, @Nullable @NlsContexts.Tooltip String toolTip, @NotNull PsiElement psiElement, @NotNull List<IntentionAction> quickFixes, @NotNull HighlightDisplayKey key, @Nullable EditorColorsScheme editorColorsScheme, @NotNull SeverityRegistrar severityRegistrar) {
        TextRange textRange;
        if (problemDescriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(7);
        }
        if (highlightInfoType == null) {
            LocalInspectionsPass.$$$reportNull$$$0(8);
        }
        if (message2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(9);
        }
        if (psiElement == null) {
            LocalInspectionsPass.$$$reportNull$$$0(10);
        }
        if (quickFixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(11);
        }
        if (key == null) {
            LocalInspectionsPass.$$$reportNull$$$0(12);
        }
        if (severityRegistrar == null) {
            LocalInspectionsPass.$$$reportNull$$$0(13);
        }
        if ((textRange = ((ProblemDescriptorBase)problemDescriptor).getTextRange()) == null) {
            return null;
        }
        boolean isFileLevel = psiElement instanceof PsiFile && textRange.equals(psiElement.getTextRange());
        HighlightSeverity severity = highlightInfoType.getSeverity(psiElement);
        TextAttributesKey attributesKey = ((ProblemDescriptorBase)problemDescriptor).getEnforcedTextAttributes();
        if (problemDescriptor.getHighlightType() == ProblemHighlightType.GENERIC_ERROR_OR_WARNING && attributesKey == null) {
            attributesKey = this.myProfileWrapper.getInspectionProfile().getEditorAttributes(key.toString(), this.myFile);
        }
        TextAttributes attributes = attributesKey == null || editorColorsScheme == null || severity.getName().equals(attributesKey.getExternalName()) ? severityRegistrar.getTextAttributesBySeverity(severity) : editorColorsScheme.getAttributes(attributesKey);
        HighlightInfo.Builder b = HighlightInfo.newHighlightInfo(highlightInfoType).range(psiElement, textRange.getStartOffset(), textRange.getEndOffset()).description(message2).severity(severity).inspectionToolId(key.getID());
        if (toolTip != null) {
            b.escapedToolTip(toolTip);
        }
        if (HighlightSeverity.INFORMATION.equals(severity) && attributes == null && toolTip == null && !quickFixes.isEmpty()) {
            attributes = NONEMPTY_TEXT_ATTRIBUTES;
        }
        if (attributes != null) {
            b.textAttributes(attributes);
        }
        if (problemDescriptor.isAfterEndOfLine()) {
            b.endOfLine();
        }
        if (isFileLevel) {
            b.fileLevelAnnotation();
        }
        if (problemDescriptor.getProblemGroup() != null) {
            b.problemGroup(problemDescriptor.getProblemGroup());
        }
        return b.create();
    }

    private void addDescriptorIncrementally(@NotNull ProblemDescriptor descriptor, @NotNull LocalInspectionToolWrapper tool, @NotNull ProgressIndicator indicator) {
        PsiElement psiElement;
        if (descriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(14);
        }
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(16);
        }
        if (this.myIgnoreSuppressed) {
            LocalInspectionToolWrapper toolWrapper = tool;
            PsiElement psiElement2 = descriptor.getPsiElement();
            if (descriptor instanceof ProblemDescriptorWithReporterName) {
                String reportingToolName = ((ProblemDescriptorWithReporterName)descriptor).getReportingToolName();
                toolWrapper = (LocalInspectionToolWrapper)this.myProfileWrapper.getInspectionTool(reportingToolName, psiElement2);
            }
            if (((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(psiElement2)) {
                LocalInspectionsPass.registerSuppressedElements(psiElement2, toolWrapper.getID(), toolWrapper.getAlternativeID(), this.mySuppressedElements);
                return;
            }
        }
        if ((psiElement = descriptor.getPsiElement()) == null) {
            return;
        }
        PsiFile file2 = psiElement.getContainingFile();
        Document thisDocument = Objects.requireNonNull(this.documentManager.getDocument(file2));
        HighlightDisplayKey displayKey = tool.getDisplayKey();
        if (displayKey == null) {
            LOG.error("getDisplayKey() is null for " + tool + " (" + tool.getTool() + " ; " + ((LocalInspectionTool)tool.getTool()).getClass() + ")");
            return;
        }
        HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(displayKey, file2).getSeverity();
        ArrayList newInfos = new ArrayList(2);
        this.createHighlightsForDescriptor(newInfos, this.emptyActionRegistered, file2, thisDocument, tool, severity, descriptor, psiElement);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.infos.clear();
            this.infos.addAll(newInfos);
            for (HighlightInfo info : this.infos) {
                EditorColorsScheme colorsScheme = this.getColorsScheme();
                UpdateHighlightersUtil.addHighlighterToEditorIncrementally(this.myProject, this.myDocument, this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), info, colorsScheme, this.getId(), this.ranges2markersCache);
            }
        }, __ -> this.myProject.isDisposed() || indicator.isCanceled());
    }

    @Override
    protected void applyInformationWithProgress() {
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myInfos, this.getColorsScheme(), this.getId());
    }

    @NotNull
    private List<HighlightInfo> createHighlightsFromContexts(@NotNull List<? extends InspectionRunner.InspectionContext> contexts) {
        if (contexts == null) {
            LocalInspectionsPass.$$$reportNull$$$0(17);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.myProject);
        HashSet emptyActionRegistered = new HashSet();
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>();
        for (InspectionRunner.InspectionContext inspectionContext : contexts) {
            ProgressManager.checkCanceled();
            PsiFile file2 = inspectionContext.holder.getFile();
            Document documentRange = documentManager.getDocument(file2);
            if (documentRange == null) continue;
            LocalInspectionToolWrapper toolWrapper = inspectionContext.tool;
            for (ProblemDescriptor descriptor : inspectionContext.holder.getResults()) {
                ProgressManager.checkCanceled();
                PsiElement element2 = descriptor.getPsiElement();
                if (element2 == null || SuppressionUtil.inspectionResultSuppressed(element2, (LocalInspectionTool)toolWrapper.getTool())) continue;
                this.createHighlightsForDescriptor(result2, emptyActionRegistered, file2, documentRange, toolWrapper, descriptor, element2);
            }
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private void createHighlightsForDescriptor(@NotNull List<? super HighlightInfo> outInfos, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull ProblemDescriptor descriptor, @NotNull PsiElement element2) {
        HighlightSeverity severity;
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(19);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(21);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(22);
        }
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(23);
        }
        if (descriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(24);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(25);
        }
        if (descriptor instanceof ProblemDescriptorWithReporterName) {
            String reportingToolName = ((ProblemDescriptorWithReporterName)descriptor).getReportingToolName();
            InspectionToolWrapper<?, ?> reportingTool = this.myProfileWrapper.getInspectionTool(reportingToolName, element2);
            LOG.assertTrue(reportingTool instanceof LocalInspectionToolWrapper, reportingToolName);
            toolWrapper = (LocalInspectionToolWrapper)reportingTool;
            severity = this.myProfileWrapper.getErrorLevel(HighlightDisplayKey.find(reportingToolName), file2).getSeverity();
        } else {
            severity = this.myProfileWrapper.getErrorLevel(toolWrapper.getDisplayKey(), file2).getSeverity();
        }
        if (this.myIgnoreSuppressed && ((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(element2)) {
            LocalInspectionsPass.registerSuppressedElements(element2, toolWrapper.getID(), toolWrapper.getAlternativeID(), this.mySuppressedElements);
            return;
        }
        this.createHighlightsForDescriptor(outInfos, emptyActionRegistered, file2, documentRange, toolWrapper, severity, descriptor, element2);
    }

    private void createHighlightsForDescriptor(@NotNull List<? super HighlightInfo> outInfos, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor, @NotNull PsiElement element2) {
        boolean isInInjected;
        List<IntentionAction> fixes;
        HighlightInfo info;
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(26);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(28);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(29);
        }
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(30);
        }
        if (severity == null) {
            LocalInspectionsPass.$$$reportNull$$$0(31);
        }
        if (descriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(32);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(33);
        }
        SeverityRegistrar severityRegistrar = this.myProfileWrapper.getProfileManager().getSeverityRegistrar();
        HighlightInfoType level = ProblemDescriptorUtil.highlightTypeFromDescriptor(descriptor, severity, severityRegistrar);
        ProblemDescriptorUtil.ProblemPresentation presentation2 = ProblemDescriptorUtil.renderDescriptor(descriptor, element2, 0);
        String message2 = presentation2.getDescription();
        ProblemGroup problemGroup = descriptor.getProblemGroup();
        String problemName = problemGroup != null ? problemGroup.getProblemName() : null;
        String shortName = problemName != null ? problemName : toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
        InspectionProfile inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key, file2)) {
            return;
        }
        InspectionHighlightInfoType type = new InspectionHighlightInfoType(level, element2);
        String plainMessage = message2.startsWith("<html>") ? StringUtil.unescapeXmlEntities(XmlStringUtil.stripHtml(message2).replaceAll("<[^>]*>", "")).replaceAll("&nbsp;", " ") : message2;
        String tooltip = null;
        if (descriptor.showTooltip()) {
            String rendered = presentation2.getTooltip();
            tooltip = tooltips.intern(DaemonTooltipsUtil.getWrappedTooltip(rendered, shortName, LocalInspectionsPass.getShortcutText(), LocalInspectionsPass.showToolDescription(toolWrapper)));
        }
        if ((info = this.highlightInfoFromDescriptor(descriptor, type, plainMessage, tooltip, element2, fixes = LocalInspectionsPass.getQuickFixes(key, descriptor, emptyActionRegistered), key, this.getColorsScheme(), severityRegistrar)) == null) {
            return;
        }
        LocalInspectionsPass.registerQuickFixes(info, fixes, shortName);
        PsiFile context2 = LocalInspectionsPass.getTopLevelFileInBaseLanguage(element2, file2.getProject());
        PsiFile myContext = LocalInspectionsPass.getTopLevelFileInBaseLanguage(file2, file2.getProject());
        if (context2 != myContext) {
            String errorMessage = "Reported element " + element2 + " is not from the file '" + file2.getVirtualFile().getPath() + "' the inspection '" + shortName + "' (" + ((LocalInspectionTool)toolWrapper.getTool()).getClass() + ") was invoked for. Message: '" + descriptor + "'.\nElement containing file: " + context2 + "\nInspection invoked for file: " + myContext + "\n";
            PluginException.logPluginError(LOG, errorMessage, null, ((LocalInspectionTool)toolWrapper.getTool()).getClass());
        }
        boolean bl = isInInjected = this.myInspectInjectedPsi && file2.getViewProvider() instanceof InjectedFileViewProvider;
        if (isInInjected) {
            this.injectToHost(outInfos, file2, documentRange, element2, fixes, info, shortName);
        } else {
            outInfos.add(info);
        }
    }

    private static void registerSuppressedElements(@NotNull PsiElement element2, @NotNull String id2, @Nullable String alternativeID, @NotNull Map<? super String, Set<PsiElement>> outSuppressedElements) {
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(34);
        }
        if (id2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(35);
        }
        if (outSuppressedElements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(36);
        }
        outSuppressedElements.computeIfAbsent(id2, __ -> new HashSet()).add(element2);
        if (alternativeID != null) {
            outSuppressedElements.computeIfAbsent(alternativeID, __ -> new HashSet()).add(element2);
        }
    }

    private void injectToHost(@NotNull List<? super HighlightInfo> outInfos, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull PsiElement element2, @NotNull List<? extends IntentionAction> fixes, @NotNull HighlightInfo info, @NotNull String shortName) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(38);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(39);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(40);
        }
        if (fixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(41);
        }
        if (info == null) {
            LocalInspectionsPass.$$$reportNull$$$0(42);
        }
        if (shortName == null) {
            LocalInspectionsPass.$$$reportNull$$$0(43);
        }
        List<TextRange> editables = this.myInjectedLanguageManager.intersectWithAllEditableFragments(file2, new TextRange(info.startOffset, info.endOffset));
        for (TextRange editable : editables) {
            String toolTip;
            TextRange hostRange = ((DocumentWindow)documentRange).injectedToHost(editable);
            int start2 = hostRange.getStartOffset();
            int end = hostRange.getEndOffset();
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(info.type).range(element2, start2, end);
            String description = info.getDescription();
            if (description != null) {
                builder2.description(description);
            }
            if ((toolTip = info.getToolTip()) != null) {
                builder2.escapedToolTip(toolTip);
            }
            HighlightInfo patched = builder2.createUnconditionally();
            if (patched.startOffset == patched.endOffset && info.startOffset != info.endOffset) continue;
            patched.markFromInjection();
            LocalInspectionsPass.registerQuickFixes(patched, fixes, shortName);
            outInfos.add(patched);
        }
    }

    private static PsiFile getTopLevelFileInBaseLanguage(@NotNull PsiElement element2, @NotNull Project project2) {
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(44);
        }
        if (project2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(45);
        }
        PsiFile file2 = InjectedLanguageManager.getInstance(project2).getTopLevelFile(element2);
        FileViewProvider viewProvider = file2.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    private static boolean showToolDescription(@NotNull LocalInspectionToolWrapper tool) {
        String staticDescription;
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(46);
        }
        return (staticDescription = tool.getStaticDescription()) == null || !staticDescription.isEmpty();
    }

    private static void registerQuickFixes(@NotNull HighlightInfo highlightInfo, @NotNull List<? extends IntentionAction> quickFixes, @NotNull String shortName) {
        if (highlightInfo == null) {
            LocalInspectionsPass.$$$reportNull$$$0(47);
        }
        if (quickFixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(48);
        }
        if (shortName == null) {
            LocalInspectionsPass.$$$reportNull$$$0(49);
        }
        HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
        for (IntentionAction intentionAction : quickFixes) {
            QuickFixAction.registerQuickFixAction(highlightInfo, intentionAction, key);
        }
    }

    @NotNull
    private static List<IntentionAction> getQuickFixes(@NotNull HighlightDisplayKey key, @NotNull ProblemDescriptor descriptor, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered) {
        HintAction hintAction;
        if (key == null) {
            LocalInspectionsPass.$$$reportNull$$$0(50);
        }
        if (descriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(51);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(52);
        }
        SmartList<IntentionAction> result2 = new SmartList<IntentionAction>();
        boolean needEmptyAction = true;
        Object[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length != 0) {
            for (int k = 0; k < fixes.length; ++k) {
                QuickFix fix2 = fixes[k];
                if (fix2 == null) {
                    throw new IllegalStateException("Inspection " + key + " returns null quick fix in its descriptor: " + descriptor + "; array: " + Arrays.toString(fixes));
                }
                result2.add(QuickFixWrapper.wrap(descriptor, k));
                needEmptyAction = false;
            }
        }
        HintAction hintAction2 = hintAction = descriptor instanceof ProblemDescriptorImpl ? ((ProblemDescriptorImpl)descriptor).getHintAction() : null;
        if (hintAction != null) {
            result2.add(hintAction);
            needEmptyAction = false;
        }
        if (((ProblemDescriptorBase)descriptor).getEnforcedTextAttributes() != null) {
            needEmptyAction = false;
        }
        if (needEmptyAction && emptyActionRegistered.add(Pair.create(((ProblemDescriptorBase)descriptor).getTextRange(), key.toString()))) {
            String displayNameByKey = HighlightDisplayKey.getDisplayNameByKey(key);
            LOG.assertTrue(displayNameByKey != null, key.toString());
            EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(displayNameByKey);
            result2.add(emptyIntentionAction);
        }
        SmartList<IntentionAction> smartList = result2;
        if (smartList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(53);
        }
        return smartList;
    }

    @NotNull
    List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
        if (profile == null) {
            LocalInspectionsPass.$$$reportNull$$$0(54);
        }
        List<InspectionToolWrapper<?, ?>> toolWrappers = profile.getInspectionProfile().getInspectionTools(this.getFile());
        InspectionProfileWrapper.checkInspectionsDuplicates(toolWrappers);
        ArrayList<LocalInspectionToolWrapper> enabled = new ArrayList<LocalInspectionToolWrapper>();
        for (InspectionToolWrapper<?, ?> toolWrapper : toolWrappers) {
            LocalInspectionToolWrapper wrapper2;
            HighlightDisplayKey key;
            ProgressManager.checkCanceled();
            if (toolWrapper instanceof LocalInspectionToolWrapper && !this.isAcceptableLocalTool((LocalInspectionToolWrapper)toolWrapper) || !profile.isToolEnabled(key = toolWrapper.getDisplayKey(), this.getFile()) || HighlightDisplayLevel.DO_NOT_SHOW.equals(profile.getErrorLevel(key, this.getFile()))) continue;
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                wrapper2 = (LocalInspectionToolWrapper)toolWrapper;
            } else {
                wrapper2 = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
                if (wrapper2 == null || !this.isAcceptableLocalTool(wrapper2)) continue;
            }
            String language = wrapper2.getLanguage();
            if (language != null && Language.findLanguageByID(language) == null || this.myIgnoreSuppressed && ((LocalInspectionTool)wrapper2.getTool()).isSuppressedFor(this.getFile())) continue;
            enabled.add(wrapper2);
        }
        ArrayList<LocalInspectionToolWrapper> arrayList = enabled;
        if (arrayList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
        if (wrapper2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(56);
        }
        return true;
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list2 = Collections.unmodifiableList(this.myInfos);
        if (list2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(57);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 53: 
            case 55: 
            case 57: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 53: 
            case 55: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 53: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 11: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 12: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 14: 
            case 24: 
            case 32: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 19: 
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInfos";
                break;
            }
            case 20: 
            case 27: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyActionRegistered";
                break;
            }
            case 22: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentRange";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 25: 
            case 33: 
            case 34: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSuppressedElements";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightsFromContexts";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 53: 
            case 55: 
            case 57: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "highlightInfoFromDescriptor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorIncrementally";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightsFromContexts";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightsForDescriptor";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerSuppressedElements";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "injectToHost";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFileInBaseLanguage";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "showToolDescription";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFixes";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTools";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableLocalTool";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 53: 
            case 55: 
            case 57: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InspectionHighlightInfoType
    extends HighlightInfoType.HighlightInfoTypeImpl {
        InspectionHighlightInfoType(@NotNull HighlightInfoType level, @NotNull PsiElement element2) {
            if (level == null) {
                InspectionHighlightInfoType.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                InspectionHighlightInfoType.$$$reportNull$$$0(1);
            }
            super(level.getSeverity(element2), level.getAttributesKey());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionHighlightInfoType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

