/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LineMarkersUtil {
    private static final Logger LOG = Logger.getInstance(LineMarkersUtil.class);
    private static final Key<LineMarkerInfo<?>> LINE_MARKER_INFO = Key.create("LINE_MARKER_INFO");

    static boolean processLineMarkers(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, int group, @NotNull Processor<? super LineMarkerInfo<?>> processor) {
        if (project2 == null) {
            LineMarkersUtil.$$$reportNull$$$0(0);
        }
        if (document == null) {
            LineMarkersUtil.$$$reportNull$$$0(1);
        }
        if (bounds == null) {
            LineMarkersUtil.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            LineMarkersUtil.$$$reportNull$$$0(3);
        }
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        return markupModel.processRangeHighlightersOverlappingWith(bounds.getStartOffset(), bounds.getEndOffset(), highlighter -> {
            LineMarkerInfo<?> info = LineMarkersUtil.getLineMarkerInfo((RangeHighlighter)highlighter);
            return info == null || group != -1 && info.updatePass != group || processor.process(info);
        });
    }

    public static void setLineMarkersToEditor(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, @NotNull Collection<? extends LineMarkerInfo<?>> markers, int group) {
        if (project2 == null) {
            LineMarkersUtil.$$$reportNull$$$0(4);
        }
        if (document == null) {
            LineMarkersUtil.$$$reportNull$$$0(5);
        }
        if (bounds == null) {
            LineMarkersUtil.$$$reportNull$$$0(6);
        }
        if (markers == null) {
            LineMarkersUtil.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        HighlightersRecycler toReuse = new HighlightersRecycler();
        LineMarkersUtil.processLineMarkers(project2, document, bounds, group, info -> {
            toReuse.recycleHighlighter(info.highlighter);
            return true;
        });
        if (LOG.isDebugEnabled()) {
            List<LineMarkerInfo<?>> oldMarkers = DaemonCodeAnalyzerImpl.getLineMarkers(document, project2);
            LOG.debug("LineMarkersUtil.setLineMarkersToEditor(markers: " + markers + ", group: " + group + "); oldMarkers: " + oldMarkers + "; reused: " + toReuse.forAllInGarbageBin().size());
        }
        for (LineMarkerInfo<?> lineMarkerInfo : markers) {
            TextRange elementRange;
            TextRange textRange;
            Object element2 = lineMarkerInfo.getElement();
            if (element2 == null || (textRange = element2.getTextRange()) == null || !TextRange.containsRange(bounds, elementRange = InjectedLanguageManager.getInstance(project2).injectedToHost((PsiElement)element2, textRange))) continue;
            LineMarkersUtil.createOrReuseLineMarker(lineMarkerInfo, markupModel, toReuse);
        }
        for (RangeHighlighter rangeHighlighter : toReuse.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
        }
    }

    private static void createOrReuseLineMarker(@NotNull LineMarkerInfo<?> info, @NotNull MarkupModelEx markupModel, @Nullable HighlightersRecycler toReuse) {
        if (info == null) {
            LineMarkersUtil.$$$reportNull$$$0(8);
        }
        if (markupModel == null) {
            LineMarkersUtil.$$$reportNull$$$0(9);
        }
        LineMarkerInfo.LineMarkerGutterIconRenderer newRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)info.createGutterRenderer();
        RangeHighlighter highlighter = toReuse == null ? null : toReuse.pickupHighlighterFromGarbageBin(info.startOffset, info.endOffset, 3000);
        boolean newHighlighter = false;
        if (highlighter == null) {
            newHighlighter = true;
            highlighter = markupModel.addRangeHighlighterAndChangeAttributes(null, info.startOffset, info.endOffset, 3000, HighlighterTargetArea.LINES_IN_RANGE, false, markerEx -> {
                markerEx.setGutterIconRenderer((GutterIconRenderer)newRenderer);
                markerEx.setLineSeparatorColor(info.separatorColor);
                markerEx.setLineSeparatorPlacement(info.separatorPlacement);
                markerEx.putUserData(LINE_MARKER_INFO, (Object)info);
            });
            MarkupEditorFilter editorFilter = info.getEditorFilter();
            if (editorFilter != MarkupEditorFilter.EMPTY) {
                highlighter.setEditorFilter(editorFilter);
            }
        }
        if (!newHighlighter) {
            boolean lineSeparatorPlacementChanged;
            highlighter.putUserData(LINE_MARKER_INFO, info);
            LineMarkerInfo.LineMarkerGutterIconRenderer oldRenderer = highlighter.getGutterIconRenderer() instanceof LineMarkerInfo.LineMarkerGutterIconRenderer ? (LineMarkerInfo.LineMarkerGutterIconRenderer)highlighter.getGutterIconRenderer() : null;
            boolean rendererChanged = newRenderer == null || !newRenderer.equals((Object)oldRenderer);
            boolean lineSeparatorColorChanged = !Comparing.equal(highlighter.getLineSeparatorColor(), info.separatorColor);
            boolean bl = lineSeparatorPlacementChanged = !Comparing.equal(highlighter.getLineSeparatorPlacement(), info.separatorPlacement);
            if (rendererChanged || lineSeparatorColorChanged || lineSeparatorPlacementChanged) {
                markupModel.changeAttributesInBatch((RangeHighlighterEx)highlighter, markerEx -> {
                    if (rendererChanged) {
                        markerEx.setGutterIconRenderer((GutterIconRenderer)newRenderer);
                    }
                    if (lineSeparatorColorChanged) {
                        markerEx.setLineSeparatorColor(info.separatorColor);
                    }
                    if (lineSeparatorPlacementChanged) {
                        markerEx.setLineSeparatorPlacement(info.separatorPlacement);
                    }
                });
            }
        }
        info.highlighter = highlighter;
    }

    static void addLineMarkerToEditorIncrementally(@NotNull Project project2, @NotNull Document document, @NotNull LineMarkerInfo<?> marker) {
        if (project2 == null) {
            LineMarkersUtil.$$$reportNull$$$0(10);
        }
        if (document == null) {
            LineMarkersUtil.$$$reportNull$$$0(11);
        }
        if (marker == null) {
            LineMarkersUtil.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        LineMarkerInfo[] markerInTheWay = new LineMarkerInfo[]{null};
        boolean allIsClear = markupModel.processRangeHighlightersOverlappingWith(marker.startOffset, marker.endOffset, highlighter -> {
            markerInTheWay[0] = LineMarkersUtil.getLineMarkerInfo((RangeHighlighter)highlighter);
            return markerInTheWay[0] == null;
        });
        if (allIsClear) {
            LineMarkersUtil.createOrReuseLineMarker(marker, markupModel, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersUtil.addLineMarkerToEditorIncrementally: " + marker + " " + (String)(allIsClear ? "created" : " (was not added because " + markerInTheWay[0] + " was in the way)"));
        }
    }

    @Nullable
    static LineMarkerInfo<?> getLineMarkerInfo(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            LineMarkersUtil.$$$reportNull$$$0(13);
        }
        return (LineMarkerInfo)highlighter.getUserData(LINE_MARKER_INFO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LineMarkersUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processLineMarkers";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setLineMarkersToEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrReuseLineMarker";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addLineMarkerToEditorIncrementally";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

