/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.InspectionProfilerDataHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RedundantSuppressInspectionBase;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobLauncherImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InspectionRunner {
    private final PsiFile myPsiFile;
    private final TextRange myRestrictRange;
    private final TextRange myPriorityRange;
    private final boolean myInspectInjected;
    private final boolean myIsOnTheFly;
    private final ProgressIndicator myProgress;
    private final boolean myIgnoreSuppressed;
    private final InspectionProfileWrapper myInspectionProfileWrapper;
    private final Map<String, Set<PsiElement>> mySuppressedElements;

    InspectionRunner(@NotNull PsiFile psiFile, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, boolean inspectInjected, boolean isOnTheFly, @NotNull ProgressIndicator progress, boolean ignoreSuppressed, @NotNull InspectionProfileWrapper inspectionProfileWrapper, @NotNull Map<String, Set<PsiElement>> suppressedElements) {
        if (psiFile == null) {
            InspectionRunner.$$$reportNull$$$0(0);
        }
        if (restrictRange == null) {
            InspectionRunner.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            InspectionRunner.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            InspectionRunner.$$$reportNull$$$0(3);
        }
        if (inspectionProfileWrapper == null) {
            InspectionRunner.$$$reportNull$$$0(4);
        }
        if (suppressedElements == null) {
            InspectionRunner.$$$reportNull$$$0(5);
        }
        this.myPsiFile = psiFile;
        this.myRestrictRange = restrictRange;
        this.myPriorityRange = priorityRange;
        this.myInspectInjected = inspectInjected;
        this.myIsOnTheFly = isOnTheFly;
        this.myProgress = progress;
        this.myIgnoreSuppressed = ignoreSuppressed;
        this.myInspectionProfileWrapper = inspectionProfileWrapper;
        this.mySuppressedElements = suppressedElements;
    }

    @NotNull
    List<? extends InspectionContext> inspect(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, boolean addRedundantSuppressions, @NotNull BiPredicate<? super ProblemDescriptor, ? super LocalInspectionToolWrapper> applyIncrementallyCallback, @NotNull Consumer<? super InspectionContext> afterInsideProcessedCallback, @NotNull Consumer<? super InspectionContext> afterOutsideProcessedCallback) {
        if (toolWrappers == null) {
            InspectionRunner.$$$reportNull$$$0(6);
        }
        if (applyIncrementallyCallback == null) {
            InspectionRunner.$$$reportNull$$$0(7);
        }
        if (afterInsideProcessedCallback == null) {
            InspectionRunner.$$$reportNull$$$0(8);
        }
        if (afterOutsideProcessedCallback == null) {
            InspectionRunner.$$$reportNull$$$0(9);
        }
        if (!InspectionRunner.shouldInspect(this.myPsiFile)) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                InspectionRunner.$$$reportNull$$$0(10);
            }
            return list2;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myPsiFile, this.myRestrictRange, this.myPriorityRange, file2 -> InspectionRunner.shouldInspect(file2), new CommonProcessors.CollectProcessor(allDivided));
        List inside = ContainerUtil.concat(ContainerUtil.map(allDivided, d -> d.inside));
        long finalPriorityRange = InspectionRunner.finalPriorityRange(this.myPriorityRange, allDivided);
        List outside = ContainerUtil.concat(ContainerUtil.map(allDivided, d -> ContainerUtil.concat(d.outside, d.parents)));
        List injectedContexts = Collections.synchronizedList(new ArrayList());
        List<LocalInspectionToolWrapper> filteredWrappers = InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, InspectionEngine.calcElementDialectIds(inside, outside));
        ArrayList init = new ArrayList(filteredWrappers.size());
        ArrayList redundantContexts = new ArrayList();
        InspectionEngine.withSession(this.myPsiFile, this.myRestrictRange, TextRange.create(finalPriorityRange), this.myIsOnTheFly, session -> {
            boolean isWholeFileInspectionsPass;
            long start2 = System.nanoTime();
            filteredWrappers.forEach(wrapper2 -> ContainerUtil.addIfNotNull(init, this.createContext((LocalInspectionToolWrapper)wrapper2, (LocalInspectionToolSession)session, applyIncrementallyCallback)));
            InspectionProfilerDataHolder profileData = InspectionProfilerDataHolder.getInstance(this.myPsiFile.getProject());
            profileData.sort(this.myPsiFile, init);
            profileData.retrieveFavoriteElements(this.myPsiFile, init);
            Map<PsiFile, PsiElement> foundInjected = InspectionRunner.createInjectedFileMap();
            InspectionContext TOMB_STONE = this.createTombStone();
            this.visitElements(init, inside, true, finalPriorityRange, TOMB_STONE, afterInsideProcessedCallback, foundInjected, injectedContexts, toolWrappers, applyIncrementallyCallback);
            Consumer<InspectionContext> afterOutside = context2 -> {
                InspectionProblemHolder holder = context2.holder;
                holder.finishTimeStamp = System.nanoTime();
                ((LocalInspectionTool)context2.tool.getTool()).inspectionFinished((LocalInspectionToolSession)session, holder);
                afterOutsideProcessedCallback.accept((InspectionContext)context2);
            };
            this.visitElements(init, outside, false, finalPriorityRange, TOMB_STONE, afterOutside, foundInjected, injectedContexts, toolWrappers, InspectionRunner.empty());
            boolean bl = isWholeFileInspectionsPass = !toolWrappers.isEmpty() && ((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrappers.get(0)).getTool()).runForWholeFile();
            if (this.myIsOnTheFly && !isWholeFileInspectionsPass) {
                InspectionProfilerDataHolder.getInstance(this.myPsiFile.getProject()).saveStats(this.myPsiFile, init, System.nanoTime() - start2);
            }
            if (this.myIsOnTheFly && addRedundantSuppressions) {
                this.addRedundantSuppressions(init, toolWrappers, redundantContexts);
            }
        });
        List list3 = ContainerUtil.concat(new List[]{init, redundantContexts, injectedContexts});
        if (list3 == null) {
            InspectionRunner.$$$reportNull$$$0(11);
        }
        return list3;
    }

    private static long finalPriorityRange(@NotNull TextRange priorityRange, @NotNull List<? extends Divider.DividedElements> allDivided) {
        if (priorityRange == null) {
            InspectionRunner.$$$reportNull$$$0(12);
        }
        if (allDivided == null) {
            InspectionRunner.$$$reportNull$$$0(13);
        }
        long finalPriorityRange = allDivided.isEmpty() ? priorityRange.toScalarRange() : allDivided.get((int)0).priorityRange;
        for (int i = 1; i < allDivided.size(); ++i) {
            Divider.DividedElements dividedElements = allDivided.get(i);
            finalPriorityRange = TextRange.union(finalPriorityRange, dividedElements.priorityRange);
        }
        return finalPriorityRange;
    }

    @NotNull
    private InspectionContext createTombStone() {
        LocalInspectionToolWrapper tool = new LocalInspectionToolWrapper(new LocalInspectionEP());
        InspectionProblemHolder holder = new InspectionProblemHolder(this.myPsiFile, tool, false, this.myInspectionProfileWrapper, InspectionRunner.empty());
        return new InspectionContext(tool, holder, new PsiElementVisitor(){});
    }

    @NotNull
    private static <T> Map<PsiFile, T> createInjectedFileMap() {
        Map map2 = CollectionFactory.createCustomHashingStrategyMap(new HashingStrategy<PsiFile>(){

            @Override
            public int hashCode(PsiFile f) {
                VirtualFile host;
                if (f == null) {
                    return 0;
                }
                VirtualFile v = f.getVirtualFile();
                VirtualFile virtualFile2 = host = v instanceof VirtualFileWindow ? ((VirtualFileWindow)((Object)v)).getDelegate() : null;
                if (host == null) {
                    return 0;
                }
                return v.hashCode() * 37 + Objects.hashCode(ArrayUtil.getFirstElement(((VirtualFileWindow)((Object)v)).getDocumentWindow().getHostRanges()));
            }

            @Override
            public boolean equals(PsiFile f1, PsiFile f2) {
                VirtualFile d2;
                if (f1 == null || f2 == null || f1 == f2) {
                    return f1 == f2;
                }
                VirtualFile v1 = f1.getVirtualFile();
                VirtualFile v2 = f2.getVirtualFile();
                if (!(v1 instanceof VirtualFileWindow) || !(v2 instanceof VirtualFileWindow)) {
                    return Objects.equals(v1, v2);
                }
                VirtualFile d1 = ((VirtualFileWindow)((Object)v1)).getDelegate();
                if (!Objects.equals(d1, d2 = ((VirtualFileWindow)((Object)v2)).getDelegate())) {
                    return false;
                }
                return Arrays.equals(((VirtualFileWindow)((Object)v1)).getDocumentWindow().getHostRanges(), ((VirtualFileWindow)((Object)v2)).getDocumentWindow().getHostRanges());
            }
        });
        if (map2 == null) {
            InspectionRunner.$$$reportNull$$$0(14);
        }
        return map2;
    }

    private void registerSuppressedElements(@NotNull PsiElement element2, @NotNull String id2, @Nullable String alternativeID) {
        if (element2 == null) {
            InspectionRunner.$$$reportNull$$$0(15);
        }
        if (id2 == null) {
            InspectionRunner.$$$reportNull$$$0(16);
        }
        this.mySuppressedElements.computeIfAbsent(id2, __ -> new HashSet()).add(element2);
        if (alternativeID != null) {
            this.mySuppressedElements.computeIfAbsent(alternativeID, __ -> new HashSet()).add(element2);
        }
    }

    private void addRedundantSuppressions(@NotNull List<? extends InspectionContext> init, @NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull List<? super InspectionContext> result2) {
        InspectionToolWrapper toolWrapper;
        if (init == null) {
            InspectionRunner.$$$reportNull$$$0(17);
        }
        if (toolWrappers == null) {
            InspectionRunner.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            InspectionRunner.$$$reportNull$$$0(19);
        }
        for (InspectionContext inspectionContext : init) {
            toolWrapper = inspectionContext.tool;
            LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
            for (ProblemDescriptor descriptor : inspectionContext.holder.getResults()) {
                PsiElement element2 = descriptor.getPsiElement();
                if (element2 == null || !tool.isSuppressedFor(element2)) continue;
                this.registerSuppressedElements(element2, ((LocalInspectionToolWrapper)toolWrapper).getID(), ((LocalInspectionToolWrapper)toolWrapper).getAlternativeID());
            }
        }
        HighlightDisplayKey redundantSuppressionKey = HighlightDisplayKey.find("RedundantSuppression");
        InspectionProfile inspectionProfile = this.myInspectionProfileWrapper.getInspectionProfile();
        if (redundantSuppressionKey == null || !inspectionProfile.isToolEnabled(redundantSuppressionKey, this.myPsiFile)) {
            return;
        }
        toolWrapper = inspectionProfile.getInspectionTool("RedundantSuppression", this.myPsiFile);
        Language fileLanguage = this.myPsiFile.getLanguage();
        InspectionSuppressor suppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(fileLanguage);
        if (!(suppressor instanceof RedundantSuppressionDetector)) {
            return;
        }
        RedundantSuppressionDetector redundantSuppressionDetector = (RedundantSuppressionDetector)((Object)suppressor);
        HashSet<String> activeTools = new HashSet<String>();
        for (LocalInspectionToolWrapper localInspectionToolWrapper : toolWrappers) {
            if (localInspectionToolWrapper.runForWholeFile()) {
                return;
            }
            if (localInspectionToolWrapper.isUnfair() || !localInspectionToolWrapper.isApplicable(fileLanguage) || this.myInspectionProfileWrapper.getInspectionTool(localInspectionToolWrapper.getShortName(), this.myPsiFile) instanceof GlobalInspectionToolWrapper) continue;
            activeTools.add(localInspectionToolWrapper.getID());
            ContainerUtil.addIfNotNull(activeTools, localInspectionToolWrapper.getAlternativeID());
            InspectionElementsMerger elementsMerger = InspectionElementsMerger.getMerger(localInspectionToolWrapper.getShortName());
            if (elementsMerger == null) continue;
            activeTools.addAll(Arrays.asList(elementsMerger.getSuppressIds()));
        }
        LocalInspectionTool localTool = ((RedundantSuppressInspectionBase)toolWrapper.getTool()).createLocalTool(redundantSuppressionDetector, this.mySuppressedElements, activeTools);
        List<LocalInspectionToolWrapper> list2 = Collections.singletonList(new LocalInspectionToolWrapper(localTool));
        InspectionRunner runner = new InspectionRunner(this.myPsiFile, this.myRestrictRange, this.myPriorityRange, this.myInspectInjected, true, this.myProgress, false, this.myInspectionProfileWrapper, this.mySuppressedElements);
        result2.addAll(runner.inspect(list2, false, InspectionRunner.empty(), InspectionRunner.emptyCallback(), InspectionRunner.emptyCallback()));
    }

    @NotNull
    private static Consumer<InspectionContext> emptyCallback() {
        Consumer<InspectionContext> consumer = __ -> {};
        if (consumer == null) {
            InspectionRunner.$$$reportNull$$$0(20);
        }
        return consumer;
    }

    @NotNull
    private static BiPredicate<ProblemDescriptor, LocalInspectionToolWrapper> empty() {
        BiPredicate<ProblemDescriptor, LocalInspectionToolWrapper> biPredicate = (_1, _2) -> true;
        if (biPredicate == null) {
            InspectionRunner.$$$reportNull$$$0(21);
        }
        return biPredicate;
    }

    /*
     * WARNING - void declaration
     */
    private void visitElements(@NotNull List<? extends InspectionContext> init, @NotNull List<? extends PsiElement> elements, boolean inVisibleRange, long finalPriorityRange, @NotNull InspectionContext TOMB_STONE, @NotNull Consumer<? super InspectionContext> afterProcessCallback, @NotNull Map<? super PsiFile, PsiElement> foundInjected, @NotNull List<? super InspectionContext> injectedInsideContexts, @NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull BiPredicate<? super ProblemDescriptor, ? super LocalInspectionToolWrapper> biPredicate) {
        if (init == null) {
            InspectionRunner.$$$reportNull$$$0(22);
        }
        if (elements == null) {
            InspectionRunner.$$$reportNull$$$0(23);
        }
        if (TOMB_STONE == null) {
            InspectionRunner.$$$reportNull$$$0(24);
        }
        if (afterProcessCallback == null) {
            InspectionRunner.$$$reportNull$$$0(25);
        }
        if (foundInjected == null) {
            InspectionRunner.$$$reportNull$$$0(26);
        }
        if (injectedInsideContexts == null) {
            InspectionRunner.$$$reportNull$$$0(27);
        }
        if (toolWrappers == null) {
            InspectionRunner.$$$reportNull$$$0(28);
        }
        if (biPredicate == null) {
            InspectionRunner.$$$reportNull$$$0(29);
        }
        this.processInOrder(init, elements, inVisibleRange, finalPriorityRange, TOMB_STONE, afterProcessCallback);
        if (this.myInspectInjected) {
            void applyIncrementallyCallback;
            this.inspectInjectedPsi(elements, toolWrappers, foundInjected, injectedInsideContexts, (BiPredicate<? super ProblemDescriptor, ? super LocalInspectionToolWrapper>)applyIncrementallyCallback);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processInOrder(@NotNull List<? extends InspectionContext> init, @NotNull List<? extends PsiElement> elements, boolean isInsideVisibleRange, long priorityRange, @NotNull InspectionContext TOMB_STONE, @NotNull Consumer<? super InspectionContext> consumer) {
        void afterProcessCallback;
        if (init == null) {
            InspectionRunner.$$$reportNull$$$0(30);
        }
        if (elements == null) {
            InspectionRunner.$$$reportNull$$$0(31);
        }
        if (TOMB_STONE == null) {
            InspectionRunner.$$$reportNull$$$0(32);
        }
        if (consumer == null) {
            InspectionRunner.$$$reportNull$$$0(33);
        }
        ArrayBlockingQueue<? extends InspectionContext> contexts = new ArrayBlockingQueue<InspectionContext>(init.size() + 1, false, init);
        boolean added = contexts.offer(TOMB_STONE);
        assert (added);
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        boolean shouldFailFastAcquiringReadAction = application.isInImpatientReader();
        boolean processed = ((JobLauncherImpl)JobLauncher.getInstance()).processQueue(contexts, new LinkedBlockingQueue(), (ProgressIndicator)new SensitiveProgressWrapper(this.myProgress), (Object)TOMB_STONE, arg_0 -> this.lambda$processInOrder$14(isInsideVisibleRange, priorityRange, elements, (Consumer)afterProcessCallback, application, shouldFailFastAcquiringReadAction, arg_0));
        if (!processed) {
            throw new ProcessCanceledException();
        }
    }

    private InspectionContext createContext(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull LocalInspectionToolSession session, @NotNull BiPredicate<? super ProblemDescriptor, ? super LocalInspectionToolWrapper> applyIncrementallyCallback) {
        InspectionProblemHolder holder;
        LocalInspectionTool tool;
        PsiElementVisitor visitor;
        if (toolWrapper == null) {
            InspectionRunner.$$$reportNull$$$0(34);
        }
        if (session == null) {
            InspectionRunner.$$$reportNull$$$0(35);
        }
        if (applyIncrementallyCallback == null) {
            InspectionRunner.$$$reportNull$$$0(36);
        }
        if ((visitor = InspectionEngine.createVisitor(tool = (LocalInspectionTool)toolWrapper.getTool(), holder = new InspectionProblemHolder(this.myPsiFile, toolWrapper, this.myIsOnTheFly, this.myInspectionProfileWrapper, applyIncrementallyCallback), this.myIsOnTheFly, session)) != PsiElementVisitor.EMPTY_VISITOR) {
            tool.inspectionStarted(session, this.myIsOnTheFly);
            return new InspectionContext(toolWrapper, holder, visitor);
        }
        return null;
    }

    private void inspectInjectedPsi(@NotNull List<? extends PsiElement> elements, @NotNull List<? extends LocalInspectionToolWrapper> wrappers, @NotNull Map<? super PsiFile, PsiElement> injectedToHost, @NotNull List<? super InspectionContext> outInjectedContexts, @NotNull BiPredicate<? super ProblemDescriptor, ? super LocalInspectionToolWrapper> addDescriptorIncrementallyCallback) {
        if (elements == null) {
            InspectionRunner.$$$reportNull$$$0(37);
        }
        if (wrappers == null) {
            InspectionRunner.$$$reportNull$$$0(38);
        }
        if (injectedToHost == null) {
            InspectionRunner.$$$reportNull$$$0(39);
        }
        if (outInjectedContexts == null) {
            InspectionRunner.$$$reportNull$$$0(40);
        }
        if (addDescriptorIncrementallyCallback == null) {
            InspectionRunner.$$$reportNull$$$0(41);
        }
        Project project2 = this.myPsiFile.getProject();
        ArrayList toInspect = new ArrayList();
        for (PsiElement psiElement : elements) {
            InjectedLanguageManager.getInstance(project2).enumerateEx(psiElement, this.myPsiFile, false, (injectedPsi, __) -> {
                if (injectedToHost.put(injectedPsi, element2) == null) {
                    toInspect.add(injectedPsi);
                }
            });
        }
        if (toInspect.isEmpty()) {
            return;
        }
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(toInspect), this.myProgress, injectedPsi -> {
            PsiElement host = (PsiElement)injectedToHost.get(injectedPsi);
            BiPredicate<ProblemDescriptor, LocalInspectionToolWrapper> cc = (descriptor, wrapper2) -> {
                PsiElement descriptorPsiElement = descriptor.getPsiElement();
                if (this.myIgnoreSuppressed && (host != null && ((LocalInspectionTool)wrapper2.getTool()).isSuppressedFor(host) || descriptorPsiElement != null && ((LocalInspectionTool)wrapper2.getTool()).isSuppressedFor(descriptorPsiElement))) {
                    this.registerSuppressedElements(host, wrapper2.getID(), wrapper2.getAlternativeID());
                    return false;
                }
                if (this.myIsOnTheFly) {
                    return addDescriptorIncrementallyCallback.test((ProblemDescriptor)descriptor, (LocalInspectionToolWrapper)wrapper2);
                }
                return true;
            };
            if (InspectionRunner.shouldInspect(injectedPsi)) {
                InspectionRunner injectedRunner = new InspectionRunner((PsiFile)injectedPsi, injectedPsi.getTextRange(), injectedPsi.getTextRange(), false, this.myIsOnTheFly, this.myProgress, this.myIgnoreSuppressed, this.myInspectionProfileWrapper, this.mySuppressedElements);
                outInjectedContexts.addAll(injectedRunner.inspect(wrappers, true, cc, InspectionRunner.emptyCallback(), InspectionRunner.emptyCallback()));
            }
            return true;
        })) {
            throw new ProcessCanceledException();
        }
    }

    private static boolean shouldInspect(@NotNull PsiFile file2) {
        HighlightingLevelManager highlightingLevelManager;
        if (file2 == null) {
            InspectionRunner.$$$reportNull$$$0(42);
        }
        return (highlightingLevelManager = HighlightingLevelManager.getInstance(file2.getProject())) != null && highlightingLevelManager.shouldInspect(file2) && !highlightingLevelManager.runEssentialHighlightingOnly(file2);
    }

    private /* synthetic */ boolean lambda$processInOrder$14(boolean isInsideVisibleRange, long priorityRange, List elements, Consumer afterProcessCallback, ApplicationEx application, boolean shouldFailFastAcquiringReadAction, InspectionContext context2) {
        return AstLoadingFilter.disallowTreeLoading(() -> AstLoadingFilter.forceAllowTreeLoading(this.myPsiFile, () -> {
            Runnable runnable = () -> {
                Runnable action2 = () -> {
                    InspectionProblemHolder holder = context2.holder;
                    int resultCount = holder.getResultCount();
                    PsiElement favoriteElement = context2.myFavoriteElement;
                    if (favoriteElement != null && isInsideVisibleRange == favoriteElement.getTextRange().intersects(priorityRange)) {
                        context2.myFavoriteElement = null;
                        favoriteElement.accept(context2.visitor);
                        if (holder.getResultCount() != resultCount && resultCount != -1) {
                            context2.myFavoriteElement = favoriteElement;
                            resultCount = -1;
                        }
                    }
                    for (int i = 0; i < elements.size(); ++i) {
                        PsiElement element2 = (PsiElement)elements.get(i);
                        ProgressManager.checkCanceled();
                        if (element2 == favoriteElement) continue;
                        element2.accept(context2.visitor);
                        if (resultCount == -1 || holder.getResultCount() == resultCount) continue;
                        context2.myFavoriteElement = element2;
                        resultCount = -1;
                    }
                    afterProcessCallback.accept(context2);
                };
                if (!application.tryRunReadAction(action2)) {
                    throw new ProcessCanceledException();
                }
            };
            if (shouldFailFastAcquiringReadAction) {
                application.executeByImpatientReader(runnable);
            } else {
                runnable.run();
            }
            return true;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfileWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressedElements";
                break;
            }
            case 6: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 7: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyIncrementallyCallback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterInsideProcessedCallback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterOutsideProcessedCallback";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InspectionRunner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDivided";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 17: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "TOMB_STONE";
                break;
            }
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterProcessCallback";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundInjected";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedInsideContexts";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedToHost";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInjectedContexts";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addDescriptorIncrementallyCallback";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InspectionRunner";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "inspect";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createInjectedFileMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyCallback";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 21: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "finalPriorityRange";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerSuppressedElements";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRedundantSuppressions";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitElements";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processInOrder";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "inspectInjectedPsi";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class InspectionProblemHolder
    extends ProblemsHolder {
        @NotNull
        private final LocalInspectionToolWrapper myToolWrapper;
        private final InspectionProfileWrapper myProfileWrapper;
        private final BiPredicate<? super ProblemDescriptor, ? super LocalInspectionToolWrapper> applyIncrementallyCallback;
        volatile boolean applyIncrementally;
        long errorStamp;
        long warningStamp;
        long otherStamp;
        final long initTimeStamp;
        volatile long finishTimeStamp;

        InspectionProblemHolder(@NotNull PsiFile file2, @NotNull LocalInspectionToolWrapper toolWrapper, boolean isOnTheFly, @NotNull InspectionProfileWrapper inspectionProfileWrapper, @NotNull BiPredicate<? super ProblemDescriptor, ? super LocalInspectionToolWrapper> applyIncrementallyCallback) {
            if (file2 == null) {
                InspectionProblemHolder.$$$reportNull$$$0(0);
            }
            if (toolWrapper == null) {
                InspectionProblemHolder.$$$reportNull$$$0(1);
            }
            if (inspectionProfileWrapper == null) {
                InspectionProblemHolder.$$$reportNull$$$0(2);
            }
            if (applyIncrementallyCallback == null) {
                InspectionProblemHolder.$$$reportNull$$$0(3);
            }
            super(InspectionManager.getInstance(file2.getProject()), file2, isOnTheFly);
            this.initTimeStamp = System.nanoTime();
            this.myToolWrapper = toolWrapper;
            this.myProfileWrapper = inspectionProfileWrapper;
            this.applyIncrementallyCallback = applyIncrementallyCallback;
            this.applyIncrementally = isOnTheFly;
        }

        @Override
        public void registerProblem(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                InspectionProblemHolder.$$$reportNull$$$0(4);
            }
            if (this.applyIncrementally && !this.applyIncrementallyCallback.test(descriptor, this.myToolWrapper)) {
                return;
            }
            super.registerProblem(descriptor);
            HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(this.myToolWrapper.getDisplayKey(), this.getFile()).getSeverity();
            if (severity.compareTo(HighlightSeverity.ERROR) >= 0) {
                if (this.errorStamp == 0L) {
                    this.errorStamp = System.nanoTime();
                }
            } else if (severity.compareTo(HighlightSeverity.WARNING) >= 0) {
                if (this.warningStamp == 0L) {
                    this.warningStamp = System.nanoTime();
                }
            } else if (this.otherStamp == 0L) {
                this.otherStamp = System.nanoTime();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspectionProfileWrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applyIncrementallyCallback";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InspectionRunner$InspectionProblemHolder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class InspectionContext {
        @NotNull
        final LocalInspectionToolWrapper tool;
        @NotNull
        final InspectionProblemHolder holder;
        @NotNull
        final PsiElementVisitor visitor;
        volatile PsiElement myFavoriteElement;

        private InspectionContext(@NotNull LocalInspectionToolWrapper tool, @NotNull InspectionProblemHolder holder, @NotNull PsiElementVisitor visitor) {
            if (tool == null) {
                InspectionContext.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InspectionContext.$$$reportNull$$$0(1);
            }
            if (visitor == null) {
                InspectionContext.$$$reportNull$$$0(2);
            }
            this.tool = tool;
            this.holder = holder;
            this.visitor = visitor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visitor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/InspectionRunner$InspectionContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

