/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectedGeneralHighlightingPass
extends GeneralHighlightingPass {
    InjectedGeneralHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor2, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (file2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(2);
        }
        if (highlightInfoProcessor == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(3);
        }
        super(file2, document, startOffset, endOffset, updateAll, priorityRange, editor2, highlightInfoProcessor);
    }

    @Override
    protected String getPresentableName() {
        return IdeBundle.message((String)"highlighting.pass.injected.presentable.name", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        HashSet result2;
        if (progress == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(4);
        }
        if (!Registry.is("editor.injected.highlighting.enabled")) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, this.myPriorityRange, SHOULD_HIGHLIGHT_FILTER, new CommonProcessors.CollectProcessor(allDivided));
        List allInsideElements = ContainerUtil.concat(ContainerUtil.map(allDivided, d -> d.inside));
        List allOutsideElements = ContainerUtil.concat(ContainerUtil.map(allDivided, d -> d.outside));
        Set<PsiFile> injected = this.getInjectedPsiFiles(allInsideElements, allOutsideElements, progress);
        HashSet injectedResult = new HashSet();
        if (!this.addInjectedPsiHighlights(injected, progress, Collections.synchronizedSet(injectedResult))) {
            throw new ProcessCanceledException();
        }
        HashSet hashSet = injectedResult;
        synchronized (hashSet) {
            result2 = injectedResult.isEmpty() ? Collections.emptySet() : new HashSet(injectedResult);
        }
        HashSet<HighlightInfo> gotHighlights = new HashSet<HighlightInfo>(100);
        ArrayList<HighlightInfo> injectionsOutside = new ArrayList<HighlightInfo>(gotHighlights.size());
        for (HighlightInfo info : result2) {
            if (this.myRestrictRange.contains(info)) {
                gotHighlights.add(info);
                continue;
            }
            injectionsOutside.add(info);
        }
        if (!injectionsOutside.isEmpty()) {
            boolean priorityIntersectionHasElements = this.myPriorityRange.intersectsStrict(this.myRestrictRange);
            if (!(allInsideElements.isEmpty() && gotHighlights.isEmpty() || !priorityIntersectionHasElements)) {
                ArrayList toApplyInside = new ArrayList(gotHighlights);
                this.myHighlights.addAll(toApplyInside);
                gotHighlights.clear();
                this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), toApplyInside, this.myPriorityRange, this.myRestrictRange, this.getId());
            }
            ArrayList<HighlightInfo> toApply = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : gotHighlights) {
                if (!this.myRestrictRange.contains(info) || this.myPriorityRange.contains(info)) continue;
                toApply.add(info);
            }
            toApply.addAll(injectionsOutside);
            this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), toApply, this.myRestrictRange, new ProperTextRange(0, this.myDocument.getTextLength()), this.getId());
        } else {
            this.myHighlights.addAll(gotHighlights);
            this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), this.myHighlights, this.myRestrictRange, this.myRestrictRange, this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Set<PsiFile> getInjectedPsiFiles(@NotNull List<? extends PsiElement> elements1, @NotNull List<? extends PsiElement> elements2, @NotNull ProgressIndicator progress) {
        if (elements1 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(5);
        }
        if (elements2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List<DocumentWindow> injected = InjectedLanguageManager.getInstance(this.myProject).getCachedInjectedDocumentsInRange(this.myFile, this.myFile.getTextRange());
        HashSet<PsiLanguageInjectionHost> hosts = new HashSet<PsiLanguageInjectionHost>(elements1.size() + elements2.size() + injected.size());
        for (DocumentWindow documentRange : injected) {
            PsiLanguageInjectionHost context2;
            PsiFile file2;
            ProgressManager.checkCanceled();
            if (!documentRange.isValid() || (file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(documentRange)) == null || (context2 = InjectedLanguageManager.getInstance(file2.getProject()).getInjectionHost(file2)) == null || !context2.isValid() || file2.getProject().isDisposed() || !this.myUpdateAll && !this.myRestrictRange.intersects(context2.getTextRange())) continue;
            hosts.add(context2);
        }
        InjectedLanguageManagerImpl injectedLanguageManager = InjectedLanguageManagerImpl.getInstanceImpl(this.myProject);
        boolean probeUp = false;
        CommonProcessors.CollectProcessor<PsiElement> collectInjectableProcessor = new CommonProcessors.CollectProcessor<PsiElement>(hosts){

            @Override
            public boolean process(PsiElement t) {
                ProgressManager.checkCanceled();
                if (InjectedLanguageUtil.isInjectable(t, false)) {
                    super.process(t);
                }
                return true;
            }
        };
        injectedLanguageManager.processInjectableElements(elements1, (Processor<? super PsiElement>)collectInjectableProcessor);
        injectedLanguageManager.processInjectableElements(elements2, (Processor<? super PsiElement>)collectInjectableProcessor);
        HashSet outInjected = new HashSet();
        PsiLanguageInjectionHost.InjectedPsiVisitor visitor = (injectedPsi, places) -> {
            Set set2 = outInjected;
            synchronized (set2) {
                ProgressManager.checkCanceled();
                outInjected.add(injectedPsi);
            }
        };
        this.setProgressLimit(hosts.size());
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(hosts), progress, element2 -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            injectedLanguageManager.enumerateEx((PsiElement)element2, this.myFile, false, visitor);
            this.advanceProgress(1L);
            return true;
        })) {
            throw new ProcessCanceledException();
        }
        HashSet hashSet2 = outInjected;
        // MONITORENTER : hashSet2
        HashSet<PsiFile> hashSet = outInjected.isEmpty() ? Collections.emptySet() : new HashSet<PsiFile>(outInjected);
        // MONITOREXIT : hashSet2
        if (hashSet != null) return hashSet;
        InjectedGeneralHighlightingPass.$$$reportNull$$$0(8);
        return hashSet;
    }

    private boolean addInjectedPsiHighlights(@NotNull Set<? extends PsiFile> injectedFiles, @NotNull ProgressIndicator progress, @NotNull Collection<? super HighlightInfo> outInfos) {
        if (injectedFiles == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(9);
        }
        if (progress == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(10);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(11);
        }
        if (injectedFiles.isEmpty()) {
            return true;
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(this.myProject);
        TextAttributesKey fragmentKey = EditorColors.createInjectedLanguageFragmentKey((Language)this.myFile.getLanguage());
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<PsiFile>(injectedFiles), progress, injectedPsi -> this.addInjectedPsiHighlights((PsiFile)injectedPsi, fragmentKey, outInfos, injectedLanguageManager));
    }

    @Override
    protected void queueInfoToUpdateIncrementally(@NotNull HighlightInfo info) {
        if (info == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(12);
        }
    }

    private boolean addInjectedPsiHighlights(@NotNull PsiFile injectedPsi, TextAttributesKey attributesKey, @NotNull Collection<? super HighlightInfo> outInfos, @NotNull InjectedLanguageManager injectedLanguageManager) {
        DocumentWindow documentWindow;
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(13);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(14);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(15);
        }
        if ((documentWindow = (DocumentWindow)PsiDocumentManager.getInstance(this.myProject).getCachedDocument(injectedPsi)) == null) {
            return true;
        }
        Place places = InjectedLanguageUtil.getShreds(injectedPsi);
        boolean addTooltips = places.size() < 100;
        for (PsiLanguageInjectionHost.Shred place : places) {
            TextRange textRange;
            PsiLanguageInjectionHost host = place.getHost();
            if (host == null || (textRange = place.getRangeInsideHost().shiftRight(host.getTextRange().getStartOffset())).isEmpty()) continue;
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_BACKGROUND).range(textRange);
            if (attributesKey != null && InjectedLanguageUtil.isHighlightInjectionBackground(host)) {
                builder2.textAttributes(attributesKey);
            }
            if (addTooltips) {
                String desc = injectedPsi.getLanguage().getDisplayName() + ": " + injectedPsi.getText();
                builder2.unescapedToolTip(desc);
            }
            HighlightInfo info = builder2.createUnconditionally();
            info.markFromInjection();
            outInfos.add(info);
        }
        HighlightInfoHolder holder = this.createInfoHolder(injectedPsi);
        this.runHighlightVisitorsForInjected(injectedPsi, holder);
        for (int i = 0; i < holder.size(); ++i) {
            HighlightInfo info = holder.get(i);
            int startOffset = documentWindow.injectedToHost(info.startOffset);
            TextRange fixedTextRange = InjectedGeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
            InjectedGeneralHighlightingPass.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, fixedTextRange, outInfos);
        }
        int injectedStart = holder.size();
        this.highlightInjectedSyntax(injectedPsi, holder);
        for (int i = injectedStart; i < holder.size(); ++i) {
            HighlightInfo info = holder.get(i);
            int startOffset = info.startOffset;
            TextRange fixedTextRange = InjectedGeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
            if (fixedTextRange == null) {
                info.markFromInjection();
                outInfos.add(info);
                continue;
            }
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.forcedTextAttributesKey, info.type, fixedTextRange.getStartOffset(), fixedTextRange.getEndOffset(), info.getDescription(), info.getToolTip(), info.getSeverity(), info.isAfterEndOfLine(), null, false, 0, info.getProblemGroup(), info.getInspectionToolId(), info.getGutterIconRenderer(), info.getGroup());
            patched.markFromInjection();
            outInfos.add(patched);
        }
        if (!this.isDumbMode()) {
            ArrayList todos = new ArrayList();
            InjectedGeneralHighlightingPass.highlightTodos(injectedPsi, injectedPsi.getText(), 0, injectedPsi.getTextLength(), this.myPriorityRange, todos, todos);
            for (HighlightInfo info : todos) {
                InjectedGeneralHighlightingPass.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, null, outInfos);
            }
        }
        return true;
    }

    @Nullable(value="null means invalid")
    private static @Nullable(value="null means invalid") TextRange getFixedTextRange(@NotNull DocumentWindow documentWindow, int startOffset) {
        ProperTextRange fixedTextRange;
        TextRange textRange;
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(16);
        }
        if ((textRange = documentWindow.getHostRange(startOffset)) == null) {
            textRange = InjectedGeneralHighlightingPass.findNearestTextRange(documentWindow, startOffset);
            if (textRange == null) {
                return null;
            }
            boolean isBefore = startOffset < textRange.getStartOffset();
            fixedTextRange = new ProperTextRange(isBefore ? textRange.getStartOffset() - 1 : textRange.getEndOffset(), isBefore ? textRange.getStartOffset() : textRange.getEndOffset() + 1);
        } else {
            fixedTextRange = null;
        }
        return fixedTextRange;
    }

    private static void addPatchedInfos(@NotNull HighlightInfo info, @NotNull PsiFile injectedPsi, @NotNull DocumentWindow documentWindow, @NotNull InjectedLanguageManager injectedLanguageManager, @Nullable TextRange fixedTextRange, @NotNull Collection<? super HighlightInfo> out) {
        if (info == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(17);
        }
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(18);
        }
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(19);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(20);
        }
        if (out == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(21);
        }
        ProperTextRange textRange = new ProperTextRange(info.startOffset, info.endOffset);
        List<TextRange> editables = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, textRange);
        for (TextRange editable : editables) {
            TextRange hostRange = fixedTextRange == null ? documentWindow.injectedToHost(editable) : fixedTextRange;
            boolean isAfterEndOfLine = info.isAfterEndOfLine();
            if (isAfterEndOfLine) {
                int hostEndOffset = hostRange.getEndOffset();
                int lineNumber = documentWindow.getDelegate().getLineNumber(hostEndOffset);
                int hostLineEndOffset = documentWindow.getDelegate().getLineEndOffset(lineNumber);
                if (hostEndOffset < hostLineEndOffset) {
                    isAfterEndOfLine = false;
                    hostRange = new ProperTextRange(hostRange.getStartOffset(), hostEndOffset + 1);
                }
            }
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.forcedTextAttributesKey, info.type, hostRange.getStartOffset(), hostRange.getEndOffset(), info.getDescription(), info.getToolTip(), info.getSeverity(), isAfterEndOfLine, null, false, 0, info.getProblemGroup(), info.getInspectionToolId(), info.getGutterIconRenderer(), info.getGroup());
            patched.setHint(info.hasHint());
            if (info.quickFixActionRanges != null) {
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange quickfixTextRange = pair.getSecond();
                    List<TextRange> editableQF = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, quickfixTextRange);
                    for (TextRange editableRange : editableQF) {
                        HighlightInfo.IntentionActionDescriptor descriptor = pair.getFirst();
                        if (patched.quickFixActionRanges == null) {
                            patched.quickFixActionRanges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
                        }
                        TextRange hostEditableRange = documentWindow.injectedToHost(editableRange);
                        patched.quickFixActionRanges.add(Pair.create(descriptor, hostEditableRange));
                    }
                }
            }
            patched.markFromInjection();
            out.add(patched);
        }
    }

    @Nullable(value="null means invalid")
    private static @Nullable(value="null means invalid") TextRange findNearestTextRange(DocumentWindow documentWindow, int startOffset) {
        Segment marker;
        ProperTextRange curRange;
        ProperTextRange textRange = null;
        Segment[] segmentArray = documentWindow.getHostRanges();
        int n = segmentArray.length;
        for (int i = 0; i < n && ((curRange = ProperTextRange.create(marker = segmentArray[i])).getStartOffset() <= startOffset || textRange == null); ++i) {
            textRange = curRange;
        }
        return textRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHighlightVisitorsForInjected(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder) {
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(22);
        }
        if (holder == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(23);
        }
        HighlightVisitor[] filtered = this.getHighlightVisitors(injectedPsi);
        try {
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange(injectedPsi, 0, injectedPsi.getTextLength());
            for (HighlightVisitor visitor : filtered) {
                visitor.analyze(injectedPsi, true, holder, () -> {
                    for (PsiElement element2 : elements) {
                        ProgressManager.checkCanceled();
                        visitor.visit(element2);
                    }
                });
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
    }

    private void highlightInjectedSyntax(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder) {
        List<InjectedLanguageUtilBase.TokenInfo> tokens;
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(24);
        }
        if (holder == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(25);
        }
        if ((tokens = InjectedLanguageUtil.getHighlightTokens(injectedPsi)) == null) {
            return;
        }
        Place shreds = InjectedLanguageUtil.getShreds(injectedPsi);
        int shredIndex = -1;
        int injectionHostTextRangeStart = -1;
        for (InjectedLanguageUtilBase.TokenInfo token : tokens) {
            ProgressManager.checkCanceled();
            ProperTextRange range = token.rangeInsideInjectionHost;
            if (range.getLength() == 0) continue;
            if (shredIndex != token.shredIndex) {
                shredIndex = token.shredIndex;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(shredIndex);
                PsiLanguageInjectionHost host = shred.getHost();
                if (host == null) {
                    return;
                }
                injectionHostTextRangeStart = host.getTextRange().getStartOffset();
            }
            TextRange shiftedRange = ((TextRange)range).shiftRight(injectionHostTextRangeStart);
            holder.addAll(InjectedGeneralHighlightingPass.overrideDefaultHighlights(this.myGlobalScheme, shiftedRange, token.textAttributesKeys));
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    @NotNull
    public static List<HighlightInfo> overrideDefaultHighlights(@NotNull EditorColorsScheme scheme, @NotNull TextRange range, TextAttributesKey @NotNull [] keys2) {
        if (scheme == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(26);
        }
        if (range == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(27);
        }
        if (keys2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(28);
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>();
        if (range.isEmpty()) {
            ArrayList<HighlightInfo> arrayList = result2;
            if (arrayList == null) {
                InjectedGeneralHighlightingPass.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(range).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
        result2.add(info);
        LayeredTextAttributes injectedAttributes = LayeredTextAttributes.create((EditorColorsScheme)scheme, (TextAttributesKey[])keys2);
        if (injectedAttributes.isEmpty() || keys2.length == 1 && keys2[0] == HighlighterColors.TEXT) {
            ArrayList<HighlightInfo> arrayList = result2;
            if (arrayList == null) {
                InjectedGeneralHighlightingPass.$$$reportNull$$$0(30);
            }
            return arrayList;
        }
        HighlightInfo injectedInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(range).textAttributes((TextAttributes)injectedAttributes).createUnconditionally();
        result2.add(injectedInfo);
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFiles";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInfos";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedLanguageManager";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedPsiFiles";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideDefaultHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedPsiFiles";
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedPsiHighlights";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "queueInfoToUpdateIncrementally";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFixedTextRange";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addPatchedInfos";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runHighlightVisitorsForInjected";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "highlightInjectedSyntax";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "overrideDefaultHighlights";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

