/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.DefaultLineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentGuideRenderer
implements CustomHighlighterRenderer {
    public void paint(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        int off;
        Document doc;
        int startOffset;
        if (editor2 == null) {
            IndentGuideRenderer.$$$reportNull$$$0(0);
        }
        if (highlighter == null) {
            IndentGuideRenderer.$$$reportNull$$$0(1);
        }
        if (g == null) {
            IndentGuideRenderer.$$$reportNull$$$0(2);
        }
        if ((startOffset = highlighter.getStartOffset()) >= (doc = highlighter.getDocument()).getTextLength()) {
            return;
        }
        int endOffset = highlighter.getEndOffset();
        int startLine = doc.getLineNumber(startOffset);
        CharSequence chars = doc.getCharsSequence();
        do {
            int start2 = doc.getLineStartOffset(startLine);
            int end = doc.getLineEndOffset(startLine);
            off = CharArrayUtil.shiftForward(chars, start2, end, " \t");
        } while (--startLine > 1 && off < doc.getTextLength() && chars.charAt(off) == '\n');
        VisualPosition startPosition = editor2.offsetToVisualPosition(off);
        VisualPosition endPosition = editor2.offsetToVisualPosition(endOffset);
        this.paint(editor2, startPosition, endPosition, off, endOffset, doc, g);
    }

    protected void paint(@NotNull Editor editor2, @NotNull VisualPosition lineStartPosition, @NotNull VisualPosition lineEndPosition, int startOffset, int endOffset, @NotNull Document doc, @NotNull Graphics g) {
        Rectangle clip;
        int indentColumn;
        if (editor2 == null) {
            IndentGuideRenderer.$$$reportNull$$$0(3);
        }
        if (lineStartPosition == null) {
            IndentGuideRenderer.$$$reportNull$$$0(4);
        }
        if (lineEndPosition == null) {
            IndentGuideRenderer.$$$reportNull$$$0(5);
        }
        if (doc == null) {
            IndentGuideRenderer.$$$reportNull$$$0(6);
        }
        if (g == null) {
            IndentGuideRenderer.$$$reportNull$$$0(7);
        }
        if ((indentColumn = lineStartPosition.column) <= 0) {
            return;
        }
        FoldingModel foldingModel = editor2.getFoldingModel();
        if (foldingModel.isOffsetCollapsed(startOffset)) {
            return;
        }
        FoldRegion headerRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(doc.getLineNumber(startOffset)));
        FoldRegion tailRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineStartOffset(doc.getLineNumber(endOffset)));
        if (tailRegion != null && tailRegion == headerRegion) {
            return;
        }
        boolean selected = this.isSelected(editor2, endOffset, startOffset, lineStartPosition.column);
        Color color = IndentGuideRenderer.getIndentColor(editor2, startOffset, selected);
        int lineHeight = editor2.getLineHeight();
        Point start2 = editor2.visualPositionToXY(lineStartPosition);
        start2.y += lineHeight;
        Point end = editor2.visualPositionToXY(lineEndPosition);
        int maxY = end.y;
        if (lineEndPosition.line == editor2.offsetToVisualPosition((int)doc.getTextLength()).line) {
            maxY += lineHeight;
        }
        if ((clip = g.getClipBounds()) != null) {
            if (clip.y >= maxY || clip.y + clip.height <= start2.y) {
                return;
            }
            maxY = Math.min(maxY, clip.y + clip.height);
        }
        if (start2.y >= maxY) {
            return;
        }
        int targetX = Math.max(0, start2.x + EditorPainter.getIndentGuideShift((Editor)editor2));
        g.setColor(color);
        List softWraps = ((EditorEx)editor2).getSoftWrapModel().getRegisteredSoftWraps();
        if (selected || softWraps.isEmpty()) {
            LinePainter2D.paint((Graphics2D)g, targetX, start2.y, (double)targetX, maxY - 1);
        } else {
            int startY = start2.y;
            int startVisualLine = lineStartPosition.line + 1;
            if (clip != null && startY < clip.y) {
                startY = clip.y;
                startVisualLine = editor2.yToVisualLine(clip.y);
            }
            VisualLinesIterator it = new VisualLinesIterator((EditorImpl)editor2, startVisualLine);
            while (!it.atEnd()) {
                int currY = it.getY();
                if (currY >= startY) {
                    SoftWrap softWrap;
                    if (currY >= maxY) break;
                    if (it.startsWithSoftWrap() && (softWrap = (SoftWrap)softWraps.get(it.getStartOrPrevWrapIndex())).getIndentInColumns() < indentColumn) {
                        if (startY < currY) {
                            LinePainter2D.paint((Graphics2D)g, targetX, startY, (double)targetX, currY - 1);
                        }
                        startY = currY + lineHeight;
                    }
                }
                it.advance();
            }
            if (startY < maxY) {
                LinePainter2D.paint((Graphics2D)g, targetX, startY, (double)targetX, maxY - 1);
            }
        }
    }

    private static Color getIndentColor(Editor editor2, int startOffset, boolean selected) {
        List<RangeHighlighter> highlighters;
        EditorColorsScheme scheme = editor2.getColorsScheme();
        if (ExperimentalUI.isNewUI() && !(highlighters = ContainerUtil.filter(editor2.getMarkupModel().getAllHighlighters(), x -> x.getLineMarkerRenderer() instanceof DefaultLineMarkerRenderer)).isEmpty()) {
            Color color;
            DefaultLineMarkerRenderer renderer = (DefaultLineMarkerRenderer)highlighters.get(0).getLineMarkerRenderer();
            assert (renderer != null);
            if (editor2.offsetToVisualLine(startOffset, false) == editor2.offsetToVisualLine(highlighters.get(0).getStartOffset(), false) && (color = renderer.getColor()) != null) {
                Color matched = scheme.getColor(EditorColors.MATCHED_BRACES_INDENT_GUIDE_COLOR);
                return ObjectUtils.notNull(matched, color);
            }
        }
        return scheme.getColor(selected ? EditorColors.SELECTED_INDENT_GUIDE_COLOR : EditorColors.INDENT_GUIDE_COLOR);
    }

    protected boolean isSelected(@NotNull Editor editor2, int endOffset, int off, int indentColumn) {
        IndentGuideDescriptor guide;
        if (editor2 == null) {
            IndentGuideRenderer.$$$reportNull$$$0(8);
        }
        if ((guide = editor2.getIndentsModel().getCaretIndentGuide()) == null) {
            return false;
        }
        return this.isCaretOnGuide(editor2, endOffset, off, indentColumn);
    }

    protected final boolean isCaretOnGuide(@NotNull Editor editor2, int endOffset, int off, int indentColumn) {
        CaretModel caretModel;
        int caretOffset;
        if (editor2 == null) {
            IndentGuideRenderer.$$$reportNull$$$0(9);
        }
        return (caretOffset = (caretModel = editor2.getCaretModel()).getOffset()) >= off && caretOffset < endOffset && caretModel.getLogicalPosition().column == indentColumn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStartPosition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineEndPosition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IndentGuideRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCaretOnGuide";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

