/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.codeInsight.highlighting.BackgroundHighlightingUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.TestModeFlags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class IdentifierHighlighterPassFactory {
    private static final Key<Boolean> ourTestingIdentifierHighlighting = Key.create("TestingIdentifierHighlighting");

    public IdentifierHighlighterPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull TextRange visibleRange) {
        if (file2 == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(1);
        }
        if (visibleRange == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(2);
        }
        if (!editor2.isOneLineMode() && CodeInsightSettings.getInstance().HIGHLIGHT_IDENTIFIER_UNDER_CARET && !DumbService.isDumb(file2.getProject()) && IdentifierHighlighterPassFactory.isEnabled() && (file2.isPhysical() || file2.getOriginalFile().isPhysical())) {
            return new IdentifierHighlighterPass(file2, editor2, visibleRange);
        }
        return null;
    }

    public static boolean isEnabled() {
        return !ApplicationManager.getApplication().isUnitTestMode() || TestModeFlags.is(ourTestingIdentifierHighlighting);
    }

    @TestOnly
    public static void doWithHighlightingEnabled(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull Runnable r) {
        if (project2 == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(4);
        }
        if (r == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        BackgroundHighlightingUtil.enableListenersInTest(project2, parentDisposable);
        TestModeFlags.set(ourTestingIdentifierHighlighting, true);
        try {
            r.run();
        }
        finally {
            TestModeFlags.reset(ourTestingIdentifierHighlighting);
            IdentifierHighlighterPassFactory.waitForIdentifierHighlighting();
        }
    }

    @TestOnly
    public static void waitForIdentifierHighlighting() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doWithHighlightingEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

