/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class DoNotShowInspectionIntentionMenuContributor
implements IntentionMenuContributor {
    private static final Logger LOG = Logger.getInstance(DoNotShowInspectionIntentionMenuContributor.class);

    DoNotShowInspectionIntentionMenuContributor() {
    }

    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset) {
        if (hostEditor == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(0);
        }
        if (hostFile == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(1);
        }
        if (intentions == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(2);
        }
        Project project2 = hostFile.getProject();
        PsiElement psiElement = hostFile.findElementAt(offset);
        if (HighlightingLevelManager.getInstance(project2).shouldInspect(hostFile)) {
            PsiElement prev;
            PsiElement intentionElement = psiElement;
            int intentionOffset = offset;
            if (psiElement instanceof PsiWhiteSpace && offset == psiElement.getTextRange().getStartOffset() && offset > 0 && (prev = hostFile.findElementAt(offset - 1)) != null && prev.isValid()) {
                intentionElement = prev;
                intentionOffset = offset - 1;
            }
            if (intentionElement != null && (intentionElement.getManager().isInProject(intentionElement) || ScratchUtil.isScratch(hostFile.getVirtualFile()))) {
                DoNotShowInspectionIntentionMenuContributor.collectIntentionsFromDoNotShowLeveledInspections(project2, hostFile, intentionElement, intentionOffset, intentions);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void collectIntentionsFromDoNotShowLeveledInspections(@NotNull Project project2, @NotNull PsiFile hostFile, @NotNull PsiElement psiElement, int offset, @NotNull ShowIntentionsPass.IntentionsInfo outIntentions) {
        if (project2 == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(3);
        }
        if (hostFile == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(4);
        }
        if (psiElement == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(5);
        }
        if (outIntentions == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(6);
        }
        if (!psiElement.isPhysical()) {
            VirtualFile virtualFile2 = hostFile.getVirtualFile();
            String text2 = hostFile.getText();
            LOG.error("not physical: '" + psiElement.getText() + "' @" + offset + " " + psiElement.getTextRange() + " elem:" + psiElement + " (" + psiElement.getClass().getName() + ") in:" + psiElement.getContainingFile() + " host:" + hostFile + "(" + hostFile.getClass().getName() + ")", new Attachment(virtualFile2 != null ? virtualFile2.getPresentableUrl() : "null", text2 != null ? text2 : "null"));
        }
        if (DumbService.isDumb(project2) || LightEdit.owns((Project)project2)) {
            return;
        }
        ArrayList<LocalInspectionToolWrapper> intentionTools = new ArrayList<LocalInspectionToolWrapper>();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(project2).getInspectionProfile();
        for (InspectionToolWrapper<?, ?> inspectionToolWrapper : profile.getInspectionTools(hostFile)) {
            HighlightDisplayKey key;
            void var8_8;
            if (inspectionToolWrapper instanceof GlobalInspectionToolWrapper) {
                LocalInspectionToolWrapper localInspectionToolWrapper = ((GlobalInspectionToolWrapper)inspectionToolWrapper).getSharedLocalInspectionToolWrapper();
            }
            if (!(var8_8 instanceof LocalInspectionToolWrapper) || ((LocalInspectionToolWrapper)var8_8).isUnfair() || !profile.isToolEnabled(key = HighlightDisplayKey.find(var8_8.getShortName()), hostFile) || !HighlightDisplayLevel.DO_NOT_SHOW.equals(profile.getErrorLevel(key, hostFile))) continue;
            intentionTools.add((LocalInspectionToolWrapper)var8_8);
        }
        if (intentionTools.isEmpty()) {
            return;
        }
        List<PsiElement> elements = PsiTreeUtil.collectParents(psiElement, PsiElement.class, true, e -> e instanceof PsiDirectory);
        PsiElement psiElement2 = psiElement.getContainingFile().findElementAt(offset - 1);
        if (psiElement2 != psiElement && psiElement2 != null) {
            List<PsiElement> parentsOnTheLeft = PsiTreeUtil.collectParents(psiElement2, PsiElement.class, true, e -> e instanceof PsiDirectory || elements.contains(e));
            elements.addAll(parentsOnTheLeft);
        }
        Map<@NonNls K, @Nls(capitalization=Nls.Capitalization.Sentence) V> displayNames = ContainerUtil.map2Map(intentionTools, wrapper2 -> Pair.create(wrapper2.getShortName(), wrapper2.getDisplayName()));
        ProgressIndicator progress = ObjectUtils.notNull(ProgressIndicatorProvider.getGlobalProgressIndicator(), new DaemonProgressIndicator());
        Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map2 = InspectionEngine.inspectElements(intentionTools, hostFile, hostFile.getTextRange(), true, true, progress, elements, PairProcessor.alwaysTrue());
        for (Map.Entry<LocalInspectionToolWrapper, List<ProblemDescriptor>> entry : map2.entrySet()) {
            List<ProblemDescriptor> descriptors = entry.getValue();
            String shortName = entry.getKey().getShortName();
            for (ProblemDescriptor problemDescriptor : descriptors) {
                QuickFix[] fixes;
                TextRange range;
                if (!(problemDescriptor instanceof ProblemDescriptorBase) || (range = ((ProblemDescriptorBase)problemDescriptor).getTextRange()) == null || !range.containsOffset(offset) || (fixes = problemDescriptor.getFixes()) == null) continue;
                for (int k = 0; k < fixes.length; ++k) {
                    IntentionAction intentionAction = QuickFixWrapper.wrap(problemDescriptor, k);
                    HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
                    String displayName = (String)displayNames.get(shortName);
                    HighlightInfo.IntentionActionDescriptor actionDescriptor = new HighlightInfo.IntentionActionDescriptor(intentionAction, null, displayName, null, key, null, HighlightSeverity.INFORMATION);
                    (problemDescriptor.getHighlightType() == ProblemHighlightType.ERROR ? outIntentions.errorFixesToShow : outIntentions.intentionsToShow).add(actionDescriptor);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outIntentions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DoNotShowInspectionIntentionMenuContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectActions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectIntentionsFromDoNotShowLeveledInspections";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

