/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance(HighlightDisplayKey.class);
    private static final Map<String, HighlightDisplayKey> ourNameToKeyMap = new ConcurrentHashMap<String, HighlightDisplayKey>();
    private static final Map<String, HighlightDisplayKey> ourIdToKeyMap = new ConcurrentHashMap<String, HighlightDisplayKey>();
    private static final Map<HighlightDisplayKey, Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String>> ourKeyToDisplayNameMap = new ConcurrentHashMap<HighlightDisplayKey, Computable<String>>();
    private static final Map<HighlightDisplayKey, String> ourKeyToAlternativeIDMap = new ConcurrentHashMap<HighlightDisplayKey, String>();
    private final String myName;
    private final String myID;

    public static HighlightDisplayKey find(@NonNls @NotNull String name2) {
        if (name2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(0);
        }
        return ourNameToKeyMap.get(name2);
    }

    @Nullable
    public static HighlightDisplayKey findById(@NonNls @NotNull String id2) {
        HighlightDisplayKey key;
        if (id2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(1);
        }
        if ((key = ourIdToKeyMap.get(id2)) != null) {
            return key;
        }
        key = HighlightDisplayKey.find(id2);
        if (key != null && key.getID().equals(id2)) {
            return key;
        }
        return null;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name2, @NotNull String displayName, @NotNull @NonNls String id2) {
        if (name2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(3);
        }
        if (id2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(4);
        }
        return HighlightDisplayKey.register(name2, new Computable.PredefinedValueComputable<String>(displayName), id2);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name2, @NotNull Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> displayName, @NotNull @NonNls String id2) {
        HighlightDisplayKey key;
        if (name2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(5);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(6);
        }
        if (id2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(7);
        }
        if ((key = HighlightDisplayKey.find(name2)) != null) {
            LOG.error("Key with name '" + name2 + "' already registered with display name: " + HighlightDisplayKey.getDisplayNameByKey(key));
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(name2, id2);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name2, @NotNull Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> displayName, @NonNls @NotNull String id2, @NonNls @Nullable String alternativeID) {
        if (name2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(8);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(9);
        }
        if (id2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(10);
        }
        HighlightDisplayKey key = HighlightDisplayKey.register(name2, displayName, id2);
        if (alternativeID != null) {
            ourKeyToAlternativeIDMap.put(key, alternativeID);
        }
        return key;
    }

    public static void unregister(@NotNull String shortName) {
        HighlightDisplayKey key;
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(11);
        }
        if ((key = ourNameToKeyMap.remove(shortName)) != null) {
            ourIdToKeyMap.remove(key.myID);
            ourKeyToAlternativeIDMap.remove(key);
            ourKeyToDisplayNameMap.remove(key);
        }
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String name2, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String displayName) {
        if (name2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(12);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(13);
        }
        return HighlightDisplayKey.findOrRegister(name2, displayName, null);
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String name2, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String displayName, @NonNls @Nullable String id2) {
        HighlightDisplayKey key;
        if (name2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(14);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(15);
        }
        if ((key = HighlightDisplayKey.find(name2)) == null) {
            String registrationId = id2 != null ? id2 : name2;
            key = new HighlightDisplayKey(name2, registrationId);
            ourKeyToDisplayNameMap.put(key, new Computable.PredefinedValueComputable<String>(displayName));
        }
        HighlightDisplayKey highlightDisplayKey = key;
        if (highlightDisplayKey == null) {
            HighlightDisplayKey.$$$reportNull$$$0(16);
        }
        return highlightDisplayKey;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String getDisplayNameByKey(@Nullable HighlightDisplayKey key) {
        if (key == null) {
            return null;
        }
        Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> computable = ourKeyToDisplayNameMap.get(key);
        return computable == null ? null : computable.compute();
    }

    public static String getAlternativeID(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            HighlightDisplayKey.$$$reportNull$$$0(17);
        }
        return ourKeyToAlternativeIDMap.get(key);
    }

    public HighlightDisplayKey(@NonNls @NotNull String name2, @NonNls @NotNull String ID2) {
        if (name2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(18);
        }
        if (ID2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(19);
        }
        this.myName = name2;
        this.myID = ID2;
        ourNameToKeyMap.put(this.myName, this);
        if (!Objects.equals(ID2, name2)) {
            ourIdToKeyMap.put(ID2, this);
        }
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public String getID() {
        String string2 = this.myID;
        if (string2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(20);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/HighlightDisplayKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/HighlightDisplayKey";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrRegister";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOrRegister";
                break;
            }
            case 16: 
            case 20: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeID";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 16: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

