/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParenthesesInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    public static final ParenthesesInsertHandler<LookupElement> WITH_PARAMETERS = new ParenthesesInsertHandler<LookupElement>(){

        @Override
        protected boolean placeCaretInsideParentheses(InsertionContext context2, LookupElement item) {
            return true;
        }
    };
    public static final ParenthesesInsertHandler<LookupElement> NO_PARAMETERS = new ParenthesesInsertHandler<LookupElement>(){

        @Override
        protected boolean placeCaretInsideParentheses(InsertionContext context2, LookupElement item) {
            return false;
        }
    };
    private final boolean mySpaceBeforeParentheses;
    private final boolean mySpaceBetweenParentheses;
    private final boolean myMayInsertRightParenthesis;
    private final boolean myAllowParametersOnNextLine;
    private final char myLeftParenthesis;
    private final char myRightParenthesis;

    public static ParenthesesInsertHandler<LookupElement> getInstance(boolean hasParameters) {
        return hasParameters ? WITH_PARAMETERS : NO_PARAMETERS;
    }

    public static ParenthesesInsertHandler<LookupElement> getInstance(final boolean hasParameters, boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean insertRightParenthesis, boolean allowParametersOnNextLine) {
        return new ParenthesesInsertHandler<LookupElement>(spaceBeforeParentheses, spaceBetweenParentheses, insertRightParenthesis, allowParametersOnNextLine){

            @Override
            protected boolean placeCaretInsideParentheses(InsertionContext context2, LookupElement item) {
                return hasParameters;
            }
        };
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis) {
        this(spaceBeforeParentheses, spaceBetweenParentheses, mayInsertRightParenthesis, false);
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis, boolean allowParametersOnNextLine) {
        this(spaceBeforeParentheses, spaceBetweenParentheses, mayInsertRightParenthesis, allowParametersOnNextLine, '(', ')');
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis, boolean allowParametersOnNextLine, char leftParenthesis, char rightParenthesis) {
        this.mySpaceBeforeParentheses = spaceBeforeParentheses;
        this.mySpaceBetweenParentheses = spaceBetweenParentheses;
        this.myMayInsertRightParenthesis = mayInsertRightParenthesis;
        this.myAllowParametersOnNextLine = allowParametersOnNextLine;
        this.myLeftParenthesis = leftParenthesis;
        this.myRightParenthesis = rightParenthesis;
    }

    protected ParenthesesInsertHandler() {
        this(false, false, true);
    }

    private static boolean isToken(@Nullable PsiElement element2, String text2) {
        return element2 != null && text2.equals(element2.getText());
    }

    protected abstract boolean placeCaretInsideParentheses(InsertionContext var1, T var2);

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull T item) {
        int tail;
        boolean putCaretInside;
        if (context2 == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(1);
        }
        char completionChar = context2.getCompletionChar();
        Editor editor2 = context2.getEditor();
        if (completionChar != this.myLeftParenthesis && !editor2.getSettings().isInsertParenthesesAutomatically()) {
            return;
        }
        Document document = editor2.getDocument();
        context2.commitDocument();
        PsiElement lParen = this.findExistingLeftParenthesis(context2);
        boolean bl = putCaretInside = completionChar == this.myLeftParenthesis || this.placeCaretInsideParentheses(context2, item);
        if (completionChar == this.myLeftParenthesis) {
            context2.setAddCompletionChar(false);
        }
        if (lParen != null) {
            int lparenthOffset = lParen.getTextRange().getStartOffset();
            if (this.mySpaceBeforeParentheses && lparenthOffset == context2.getTailOffset()) {
                document.insertString(context2.getTailOffset(), " ");
                ++lparenthOffset;
            }
            if (completionChar == this.myLeftParenthesis || completionChar == '\t') {
                editor2.getCaretModel().moveToOffset(lparenthOffset + 1);
            } else {
                editor2.getCaretModel().moveToOffset(context2.getTailOffset());
            }
            context2.setTailOffset(lparenthOffset + 1);
            PsiElement list2 = lParen.getParent();
            PsiElement last2 = list2.getLastChild();
            if (ParenthesesInsertHandler.isToken(last2, String.valueOf(this.myRightParenthesis))) {
                int rparenthOffset = last2.getTextRange().getStartOffset();
                context2.setTailOffset(rparenthOffset + 1);
                if (!putCaretInside) {
                    for (int i = lparenthOffset + 1; i < rparenthOffset; ++i) {
                        if (Character.isWhitespace(document.getCharsSequence().charAt(i))) continue;
                        return;
                    }
                    editor2.getCaretModel().moveToOffset(context2.getTailOffset());
                } else if (this.mySpaceBetweenParentheses && document.getCharsSequence().charAt(lparenthOffset) == ' ') {
                    editor2.getCaretModel().moveToOffset(lparenthOffset + 2);
                } else {
                    editor2.getCaretModel().moveToOffset(lparenthOffset + 1);
                }
                return;
            }
        } else {
            document.insertString(context2.getTailOffset(), ParenthesesInsertHandler.getSpace(this.mySpaceBeforeParentheses) + this.myLeftParenthesis + ParenthesesInsertHandler.getSpace(this.mySpaceBetweenParentheses));
            editor2.getCaretModel().moveToOffset(context2.getTailOffset());
        }
        if (!this.myMayInsertRightParenthesis) {
            return;
        }
        if (context2.getCompletionChar() == this.myLeftParenthesis && (tail = context2.getTailOffset()) < document.getTextLength() && StringUtil.isJavaIdentifierPart(document.getCharsSequence().charAt(tail))) {
            return;
        }
        document.insertString(context2.getTailOffset(), ParenthesesInsertHandler.getSpace(this.mySpaceBetweenParentheses) + this.myRightParenthesis);
        if (!putCaretInside) {
            editor2.getCaretModel().moveToOffset(context2.getTailOffset());
        } else if (!this.mySpaceBetweenParentheses) {
            int rangeStart = context2.getStartOffset();
            int rangeEnd = Math.max(editor2.getCaretModel().getOffset(), context2.getStartOffset());
            TabOutScopesTracker.getInstance().registerScopeRange(editor2, rangeStart, rangeEnd);
        }
    }

    private static String getSpace(boolean needSpace) {
        return needSpace ? " " : "";
    }

    @Nullable
    protected PsiElement findExistingLeftParenthesis(@NotNull InsertionContext context2) {
        PsiElement element2;
        if (context2 == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(2);
        }
        return ParenthesesInsertHandler.isToken(element2 = this.findNextToken(context2), String.valueOf(this.myLeftParenthesis)) ? element2 : null;
    }

    @Nullable
    protected PsiElement findNextToken(@NotNull InsertionContext context2) {
        PsiFile file2;
        PsiElement element2;
        if (context2 == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(3);
        }
        if ((element2 = (file2 = context2.getFile()).findElementAt(context2.getTailOffset())) instanceof PsiWhiteSpace) {
            if (!this.myAllowParametersOnNextLine && element2.getText().contains("\n")) {
                return null;
            }
            element2 = file2.findElementAt(element2.getTextRange().getEndOffset());
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/util/ParenthesesInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingLeftParenthesis";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findNextToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

