/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPhaseListener;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.Weigher;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionServiceImpl
extends BaseCompletionService {
    private static final Logger LOG = Logger.getInstance(CompletionServiceImpl.class);
    private static final CompletionPhaseHolder DEFAULT_PHASE_HOLDER = new CompletionPhaseHolder(CompletionPhase.NoCompletion, null);
    private static final Map<ClientId, CompletionPhaseHolder> clientId2Holders = new ConcurrentHashMap<ClientId, CompletionPhaseHolder>();

    public CompletionServiceImpl() {
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        connection.subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

            @Override
            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<ClientId> clientIds = new ArrayList<ClientId>(clientId2Holders.keySet());
                for (ClientId clientId : clientIds) {
                    AccessToken ignored = ClientId.withClientId(clientId);
                    try {
                        CompletionProgressIndicator indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator(clientId);
                        if (indicator != null && indicator.getProject() == project2) {
                            indicator.closeAndFinish(true);
                            CompletionServiceImpl.setCompletionPhase(clientId, CompletionPhase.NoCompletion);
                            continue;
                        }
                        if (indicator != null) continue;
                        CompletionServiceImpl.setCompletionPhase(clientId, CompletionPhase.NoCompletion);
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$1", "projectClosing"));
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                ArrayList<ClientId> clientIds = new ArrayList<ClientId>(clientId2Holders.keySet());
                for (ClientId clientId : clientIds) {
                    AccessToken ignored = ClientId.withClientId(clientId);
                    try {
                        CompletionServiceImpl.setCompletionPhase(clientId, CompletionPhase.NoCompletion);
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$2", "beforePluginUnload"));
            }
        });
    }

    public static CompletionServiceImpl getCompletionService() {
        return (CompletionServiceImpl)CompletionService.getCompletionService();
    }

    @Override
    public void setAdvertisementText(@NlsContexts.PopupAdvertisement @Nullable String text2) {
        CompletionServiceImpl.setAdvertisementText(ClientId.getCurrent(), text2);
    }

    private static void setAdvertisementText(@NotNull ClientId clientId, @NlsContexts.PopupAdvertisement @Nullable String text2) {
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            return;
        }
        CompletionProgressIndicator completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator(clientId);
        if (completion != null) {
            completion.addAdvertisement(text2, null);
        }
    }

    @Override
    protected CompletionResultSet createResultSet(@NotNull CompletionParameters parameters2, @NotNull Consumer<? super CompletionResult> consumer, @NotNull CompletionContributor contributor, @NotNull PrefixMatcher matcher) {
        if (parameters2 == null) {
            CompletionServiceImpl.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            CompletionServiceImpl.$$$reportNull$$$0(2);
        }
        if (contributor == null) {
            CompletionServiceImpl.$$$reportNull$$$0(3);
        }
        if (matcher == null) {
            CompletionServiceImpl.$$$reportNull$$$0(4);
        }
        return new CompletionResultSetImpl(consumer, matcher, contributor, parameters2, null, null);
    }

    @Override
    public CompletionProcess getCurrentCompletion() {
        return this.getCurrentCompletion(ClientId.getCurrent());
    }

    private CompletionProcess getCurrentCompletion(@NotNull ClientId clientId) {
        CompletionProgressIndicator indicator;
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(5);
        }
        if ((indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator(clientId)) != null) {
            return indicator;
        }
        return clientId.equals(ClientId.getLocalId()) ? this.myApiCompletionProcess : null;
    }

    public static CompletionProgressIndicator getCurrentCompletionProgressIndicator() {
        return CompletionServiceImpl.getCurrentCompletionProgressIndicator(ClientId.getCurrent());
    }

    private static CompletionProgressIndicator getCurrentCompletionProgressIndicator(@NotNull ClientId clientId) {
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(6);
        }
        return CompletionServiceImpl.getCurrentCompletionProgressIndicator(CompletionServiceImpl.getCompletionPhase(clientId));
    }

    private static CompletionProgressIndicator getCurrentCompletionProgressIndicator(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(7);
        }
        if (CompletionServiceImpl.isPhase(phase, CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.CommittingDocuments.class, CompletionPhase.Synchronous.class)) {
            return phase.indicator;
        }
        return null;
    }

    @SafeVarargs
    public static void assertPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(8);
        }
        CompletionServiceImpl.assertPhase(ClientId.getCurrent(), possibilities);
    }

    @SafeVarargs
    private static void assertPhase(@NotNull ClientId clientId, Class<? extends CompletionPhase> ... possibilities) {
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(9);
        }
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(10);
        }
        CompletionServiceImpl.assertPhase(clientId, CompletionServiceImpl.getCompletionPhaseHolder(clientId), possibilities);
    }

    @SafeVarargs
    private static void assertPhase(@NotNull ClientId clientId, @NotNull CompletionPhaseHolder phaseHolder, Class<? extends CompletionPhase> ... possibilities) {
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(11);
        }
        if (phaseHolder == null) {
            CompletionServiceImpl.$$$reportNull$$$0(12);
        }
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(13);
        }
        if (!CompletionServiceImpl.isPhase(phaseHolder.getPhase(), possibilities)) {
            CompletionServiceImpl.reportPhase(clientId, phaseHolder);
        }
    }

    private static void reportPhase(@NotNull ClientId clientId, @NotNull CompletionPhaseHolder phaseHolder) {
        Throwable phaseTrace;
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(14);
        }
        if (phaseHolder == null) {
            CompletionServiceImpl.$$$reportNull$$$0(15);
        }
        String traceText = (phaseTrace = phaseHolder.getPhaseTrace()) != null ? "; set at " + ExceptionUtil.getThrowableText(phaseTrace) : "";
        LOG.error(phaseHolder.getPhase() + "; " + clientId + traceText);
    }

    @SafeVarargs
    public static boolean isPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(16);
        }
        return CompletionServiceImpl.isPhase(ClientId.getCurrent(), possibilities);
    }

    @SafeVarargs
    private static boolean isPhase(@NotNull ClientId clientId, Class<? extends CompletionPhase> ... possibilities) {
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(17);
        }
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(18);
        }
        return CompletionServiceImpl.isPhase(CompletionServiceImpl.getCompletionPhase(clientId), possibilities);
    }

    @SafeVarargs
    private static boolean isPhase(@NotNull CompletionPhase phase, Class<? extends CompletionPhase> ... possibilities) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(19);
        }
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(20);
        }
        for (Class<? extends CompletionPhase> possibility : possibilities) {
            if (!possibility.isInstance(phase)) continue;
            return true;
        }
        return false;
    }

    public static void setCompletionPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(21);
        }
        CompletionServiceImpl.setCompletionPhase(ClientId.getCurrent(), phase);
    }

    private static void setCompletionPhase(@NotNull ClientId clientId, @NotNull CompletionPhase phase) {
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(22);
        }
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase(clientId);
        CompletionProgressIndicator oldIndicator = oldPhase.indicator;
        if (oldIndicator != null && !(phase instanceof CompletionPhase.BgCalculation) && oldIndicator.isRunning() && !oldIndicator.isCanceled()) {
            LOG.error("don't change phase during running completion: oldPhase=" + oldPhase);
        }
        boolean wasCompletionRunning = CompletionServiceImpl.isRunningPhase(oldPhase);
        boolean isCompletionRunning = CompletionServiceImpl.isRunningPhase(phase);
        if (isCompletionRunning != wasCompletionRunning) {
            ApplicationManager.getApplication().getMessageBus().syncPublisher(CompletionPhaseListener.TOPIC).completionPhaseChanged(isCompletionRunning);
        }
        Disposer.dispose(oldPhase);
        if (CompletionServiceImpl.isPhase(phase, CompletionPhase.NoCompletion.getClass()) && !ClientId.isValid(clientId)) {
            clientId2Holders.remove(clientId);
            return;
        }
        Throwable phaseTrace = new Throwable();
        CompletionPhaseHolder holder = new CompletionPhaseHolder(phase, phaseTrace);
        CompletionPhaseHolder previous = clientId2Holders.put(clientId, holder);
        if (previous == null) {
            Disposer.register(ClientId.toDisposable(clientId), () -> {
                if (CompletionServiceImpl.isPhase(clientId, CompletionPhase.NoCompletion.getClass())) {
                    clientId2Holders.remove(clientId);
                }
            });
        }
    }

    private static boolean isRunningPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(24);
        }
        return phase != CompletionPhase.NoCompletion && !(phase instanceof CompletionPhase.ZombiePhase) && !(phase instanceof CompletionPhase.ItemsCalculated);
    }

    @NotNull
    public static CompletionPhase getCompletionPhase() {
        return CompletionServiceImpl.getCompletionPhase(ClientId.getCurrent());
    }

    @NotNull
    private static CompletionPhase getCompletionPhase(@NotNull ClientId clientId) {
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(25);
        }
        CompletionPhase completionPhase = CompletionServiceImpl.getCompletionPhaseHolder(clientId).getPhase();
        if (completionPhase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(26);
        }
        return completionPhase;
    }

    @NotNull
    private static CompletionPhaseHolder getCompletionPhaseHolder(@NotNull ClientId clientId) {
        if (clientId == null) {
            CompletionServiceImpl.$$$reportNull$$$0(27);
        }
        CompletionPhaseHolder completionPhaseHolder = clientId2Holders.getOrDefault(clientId, DEFAULT_PHASE_HOLDER);
        if (completionPhaseHolder == null) {
            CompletionServiceImpl.$$$reportNull$$$0(28);
        }
        return completionPhaseHolder;
    }

    @Override
    @NotNull
    protected CompletionSorterImpl addWeighersBefore(@NotNull CompletionSorterImpl sorter) {
        if (sorter == null) {
            CompletionServiceImpl.$$$reportNull$$$0(29);
        }
        CompletionSorterImpl processed = super.addWeighersBefore(sorter);
        CompletionSorterImpl completionSorterImpl = processed.withClassifier(CompletionSorterImpl.weighingFactory(new LiveTemplateWeigher()));
        if (completionSorterImpl == null) {
            CompletionServiceImpl.$$$reportNull$$$0(30);
        }
        return completionSorterImpl;
    }

    @Override
    @NotNull
    protected CompletionSorterImpl processStatsWeigher(@NotNull CompletionSorterImpl sorter, @NotNull Weigher weigher, final @NotNull CompletionLocation location) {
        if (sorter == null) {
            CompletionServiceImpl.$$$reportNull$$$0(31);
        }
        if (weigher == null) {
            CompletionServiceImpl.$$$reportNull$$$0(32);
        }
        if (location == null) {
            CompletionServiceImpl.$$$reportNull$$$0(33);
        }
        CompletionSorterImpl processedSorter = super.processStatsWeigher(sorter, weigher, location);
        CompletionSorterImpl completionSorterImpl = processedSorter.withClassifier(new ClassifierFactory<LookupElement>("stats"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
            }
        });
        if (completionSorterImpl == null) {
            CompletionServiceImpl.$$$reportNull$$$0(34);
        }
        return completionSorterImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 34: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 7: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibilities";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phaseHolder";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weigher";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPhase";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPhaseHolder";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeighersBefore";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "processStatsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAdvertisementText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createResultSet";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentCompletion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentCompletionProgressIndicator";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "assertPhase";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportPhase";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPhase";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionPhase";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPhase";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionPhase";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 34: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionPhaseHolder";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addWeighersBefore";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processStatsWeigher";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 34: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompletionPhaseHolder {
        @NotNull
        private final CompletionPhase ourPhase;
        @Nullable
        private final Throwable ourPhaseTrace;

        CompletionPhaseHolder(@NotNull CompletionPhase phase, @Nullable Throwable phaseTrace) {
            if (phase == null) {
                CompletionPhaseHolder.$$$reportNull$$$0(0);
            }
            this.ourPhase = phase;
            this.ourPhaseTrace = phaseTrace;
        }

        @NotNull
        CompletionPhase getPhase() {
            CompletionPhase completionPhase = this.ourPhase;
            if (completionPhase == null) {
                CompletionPhaseHolder.$$$reportNull$$$0(1);
            }
            return completionPhase;
        }

        @Nullable
        Throwable getPhaseTrace() {
            return this.ourPhaseTrace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phase";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionPhaseHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionPhaseHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPhase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CompletionResultSetImpl
    extends BaseCompletionService.BaseCompletionResultSet {
        CompletionResultSetImpl(Consumer<? super CompletionResult> consumer, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters2, @Nullable CompletionSorter sorter, @Nullable CompletionResultSetImpl original) {
            super(consumer, prefixMatcher, contributor, parameters2, sorter, original);
        }

        @Override
        public void addAllElements(@NotNull Iterable<? extends LookupElement> elements) {
            if (elements == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(0);
            }
            CompletionThreadingBase.withBatchUpdate(() -> super.addAllElements(elements), this.myParameters.getProcess());
        }

        @Override
        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(1);
            }
            if (matcher.equals(this.getPrefixMatcher())) {
                CompletionResultSetImpl completionResultSetImpl = this;
                if (completionResultSetImpl == null) {
                    CompletionResultSetImpl.$$$reportNull$$$0(2);
                }
                return completionResultSetImpl;
            }
            return new CompletionResultSetImpl(this.getConsumer(), matcher, this.myContributor, this.myParameters, this.mySorter, this);
        }

        @Override
        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(3);
            }
            return new CompletionResultSetImpl(this.getConsumer(), this.getPrefixMatcher(), this.myContributor, this.myParameters, sorter, this);
        }

        @Override
        public void addLookupAdvertisement(@NotNull String text2) {
            if (text2 == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(4);
            }
            CompletionServiceImpl.getCompletionService().setAdvertisementText(text2);
        }

        @Override
        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProcessBase) {
                ((CompletionProcessBase)process2).addWatchedPrefix(this.myParameters.getOffset() - this.getPrefixMatcher().getPrefix().length(), prefixCondition);
            }
        }

        @Override
        public void restartCompletionWhenNothingMatches() {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProgressIndicator) {
                ((CompletionProgressIndicator)process2).getLookup().setStartCompletionWhenNothingMatches(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addAllElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixMatcher";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelevanceSorter";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupAdvertisement";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

