/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.PairConsumer;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class LegacyCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(LegacyCompletionContributor.class);

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet _result) {
        if (parameters2 == null) {
            LegacyCompletionContributor.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            LegacyCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters2.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        CompletionData completionData = LegacyCompletionContributor.getCompletionData(parameters2);
        if (completionData == null) {
            return;
        }
        PsiElement insertedElement = parameters2.getPosition();
        CompletionResultSet result2 = _result.withPrefixMatcher(completionData.findPrefix(insertedElement, parameters2.getOffset()));
        LegacyCompletionContributor.completeReference(parameters2, result2);
        if (DumbService.isDumb(insertedElement.getProject())) {
            return;
        }
        LinkedHashSet<LookupElement> lookupSet = new LinkedHashSet<LookupElement>();
        HashSet keywordVariants = new HashSet();
        PsiFile file2 = parameters2.getOriginalFile();
        completionData.addKeywordVariants(keywordVariants, insertedElement, file2);
        completionData.completeKeywordsBySet(lookupSet, keywordVariants);
        result2.addAllElements(lookupSet);
    }

    @Override
    public void beforeCompletion(@NotNull CompletionInitializationContext context2) {
        PsiFile file2;
        PsiElement element2;
        if (context2 == null) {
            LegacyCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((element2 = (file2 = context2.getFile()).findElementAt(context2.getStartOffset())) instanceof PsiWhiteSpace && element2.textContains('\n') && element2.getTextRange().getStartOffset() == context2.getStartOffset()) {
            context2.setReplacementOffset(context2.getStartOffset());
        }
    }

    public static boolean completeReference(CompletionParameters parameters2, CompletionResultSet result2) {
        CompletionData completionData = LegacyCompletionContributor.getCompletionData(parameters2);
        if (completionData == null) {
            return false;
        }
        Ref<Boolean> hasVariants = Ref.create(false);
        LegacyCompletionContributor.processReferences(parameters2, result2, (reference2, resultSet) -> {
            LinkedHashSet lookupSet = new LinkedHashSet();
            completionData.completeReference((PsiReference)reference2, lookupSet, parameters2.getPosition(), parameters2.getOriginalFile());
            for (LookupElement item : lookupSet) {
                if (!resultSet.getPrefixMatcher().prefixMatches(item)) continue;
                if (!item.isValid()) {
                    LOG.error(completionData + " has returned an invalid lookup element " + item + " of " + item.getClass() + " in " + parameters2.getOriginalFile() + " of " + parameters2.getOriginalFile().getClass() + "; reference=" + reference2 + " of " + reference2.getClass());
                }
                hasVariants.set(true);
                resultSet.addElement(item);
            }
        });
        return hasVariants.get();
    }

    private static CompletionData getCompletionData(CompletionParameters parameters2) {
        PsiElement position = parameters2.getPosition();
        return CompletionUtil.getCompletionDataByElement(position, parameters2.getOriginalFile());
    }

    public static void processReferences(CompletionParameters parameters2, CompletionResultSet result2, PairConsumer<? super PsiReference, ? super CompletionResultSet> consumer) {
        int startOffset = parameters2.getOffset();
        PsiReference ref = parameters2.getPosition().getContainingFile().findReferenceAt(startOffset);
        if (ref instanceof PsiMultiReference) {
            for (PsiReference reference2 : CompletionData.getReferences((PsiMultiReference)ref)) {
                LegacyCompletionContributor.processReference(result2, startOffset, consumer, reference2);
            }
        } else if (ref instanceof PsiDynaReference) {
            for (PsiReference reference3 : ((PsiDynaReference)ref).getReferences()) {
                LegacyCompletionContributor.processReference(result2, startOffset, consumer, reference3);
            }
        } else if (ref != null) {
            LegacyCompletionContributor.processReference(result2, startOffset, consumer, ref);
        }
    }

    private static void processReference(CompletionResultSet result2, int startOffset, PairConsumer<? super PsiReference, ? super CompletionResultSet> consumer, PsiReference reference2) {
        PsiElement element2 = reference2.getElement();
        int offsetInElement = startOffset - element2.getTextRange().getStartOffset();
        if (!ReferenceRange.containsOffsetInElement(reference2, offsetInElement)) {
            return;
        }
        TextRange range = reference2.getRangeInElement();
        try {
            String prefix = element2.getText().substring(range.getStartOffset(), offsetInElement);
            consumer.consume(reference2, result2.withPrefixMatcher(prefix));
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Reference=" + reference2 + "; element=" + element2 + " of " + element2.getClass() + "; range=" + range + "; offset=" + offsetInElement, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/LegacyCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

