/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.ActionTracker;
import com.intellij.codeInsight.completion.AsyncCompletion;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionInitializationUtil;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.actions.BaseCodeCompletionAction;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CodeCompletionHandlerBase {
    private static final Logger LOG = Logger.getInstance(CodeCompletionHandlerBase.class);
    private static final Key<Boolean> CARET_PROCESSED = Key.create("CodeCompletionHandlerBase.caretProcessed");
    public static final Key<Boolean> DIRECT_INSERTION = Key.create("CodeCompletionHandlerBase.directInsertion");
    @NotNull
    final CompletionType completionType;
    final boolean invokedExplicitly;
    final boolean synchronous;
    final boolean autopopup;
    private static int ourAutoInsertItemTimeout = Registry.intValue("ide.completion.auto.insert.item.timeout", 2000);

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(0);
        }
        return CodeCompletionHandlerBase.createHandler(completionType, true, false, true);
    }

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        AnAction codeCompletionAction;
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(1);
        }
        if ((codeCompletionAction = ActionManager.getInstance().getAction("CodeCompletion")) instanceof OverridingAction) {
            codeCompletionAction = ((ActionManagerImpl)ActionManager.getInstance()).getBaseAction((OverridingAction)codeCompletionAction);
        }
        assert (codeCompletionAction instanceof BaseCodeCompletionAction);
        BaseCodeCompletionAction baseCodeCompletionAction = (BaseCodeCompletionAction)codeCompletionAction;
        return baseCodeCompletionAction.createHandler(completionType, invokedExplicitly, autopopup, synchronous);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(2);
        }
        this(completionType, true, false, true);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(3);
        }
        this.completionType = completionType;
        this.invokedExplicitly = invokedExplicitly;
        this.autopopup = autopopup;
        this.synchronous = synchronous;
        if (autopopup) assert (!invokedExplicitly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCompletionElementSelected(@NotNull LookupElement item, char completionChar, OffsetMap offsetMap, OffsetsInFile hostOffsets, Editor editor2, Integer initialOffset) {
        if (item == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(4);
        }
        InsertionContext context2 = null;
        try {
            StatisticsUpdate update2 = StatisticsUpdate.collectStatisticChanges(item);
            context2 = CodeCompletionHandlerBase.insertItemHonorBlockSelection(new ArrayList<LookupElement>(), item, completionChar, offsetMap, hostOffsets, editor2, initialOffset, update2);
            update2.trackStatistics(context2);
        }
        finally {
            if (context2 != null && context2.getLaterRunnable() != null) {
                context2.getLaterRunnable().run();
            }
        }
    }

    public final void invokeCompletion(Project project2, Editor editor2) {
        this.invokeCompletion(project2, editor2, 1);
    }

    public final void invokeCompletion(@NotNull Project project2, @NotNull Editor editor2, int time) {
        if (project2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(6);
        }
        this.invokeCompletion(project2, editor2, time, false);
    }

    public final void invokeCompletion(@NotNull Project project2, @NotNull Editor editor2, int time, boolean hasModifiers) {
        if (project2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(8);
        }
        CodeCompletionHandlerBase.clearCaretMarkers(editor2);
        this.invokeCompletion(project2, editor2, time, hasModifiers, editor2.getCaretModel().getPrimaryCaret());
    }

    private void invokeCompletion(@NotNull Project project2, @NotNull Editor editor2, int time, boolean hasModifiers, @NotNull Caret caret) {
        block13: {
            if (project2 == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(9);
            }
            if (editor2 == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(10);
            }
            if (caret == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(11);
            }
            CodeCompletionHandlerBase.markCaretAsProcessed(caret);
            if (this.invokedExplicitly) {
                StatisticsUpdate.applyLastCompletionStatisticsUpdate();
            }
            CodeCompletionHandlerBase.checkNoWriteAccess();
            CompletionAssertions.checkEditorValid(editor2);
            int offset = editor2.getCaretModel().getOffset();
            if (editor2.isViewer() || editor2.getDocument().getRangeGuard(offset, offset) != null) {
                editor2.getDocument().fireReadOnlyModificationAttempt();
                EditorModificationUtil.checkModificationAllowed((Editor)editor2);
                return;
            }
            if (!FileDocumentManager.getInstance().requestWriting(editor2.getDocument(), project2)) {
                return;
            }
            CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
            boolean repeated = phase.indicator != null && phase.indicator.isRepeatedInvocation(this.completionType, editor2);
            int newTime = phase.newCompletionStarted(time, repeated);
            if (this.invokedExplicitly) {
                time = newTime;
            }
            int invocationCount = time;
            if (CompletionServiceImpl.isPhase(CompletionPhase.InsertedSingleItem.class)) {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            }
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass(), CompletionPhase.CommittingDocuments.class);
            if (invocationCount > 1 && this.completionType == CompletionType.BASIC) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.basic");
            }
            long startingTime = System.currentTimeMillis();
            Runnable initCmd = () -> {
                boolean hasValidContext;
                WriteAction.run(() -> EditorUtil.fillVirtualSpaceUntilCaret((Editor)editor2));
                CompletionInitializationContextImpl context2 = this.withTimeout(CodeCompletionHandlerBase.calcSyncTimeOut(startingTime), () -> CompletionInitializationUtil.createCompletionInitializationContext(project2, editor2, caret, invocationCount, this.completionType));
                boolean bl = hasValidContext = context2 != null;
                if (!hasValidContext) {
                    PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(caret, project2);
                    context2 = new CompletionInitializationContextImpl(editor2, caret, psiFile, this.completionType, invocationCount);
                }
                this.doComplete(context2, hasModifiers, hasValidContext, startingTime);
            };
            try {
                if (this.autopopup) {
                    CommandProcessor.getInstance().runUndoTransparentAction(initCmd);
                } else {
                    CommandProcessor.getInstance().executeCommand(project2, initCmd, null, null, editor2.getDocument());
                }
            }
            catch (IndexNotReadyException e) {
                if (!this.invokedExplicitly) break block13;
                DumbService.getInstance(project2).showDumbModeNotification(CodeInsightBundle.message("completion.not.available.during.indexing", new Object[0]));
            }
        }
    }

    private static void checkNoWriteAccess() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Completion should not be invoked inside write action");
        }
    }

    @NotNull
    private LookupImpl obtainLookup(Editor editor2, Project project2) {
        CompletionAssertions.checkEditorValid(editor2);
        LookupImpl existing = (LookupImpl)LookupManager.getActiveLookup(editor2);
        if (existing != null && existing.isCompletion()) {
            existing.markReused();
            if (!this.autopopup) {
                existing.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
            }
            LookupImpl lookupImpl = existing;
            if (lookupImpl == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(12);
            }
            return lookupImpl;
        }
        LookupImpl lookup2 = (LookupImpl)LookupManager.getInstance(project2).createLookup(editor2, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        if (editor2.isOneLineMode()) {
            lookup2.setCancelOnClickOutside(true);
            lookup2.setCancelOnOtherWindowOpen(true);
        }
        lookup2.setLookupFocusDegree(this.autopopup ? LookupFocusDegree.UNFOCUSED : LookupFocusDegree.FOCUSED);
        LookupImpl lookupImpl = lookup2;
        if (lookupImpl == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(13);
        }
        return lookupImpl;
    }

    private void doComplete(CompletionInitializationContextImpl initContext, boolean hasModifiers, boolean isValidContext, long startingTime) {
        OffsetsInFile hostCopyOffsets;
        Editor editor2 = initContext.getEditor();
        CompletionAssertions.checkEditorValid(editor2);
        LookupImpl lookup2 = this.obtainLookup(editor2, initContext.getProject());
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        if (phase instanceof CompletionPhase.CommittingDocuments) {
            if (phase.indicator != null) {
                phase.indicator.closeAndFinish(false);
            }
            ((CompletionPhase.CommittingDocuments)phase).replaced = true;
        } else {
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        }
        CompletionProgressIndicator indicator = new CompletionProgressIndicator(editor2, initContext.getCaret(), initContext.getInvocationCount(), this, initContext.getOffsetMap(), initContext.getHostOffsets(), hasModifiers, lookup2);
        if (this.synchronous && isValidContext && (hostCopyOffsets = this.withTimeout(CodeCompletionHandlerBase.calcSyncTimeOut(startingTime), () -> {
            PsiDocumentManager.getInstance(initContext.getProject()).commitAllDocuments();
            return CompletionInitializationUtil.insertDummyIdentifier(initContext, indicator).get();
        })) != null) {
            this.trySynchronousCompletion(initContext, hasModifiers, startingTime, indicator, hostCopyOffsets);
            return;
        }
        this.scheduleContributorsAfterAsyncCommit(initContext, indicator, hasModifiers);
    }

    private void scheduleContributorsAfterAsyncCommit(CompletionInitializationContextImpl initContext, CompletionProgressIndicator indicator, boolean hasModifiers) {
        CompletionPhase phase;
        if (this.synchronous) {
            phase = new CompletionPhase.BgCalculation(indicator);
            indicator.showLookup();
        } else {
            phase = new CompletionPhase.CommittingDocuments(indicator, InjectedLanguageEditorUtil.getTopLevelEditor(indicator.getEditor()));
        }
        CompletionServiceImpl.setCompletionPhase(phase);
        ReadAction.nonBlocking(() -> CompletionInitializationUtil.insertDummyIdentifier(initContext, indicator)).expireWith(phase).withDocumentsCommitted(indicator.getProject()).finishOnUiThread(ModalityState.defaultModalityState(), applyPsiChanges -> {
            OffsetsInFile hostCopyOffsets = (OffsetsInFile)applyPsiChanges.get();
            if (phase instanceof CompletionPhase.CommittingDocuments) {
                ((CompletionPhase.CommittingDocuments)phase).replaced = true;
            }
            CompletionServiceImpl.setCompletionPhase(new CompletionPhase.BgCalculation(indicator));
            this.startContributorThread(initContext, indicator, hostCopyOffsets, hasModifiers);
        }).submit(AppExecutorUtil.getAppExecutorService());
    }

    private void trySynchronousCompletion(CompletionInitializationContextImpl initContext, boolean hasModifiers, long startingTime, CompletionProgressIndicator indicator, OffsetsInFile hostCopyOffsets) {
        CompletionServiceImpl.setCompletionPhase(new CompletionPhase.Synchronous(indicator));
        Future<?> future2 = this.startContributorThread(initContext, indicator, hostCopyOffsets, hasModifiers);
        if (future2 == null) {
            return;
        }
        int timeout = CodeCompletionHandlerBase.calcSyncTimeOut(startingTime);
        if (indicator.blockingWaitForFinish(timeout)) {
            CodeCompletionHandlerBase.checkForExceptions(future2);
            try {
                indicator.getLookup().refreshUi(true, false);
                this.completionFinished(indicator, hasModifiers);
            }
            catch (Throwable e) {
                LOG.error(e);
                indicator.closeAndFinish(true);
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            }
            return;
        }
        CompletionServiceImpl.setCompletionPhase(new CompletionPhase.BgCalculation(indicator));
        indicator.showLookup();
    }

    @Nullable
    private Future<?> startContributorThread(CompletionInitializationContextImpl initContext, CompletionProgressIndicator indicator, OffsetsInFile hostCopyOffsets, boolean hasModifiers) {
        if (!hostCopyOffsets.getFile().isValid()) {
            this.completionFinished(indicator, hasModifiers);
            return null;
        }
        return indicator.getCompletionThreading().startThread(indicator, () -> AsyncCompletion.tryReadOrCancel(indicator, () -> {
            OffsetsInFile finalOffsets = CompletionInitializationUtil.toInjectedIfAny(initContext.getFile(), hostCopyOffsets);
            indicator.registerChildDisposable(finalOffsets::getOffsets);
            CompletionParameters parameters2 = CompletionInitializationUtil.createCompletionParameters(initContext, indicator, finalOffsets);
            parameters2.setIsTestingMode(this.isTestingMode());
            indicator.setParameters(parameters2);
            indicator.runContributors(initContext);
        }));
    }

    private static void checkForExceptions(Future<?> future2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                future2.get();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    private static void checkNotSync(CompletionProgressIndicator indicator, List<LookupElement> allItems) {
        if (CompletionServiceImpl.isPhase(CompletionPhase.Synchronous.class)) {
            LOG.error("sync phase survived: " + allItems + "; indicator=" + CompletionServiceImpl.getCompletionPhase().indicator + "; myIndicator=" + indicator);
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
    }

    private AutoCompletionDecision shouldAutoComplete(@NotNull CompletionProgressIndicator indicator, @NotNull List<? extends LookupElement> items, @NotNull CompletionParameters parameters2) {
        if (indicator == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(14);
        }
        if (items == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(15);
        }
        if (parameters2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(16);
        }
        if (!this.invokedExplicitly) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        LookupElement item = items.get(0);
        if (items.size() == 1) {
            AutoCompletionPolicy policy = CodeCompletionHandlerBase.getAutocompletionPolicy(item);
            if (policy == AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
            if (policy == AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE) {
                return AutoCompletionDecision.insertItem(item);
            }
            if (!indicator.getLookup().itemMatcher(item).isStartMatch(item)) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
        }
        if (!CodeCompletionHandlerBase.isAutocompleteOnInvocation(parameters2.getCompletionType())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (CodeCompletionHandlerBase.isInsideIdentifier(indicator.getOffsetMap())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (items.size() == 1 && CodeCompletionHandlerBase.getAutocompletionPolicy(item) == AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE) {
            return AutoCompletionDecision.insertItem(item);
        }
        AutoCompletionContext context2 = new AutoCompletionContext(parameters2, items.toArray(LookupElement.EMPTY_ARRAY), indicator.getOffsetMap(), indicator.getLookup());
        AutoCompletionDecision resultingDecision = (AutoCompletionDecision)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            for (CompletionContributor contributor : CompletionContributor.forParameters(parameters2)) {
                AutoCompletionDecision decision = contributor.handleAutoCompletionPossibility(context2);
                if (decision == null) continue;
                return decision;
            }
            return null;
        });
        if (resultingDecision != null) {
            return resultingDecision;
        }
        return AutoCompletionDecision.SHOW_LOOKUP;
    }

    @Nullable
    private static AutoCompletionPolicy getAutocompletionPolicy(LookupElement element2) {
        return element2.getAutoCompletionPolicy();
    }

    private static boolean isInsideIdentifier(OffsetMap offsetMap) {
        return offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != offsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
        List<LookupElement> items = indicator.getLookup().getItems();
        if (items.isEmpty()) {
            LookupManager.hideActiveLookup(indicator.getProject());
            Caret nextCaret = CodeCompletionHandlerBase.getNextCaretToProcess(indicator.getEditor());
            if (nextCaret != null) {
                this.invokeCompletion(indicator.getProject(), indicator.getEditor(), indicator.getInvocationCount(), hasModifiers, nextCaret);
            } else {
                indicator.handleEmptyLookup(true);
                CodeCompletionHandlerBase.checkNotSync(indicator, items);
            }
            return;
        }
        LOG.assertTrue(!indicator.isRunning(), "running");
        LOG.assertTrue(!indicator.isCanceled(), "canceled");
        try {
            AutoCompletionDecision decision;
            CompletionParameters parameters2 = indicator.getParameters();
            AutoCompletionDecision autoCompletionDecision = decision = parameters2 == null ? AutoCompletionDecision.CLOSE_LOOKUP : this.shouldAutoComplete(indicator, items, parameters2);
            if (decision == AutoCompletionDecision.SHOW_LOOKUP) {
                indicator.getLookup().setCalculating(false);
                indicator.showLookup();
                CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(indicator));
            } else if (decision instanceof AutoCompletionDecision.InsertItem) {
                Runnable restorePrefix = CodeCompletionHandlerBase.rememberDocumentState(indicator.getEditor());
                LookupElement item = ((AutoCompletionDecision.InsertItem)decision).getElement();
                CommandProcessor.getInstance().executeCommand(indicator.getProject(), () -> {
                    indicator.setMergeCommand();
                    indicator.getLookup().finishLookup('\u0000', item);
                }, CodeInsightBundle.message("completion.automatic.command.name", new Object[0]), null);
                if (CompletionService.getCompletionService().getCurrentCompletion() == null && !CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class)) {
                    CompletionServiceImpl.setCompletionPhase(hasModifiers ? new CompletionPhase.InsertedSingleItem(indicator, restorePrefix) : CompletionPhase.NoCompletion);
                }
            } else if (decision == AutoCompletionDecision.CLOSE_LOOKUP) {
                LookupManager.hideActiveLookup(indicator.getProject());
            }
        }
        catch (Throwable e) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            LOG.error(e);
        }
        finally {
            CodeCompletionHandlerBase.checkNotSync(indicator, items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupItemSelected(CompletionProgressIndicator indicator, @NotNull LookupElement item, char completionChar, List<LookupElement> items) {
        Runnable runnable;
        if (item == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(17);
        }
        if (indicator.isAutopopupCompletion()) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.basic");
        }
        InsertionContext context2 = null;
        try {
            StatisticsUpdate update2 = StatisticsUpdate.collectStatisticChanges(item);
            context2 = item.getUserData(DIRECT_INSERTION) != null ? CodeCompletionHandlerBase.callHandleInsert(indicator, item, completionChar) : CodeCompletionHandlerBase.insertItemHonorBlockSelection(indicator, item, completionChar, update2);
            update2.trackStatistics(context2);
            runnable = context2 == null ? null : context2.getLaterRunnable();
        }
        catch (Throwable throwable) {
            this.afterItemInsertion(indicator, context2 == null ? null : context2.getLaterRunnable());
            throw throwable;
        }
        this.afterItemInsertion(indicator, runnable);
    }

    public static CompletionAssertions.WatchingInsertionContext insertItemHonorBlockSelection(List<LookupElement> itemsAround, LookupElement item, char completionChar, OffsetMap offsetMap, OffsetsInFile hostOffset, Editor editor2, Integer caretOffset, StatisticsUpdate update2) {
        int idEndOffset = CompletionUtil.calcIdEndOffset(offsetMap, editor2, caretOffset);
        int idEndOffsetDelta = idEndOffset - caretOffset;
        CompletionAssertions.WatchingInsertionContext context2 = CodeCompletionHandlerBase.doInsertItem(hostOffset, item, completionChar, update2, editor2, Objects.requireNonNull(editor2.getProject()), caretOffset, offsetMap, itemsAround, idEndOffset, idEndOffsetDelta);
        if (context2.shouldAddCompletionChar()) {
            WriteAction.run(() -> CodeCompletionHandlerBase.addCompletionChar(context2, item));
        }
        return context2;
    }

    private static CompletionAssertions.WatchingInsertionContext insertItemHonorBlockSelection(CompletionProcessEx indicator, LookupElement item, char completionChar, StatisticsUpdate update2) {
        Editor editor2 = indicator.getEditor();
        int caretOffset = indicator.getCaret().getOffset();
        OffsetMap offsetMap = indicator.getOffsetMap();
        Lookup lookup2 = indicator.getLookup();
        List<LookupElement> items = lookup2 != null ? lookup2.getItems() : Collections.emptyList();
        int idEndOffset = CompletionUtil.calcIdEndOffset(offsetMap, editor2, caretOffset);
        int idEndOffsetDelta = idEndOffset - caretOffset;
        CompletionAssertions.WatchingInsertionContext context2 = CodeCompletionHandlerBase.doInsertItem(indicator.getHostOffsets(), item, completionChar, update2, editor2, indicator.getProject(), caretOffset, offsetMap, items, idEndOffset, idEndOffsetDelta);
        if (lookup2 != null) {
            update2.addSparedChars(lookup2, item, context2);
        }
        if (context2.shouldAddCompletionChar()) {
            WriteAction.run(() -> CodeCompletionHandlerBase.addCompletionChar(context2, item));
        }
        CodeCompletionHandlerBase.checkPsiTextConsistency(indicator);
        return context2;
    }

    private static CompletionAssertions.WatchingInsertionContext doInsertItem(@NotNull OffsetsInFile topLevelOffsets, LookupElement item, char completionChar, StatisticsUpdate update2, @NotNull Editor editor2, @NotNull Project project2, int caretOffset, OffsetMap offsetMap, List<LookupElement> items, int idEndOffset, int idEndOffsetDelta) {
        CompletionAssertions.WatchingInsertionContext context2;
        if (topLevelOffsets == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(18);
        }
        if (editor2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(19);
        }
        if (project2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(20);
        }
        if (editor2.getCaretModel().supportsMultipleCarets()) {
            Ref lastContext = Ref.create();
            Editor hostEditor = InjectedLanguageEditorUtil.getTopLevelEditor(editor2);
            boolean wasInjected = hostEditor != editor2;
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                OffsetsInFile targetOffsets = CodeCompletionHandlerBase.findInjectedOffsetsIfAny(caret, wasInjected, topLevelOffsets, hostEditor);
                PsiFile targetFile = targetOffsets.getFile();
                Editor targetEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, targetFile);
                int targetCaretOffset = targetEditor.getCaretModel().getOffset();
                int idEnd = targetCaretOffset + idEndOffsetDelta;
                if (idEnd > targetEditor.getDocument().getTextLength()) {
                    idEnd = targetCaretOffset;
                }
                CompletionAssertions.WatchingInsertionContext currentContext = CodeCompletionHandlerBase.insertItem(items, item, completionChar, update2, targetEditor, targetFile, targetCaretOffset, idEnd, targetOffsets.getOffsets());
                lastContext.set(currentContext);
            });
            context2 = (CompletionAssertions.WatchingInsertionContext)lastContext.get();
        } else {
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor2, project2);
            context2 = CodeCompletionHandlerBase.insertItem(items, item, completionChar, update2, editor2, psiFile, caretOffset, idEndOffset, offsetMap);
        }
        return context2;
    }

    private static OffsetsInFile findInjectedOffsetsIfAny(@NotNull Caret caret, boolean wasInjected, @NotNull OffsetsInFile topLevelOffsets, @NotNull Editor hostEditor) {
        if (caret == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(21);
        }
        if (topLevelOffsets == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(22);
        }
        if (hostEditor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(23);
        }
        if (!wasInjected) {
            return topLevelOffsets;
        }
        PsiDocumentManager.getInstance(topLevelOffsets.getFile().getProject()).commitDocument(hostEditor.getDocument());
        return topLevelOffsets.toInjectedIfAny(caret.getOffset());
    }

    private static void checkPsiTextConsistency(CompletionProcessEx indicator) {
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(InjectedLanguageEditorUtil.getTopLevelEditor(indicator.getEditor()), indicator.getProject());
        if (psiFile != null && (Registry.is("ide.check.stub.text.consistency") || ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest())) {
            StubTextInconsistencyException.checkStubTextConsistency(psiFile);
            if (PsiDocumentManager.getInstance(psiFile.getProject()).hasUncommitedDocuments()) {
                PsiDocumentManager.getInstance(psiFile.getProject()).commitAllDocuments();
                StubTextInconsistencyException.checkStubTextConsistency(psiFile);
            }
        }
    }

    public void afterItemInsertion(CompletionProgressIndicator indicator, Runnable laterRunnable) {
        if (laterRunnable != null) {
            ActionTracker tracker = new ActionTracker(indicator.getEditor(), indicator);
            Runnable wrapper2 = () -> {
                if (!(Disposer.isDisposed(indicator) || indicator.getProject().isDisposed() || tracker.hasAnythingHappened())) {
                    laterRunnable.run();
                }
                indicator.disposeIndicator();
            };
            if (this.isTestingMode()) {
                wrapper2.run();
            } else {
                ApplicationManager.getApplication().invokeLater(wrapper2);
            }
        } else {
            indicator.disposeIndicator();
        }
    }

    private static CompletionAssertions.WatchingInsertionContext insertItem(List<LookupElement> lookupItems, LookupElement item, char completionChar, StatisticsUpdate update2, Editor editor2, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        editor2.getCaretModel().moveToOffset(caretOffset);
        CompletionAssertions.WatchingInsertionContext context2 = CompletionUtil.createInsertionContext(lookupItems, item, completionChar, editor2, psiFile, caretOffset, idEndOffset, offsetMap);
        int initialStartOffset = Math.max(0, caretOffset - item.getLookupString().length());
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                Document document;
                if (caretOffset < idEndOffset && completionChar == '\t' && (document = editor2.getDocument()).getRangeGuard(caretOffset, idEndOffset) == null) {
                    document.deleteString(caretOffset, idEndOffset);
                }
                assert (context2.getStartOffset() >= 0) : "stale startOffset: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + psiFile;
                assert (context2.getTailOffset() >= 0) : "stale tail: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + psiFile;
                Project project2 = psiFile.getProject();
                if (item.requiresCommittedDocuments()) {
                    PsiDocumentManager.getInstance(project2).commitAllDocuments();
                }
                DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> item.handleInsert(context2));
                PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
            }
            finally {
                context2.stopWatching();
            }
            EditorModificationUtil.scrollToCaret((Editor)editor2);
        });
        return context2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompletionAssertions.WatchingInsertionContext callHandleInsert(CompletionProgressIndicator indicator, LookupElement item, char completionChar) {
        Editor editor2 = indicator.getEditor();
        int caretOffset = indicator.getCaret().getOffset();
        int idEndOffset = CompletionUtil.calcIdEndOffset(indicator.getOffsetMap(), editor2, indicator.getCaret().getOffset());
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor2, indicator.getProject());
        CompletionAssertions.WatchingInsertionContext context2 = CompletionUtil.createInsertionContext(indicator.getLookup().getItems(), item, completionChar, editor2, psiFile, caretOffset, idEndOffset, indicator.getOffsetMap());
        try {
            item.handleInsert(context2);
        }
        finally {
            context2.stopWatching();
        }
        return context2;
    }

    public static void addCompletionChar(InsertionContext context2, LookupElement item) {
        if (!context2.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            @NonNls String message2 = "tailOffset<0 after inserting " + item + " of " + item.getClass();
            if (context2 instanceof CompletionAssertions.WatchingInsertionContext) {
                message2 = message2 + "; invalidated at: " + ((CompletionAssertions.WatchingInsertionContext)context2).invalidateTrace + "\n--------";
            }
            LOG.info(message2);
        } else if (!CompletionAssertions.isEditorValid(context2.getEditor())) {
            LOG.info("Injected editor invalidated " + context2.getEditor());
        } else {
            context2.getEditor().getCaretModel().moveToOffset(context2.getTailOffset());
        }
        if (context2.getCompletionChar() == '\r') {
            Language language = PsiUtilBase.getLanguageInEditor(context2.getEditor(), context2.getFile().getProject());
            if (language != null) {
                SmartEnterProcessor processor;
                Iterator iterator = SmartEnterProcessors.INSTANCE.allForLanguage(language).iterator();
                while (iterator.hasNext() && !(processor = (SmartEnterProcessor)iterator.next()).processAfterCompletion(context2.getEditor(), context2.getFile())) {
                }
            }
        } else {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)context2.getEditor().getContentComponent());
            EditorActionManager.getInstance();
            TypedAction.getInstance().getHandler().execute(context2.getEditor(), context2.getCompletionChar(), dataContext);
        }
    }

    private static boolean isAutocompleteOnInvocation(CompletionType type) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (type == CompletionType.SMART) {
            return settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION;
        }
        return settings.AUTOCOMPLETE_ON_CODE_COMPLETION;
    }

    private static Runnable rememberDocumentState(Editor _editor) {
        Editor editor2 = InjectedLanguageEditorUtil.getTopLevelEditor(_editor);
        String documentText = editor2.getDocument().getText();
        int caret = editor2.getCaretModel().getOffset();
        int selStart = editor2.getSelectionModel().getSelectionStart();
        int selEnd = editor2.getSelectionModel().getSelectionEnd();
        int vOffset = editor2.getScrollingModel().getVerticalScrollOffset();
        int hOffset = editor2.getScrollingModel().getHorizontalScrollOffset();
        return () -> {
            DocumentEx document = (DocumentEx)editor2.getDocument();
            document.replaceString(0, document.getTextLength(), documentText);
            editor2.getCaretModel().moveToOffset(caret);
            editor2.getSelectionModel().setSelection(selStart, selEnd);
            editor2.getScrollingModel().scrollHorizontally(hOffset);
            editor2.getScrollingModel().scrollVertically(vOffset);
        };
    }

    private static void clearCaretMarkers(@NotNull Editor editor2) {
        if (editor2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(24);
        }
        for (Caret caret : editor2.getCaretModel().getAllCarets()) {
            caret.putUserData(CARET_PROCESSED, null);
        }
    }

    private static void markCaretAsProcessed(@NotNull Caret caret) {
        if (caret == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(25);
        }
        caret.putUserData(CARET_PROCESSED, (Object)Boolean.TRUE);
    }

    private static Caret getNextCaretToProcess(@NotNull Editor editor2) {
        if (editor2 == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(26);
        }
        for (Caret caret : editor2.getCaretModel().getAllCarets()) {
            if (caret.getUserData(CARET_PROCESSED) != null) continue;
            return caret;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private <T> T withTimeout(long maxDurationMillis, @NotNull Computable<T> computable) {
        void task2;
        if (computable == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(27);
        }
        if (this.isTestingMode()) {
            return task2.compute();
        }
        return (T)ProgressIndicatorUtils.withTimeout((long)maxDurationMillis, (Computable)task2);
    }

    private static int calcSyncTimeOut(long startTime) {
        return (int)Math.max(300L, (long)ourAutoInsertItemTimeout - (System.currentTimeMillis() - startTime));
    }

    @TestOnly
    public static void setAutoInsertTimeout(int timeout) {
        ourAutoInsertItemTimeout = timeout;
    }

    protected boolean isTestingCompletionQualityMode() {
        return false;
    }

    protected boolean isTestingMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || this.isTestingCompletionQualityMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CodeCompletionHandlerBase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelOffsets";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CodeCompletionHandlerBase";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainLookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleCompletionElementSelected";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeCompletion";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldAutoComplete";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lookupItemSelected";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doInsertItem";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedOffsetsIfAny";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clearCaretMarkers";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "markCaretAsProcessed";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNextCaretToProcess";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "withTimeout";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

