/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class ActionTracker {
    @NotNull
    private final MessageBusConnection myConnection;
    @NotNull
    private List<Integer> myCaretOffsets;
    private long myStartDocStamp;
    private boolean myActionsHappened;
    private final Editor myEditor;
    private final Project myProject;
    private final boolean myIsDumb;

    ActionTracker(@NotNull Editor editor2, @NotNull Disposable parentDisposable) {
        if (editor2 == null) {
            ActionTracker.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ActionTracker.$$$reportNull$$$0(1);
        }
        this.myEditor = editor2;
        this.myProject = Objects.requireNonNull(editor2.getProject());
        this.myIsDumb = DumbService.getInstance(this.myProject).isDumb();
        this.myConnection = this.myProject.getMessageBus().connect(parentDisposable);
        this.myConnection.subscribe(AnActionListener.TOPIC, new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ActionTracker.this.myActionsHappened = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/ActionTracker$1";
                objectArray[2] = "beforeActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myStartDocStamp = this.docStamp();
        this.myCaretOffsets = this.caretOffsets();
    }

    private List<Integer> caretOffsets() {
        return ContainerUtil.map(this.myEditor.getCaretModel().getAllCarets(), Caret::getOffset);
    }

    private long docStamp() {
        return this.myEditor.getDocument().getModificationStamp();
    }

    void ignoreCurrentDocumentChange() {
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            return;
        }
        this.myConnection.subscribe(CommandListener.TOPIC, new CommandListener(){
            boolean insideCommand = true;

            @Override
            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.insideCommand) {
                    this.insideCommand = false;
                    ActionTracker.this.myStartDocStamp = ActionTracker.this.docStamp();
                    ActionTracker.this.myCaretOffsets = ActionTracker.this.caretOffsets();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/completion/ActionTracker$2", "commandFinished"));
            }
        });
    }

    boolean hasAnythingHappened() {
        boolean hasDocumentOrCaretChanged = this.myStartDocStamp != this.docStamp() || !this.myCaretOffsets.equals(this.caretOffsets());
        return this.myActionsHappened || this.myIsDumb != DumbService.getInstance(this.myProject).isDumb() || this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid() || hasDocumentOrCaretChanged && !ClientIdKt.isOnGuest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/ActionTracker";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

