/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.renderers.painters;

import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionScaledIconPainter;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionTheme;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.ICodeVisionEntryBasePainter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BA\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJE\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010!J%\u0010\"\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/DefaultCodeVisionPainter;", "T", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionEntryBasePainter;", "iconProvider", "Lkotlin/Function3;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;", "Ljavax/swing/Icon;", "textPainter", "theme", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "(Lkotlin/jvm/functions/Function3;Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionEntryBasePainter;Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;)V", "iconPainter", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionScaledIconPainter;", "getTheme", "()Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "g", "Ljava/awt/Graphics;", "value", "point", "Ljava/awt/Point;", "state", "hovered", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/TextAttributes;Ljava/awt/Graphics;Ljava/lang/Object;Ljava/awt/Point;Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;Z)V", "pureSize", "Ljava/awt/Dimension;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;Ljava/lang/Object;)Ljava/awt/Dimension;", "size", "intellij.platform.lang.impl"})
public class DefaultCodeVisionPainter<T>
implements ICodeVisionEntryBasePainter<T> {
    @NotNull
    private final CodeVisionTheme theme;
    private final CodeVisionScaledIconPainter iconPainter;
    private final Function3<Project, T, RangeCodeVisionModel.InlayState, Icon> iconProvider;
    private final ICodeVisionEntryBasePainter<T> textPainter;

    @NotNull
    public final CodeVisionTheme getTheme() {
        return this.theme;
    }

    @Override
    public void paint(@NotNull Editor editor2, @NotNull TextAttributes textAttributes, @NotNull Graphics g, T value, @NotNull Point point, @NotNull RangeCodeVisionModel.InlayState state, boolean hovered2) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Dimension pureSize = this.pureSize(editor2, state, value);
        int x = point.x + this.theme.getLeft();
        int y = point.y + this.theme.getTop();
        Project project2 = editor2.getProject();
        if (project2 != null && (icon2 = (Icon)this.iconProvider.invoke((Object)project2, value, (Object)state)) != null) {
            float scaleFactor = this.iconPainter.scaleFactor(icon2.getIconHeight(), pureSize.height);
            this.iconPainter.paint(editor2, g, icon2, new Point(x, y), scaleFactor);
            x += this.iconPainter.width(icon2, scaleFactor) + this.theme.getIconGap();
        }
        this.textPainter.paint(editor2, textAttributes, g, value, new Point(x, y), state, hovered2);
    }

    private final Dimension pureSize(Editor editor2, RangeCodeVisionModel.InlayState state, T value) {
        int n;
        Dimension size = this.textPainter.size(editor2, state, value);
        Project project2 = editor2.getProject();
        if (project2 != null) {
            Icon icon2 = (Icon)this.iconProvider.invoke((Object)project2, value, (Object)state);
            if (icon2 != null) {
                float scaleFactor = this.iconPainter.scaleFactor(icon2.getIconHeight(), size.height);
                n = this.theme.getIconGap() + this.iconPainter.width(icon2, scaleFactor);
            } else {
                n = 0;
            }
        } else {
            n = 0;
        }
        int width = n;
        return new Dimension(size.width + width, size.height);
    }

    @Override
    @NotNull
    public Dimension size(@NotNull Editor editor2, @NotNull RangeCodeVisionModel.InlayState state, T value) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Dimension size = this.pureSize(editor2, state, value);
        FontMetrics editorMetrics = editor2.getComponent().getFontMetrics(CodeVisionTheme.Companion.editorFont$default(CodeVisionTheme.Companion, editor2, null, 2, null));
        int n = size.width + this.theme.getLeft() + this.theme.getRight();
        int n2 = size.height + this.theme.getTop() + this.theme.getBottom();
        FontMetrics fontMetrics = editorMetrics;
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"editorMetrics");
        return new Dimension(n, n2 + (fontMetrics.getHeight() - size.height));
    }

    public DefaultCodeVisionPainter(@NotNull Function3<? super Project, ? super T, ? super RangeCodeVisionModel.InlayState, ? extends Icon> iconProvider, @NotNull ICodeVisionEntryBasePainter<T> textPainter, @Nullable CodeVisionTheme theme) {
        Intrinsics.checkNotNullParameter(iconProvider, (String)"iconProvider");
        Intrinsics.checkNotNullParameter(textPainter, (String)"textPainter");
        this.iconProvider = iconProvider;
        this.textPainter = textPainter;
        CodeVisionTheme codeVisionTheme = theme;
        if (codeVisionTheme == null) {
            codeVisionTheme = new CodeVisionTheme(0, 0, 0, 0, 0, 31, null);
        }
        this.theme = codeVisionTheme;
        this.iconPainter = new CodeVisionScaledIconPainter(0.0, 0.0, 3, null);
    }

    public /* synthetic */ DefaultCodeVisionPainter(Function3 function3, ICodeVisionEntryBasePainter iCodeVisionEntryBasePainter, CodeVisionTheme codeVisionTheme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            codeVisionTheme = null;
        }
        this(function3, iCodeVisionEntryBasePainter, codeVisionTheme);
    }

    @Override
    @NotNull
    public Icon toIcon(@NotNull Editor editor2, @NotNull TextAttributes textAttributes, T value, @NotNull RangeCodeVisionModel.InlayState state, boolean hovered2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return ICodeVisionEntryBasePainter.DefaultImpls.toIcon(this, editor2, textAttributes, value, state, hovered2);
    }
}

