/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.model.richText;

import com.intellij.codeInsight.codeVision.ui.model.richText.RichString;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0000H\u0016J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0004H\u0017J\u0018\u0010#\u001a\u00020\u0018*\u00060$j\u0002`%2\u0006\u0010&\u001a\u00020!H\u0002J\u0018\u0010'\u001a\u00020\u0018*\u00060$j\u0002`%2\u0006\u0010(\u001a\u00020\u001dH\u0002R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\b0\u000fj\b\u0012\u0004\u0012\u00020\b`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "", "()V", "text", "", "(Ljava/lang/String;)V", "parts", "", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichString;", "(Ljava/lang/String;Ljava/util/Collection;)V", "length", "", "getLength", "()I", "myParts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myString", "", "getParts", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "addStyle", "", "style", "textRange", "Lcom/intellij/openapi/util/TextRange;", "append", "Lcom/intellij/ui/SimpleTextAttributes;", "clone", "setForeColor", "fgColor", "Ljava/awt/Color;", "toString", "dumpColor", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bgColor", "dumpStyleAndFont", "a", "intellij.platform.lang.impl"})
public class RichText
implements Cloneable {
    private String myString;
    private ArrayList<RichString> myParts;

    @NotNull
    public final List<RichString> getParts() {
        return this.myParts;
    }

    @NotNull
    public final String getText() {
        return this.myString;
    }

    public final int getLength() {
        return this.getText().length();
    }

    public final void append(@NotNull String text2, @NotNull SimpleTextAttributes style) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        TextRange range = new TextRange(this.myString.length(), this.myString.length() + text2.length());
        this.myString = this.myString + text2;
        this.myParts.add(new RichString(range, style, this));
    }

    public final void setForeColor(@NotNull Color fgColor) {
        Intrinsics.checkNotNullParameter((Object)fgColor, (String)"fgColor");
        for (RichString part : this.getParts()) {
            SimpleTextAttributes attributes = part.getAttributes();
            int style = attributes.getStyle();
            Color bgColor = attributes.getBgColor();
            Color waveColor = attributes.getWaveColor();
            SimpleTextAttributes simpleTextAttributes = attributes.derive(style, fgColor, bgColor, waveColor);
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"attributes.derive(style,\u2026olor, bgColor, waveColor)");
            part.setAttributes(simpleTextAttributes);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addStyle(@SimpleTextAttributes.StyleAttributeConstant int style, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        int n = textRange.getStartOffset();
        if (0 > n || this.getLength() <= n) {
            throw (Throwable)new IllegalArgumentException("textRange");
        }
        n = textRange.getEndOffset();
        if (0 > n || this.getLength() < n) {
            throw (Throwable)new IllegalArgumentException("textRange");
        }
        ArrayList<RichString> newParts = new ArrayList<RichString>();
        Iterator<RichString> iterator = this.myParts.iterator();
        while (iterator.hasNext()) {
            SimpleTextAttributes newAttributes;
            void partRange;
            RichString part;
            RichString richString = part = iterator.next();
            TextRange textRange2 = richString.component1();
            SimpleTextAttributes attributes = richString.component2();
            TextRange intersection = textRange.intersection((TextRange)partRange);
            if (intersection == null) {
                newParts.add(part);
                continue;
            }
            if (partRange.getStartOffset() != intersection.getStartOffset()) {
                newParts.add(new RichString(new TextRange(partRange.getStartOffset(), intersection.getStartOffset()), attributes, this));
            }
            SimpleTextAttributes simpleTextAttributes = newAttributes = attributes.derive(attributes.getStyle() | style, null, null, null);
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"newAttributes");
            newParts.add(new RichString(intersection, simpleTextAttributes, this));
            if (intersection.getEndOffset() == partRange.getEndOffset()) continue;
            newParts.add(new RichString(new TextRange(intersection.getEndOffset(), partRange.getEndOffset()), attributes, this));
        }
        this.myParts = newParts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RichText clone() {
        RichText copy = new RichText();
        copy.myString = this.myString;
        for (RichString richString : this.myParts) {
            void textRange;
            TextRange textRange2 = richString.component1();
            SimpleTextAttributes attributes = richString.component2();
            copy.myParts.add(new RichString((TextRange)textRange, attributes, copy));
        }
        return copy;
    }

    @Nls
    @NotNull
    public String toString() {
        StringBuilder acc = new StringBuilder();
        for (RichString p : this.myParts) {
            Color waveColor;
            Color fgColor;
            Object object = p;
            TextRange textRange = ((RichString)object).component1();
            SimpleTextAttributes a = ((RichString)object).component2();
            Object $this$apply = object = acc;
            boolean bl = false;
            ((StringBuilder)$this$apply).append("<span styles=\"");
            Color bgColor = a.getBgColor();
            if (bgColor != null) {
                ((StringBuilder)$this$apply).append("background-color:");
                this.dumpColor((StringBuilder)$this$apply, bgColor);
            }
            if ((fgColor = a.getFgColor()) != null) {
                ((StringBuilder)$this$apply).append("color:");
                this.dumpColor((StringBuilder)$this$apply, fgColor);
            }
            if ((waveColor = a.getWaveColor()) != null) {
                ((StringBuilder)$this$apply).append("wave-color:");
                Color color = fgColor;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"fgColor");
                this.dumpColor((StringBuilder)$this$apply, color);
            }
            this.dumpStyleAndFont((StringBuilder)$this$apply, a);
            ((StringBuilder)$this$apply).append("");
            ((StringBuilder)$this$apply).append("\">");
            ((StringBuilder)$this$apply).append(p.getText());
            ((StringBuilder)$this$apply).append("</span>");
        }
        String string2 = acc.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"acc.toString()");
        return string2;
    }

    private final void dumpStyleAndFont(StringBuilder $this$dumpStyleAndFont, SimpleTextAttributes a) {
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    switch (a.getFontStyle()) {
                                        case 0: {
                                            $this$dumpStyleAndFont.append("font-style: plain;");
                                            break;
                                        }
                                        case 2: {
                                            $this$dumpStyleAndFont.append("font-style: italic;");
                                            break;
                                        }
                                        case 1: {
                                            $this$dumpStyleAndFont.append("font-weight: bold;");
                                            break;
                                        }
                                    }
                                    if (!a.isSearchMatch()) break block5;
                                    $this$dumpStyleAndFont.append("text-decoration: searchMatch;");
                                    break block6;
                                }
                                if (!a.isStrikeout()) break block7;
                                $this$dumpStyleAndFont.append("text-decoration: strikeout;");
                                break block6;
                            }
                            if (!a.isWaved()) break block8;
                            $this$dumpStyleAndFont.append("text-decoration: waved;");
                            break block6;
                        }
                        if (!a.isUnderline()) break block9;
                        $this$dumpStyleAndFont.append("text-decoration: underline;");
                        break block6;
                    }
                    if (!a.isBoldDottedLine()) break block10;
                    $this$dumpStyleAndFont.append("text-decoration: boldDottedLine;");
                    break block6;
                }
                if (!a.isOpaque()) break block11;
                $this$dumpStyleAndFont.append("text-decoration: opaque;");
                break block6;
            }
            if (!a.isSmaller()) break block6;
            $this$dumpStyleAndFont.append("text-decoration: smaller;");
        }
    }

    private final void dumpColor(StringBuilder $this$dumpColor, Color bgColor) {
        $this$dumpColor.append("rgb(");
        $this$dumpColor.append(bgColor.getRed());
        $this$dumpColor.append(",");
        $this$dumpColor.append(bgColor.getGreen());
        $this$dumpColor.append(",");
        $this$dumpColor.append(bgColor.getBlue());
        $this$dumpColor.append(");");
    }

    public RichText(@NotNull String text2, @NotNull Collection<RichString> parts) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        this.myString = text2;
        this.myParts = new ArrayList<RichString>(parts);
    }

    public RichText() {
        this("", CollectionsKt.emptyList());
    }

    public RichText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
        this.append(text2, simpleTextAttributes);
    }
}

