/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.model;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.util.Disposer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0002R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionVisualVerticalPositionKeeper;", "", "editors", "", "Lcom/intellij/openapi/editor/Editor;", "([Lcom/intellij/openapi/editor/Editor;)V", "map", "Ljava/util/HashMap;", "Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionVisualVerticalPositionKeeper$RangeMarkerWithOffset;", "Lkotlin/collections/HashMap;", "keep", "editor", "restoreOriginalLocation", "", "pair", "RangeMarkerWithOffset", "intellij.platform.lang.impl"})
public final class CodeVisionVisualVerticalPositionKeeper {
    private final HashMap<Editor, RangeMarkerWithOffset> map;

    private final RangeMarkerWithOffset keep(Editor editor2) {
        int n;
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"editor.scrollingModel");
        Rectangle rectangle = scrollingModel.getVisibleAreaOnScrollingFinished();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"editor.scrollingModel.vi\u2026leAreaOnScrollingFinished");
        Rectangle visibleArea = rectangle;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Point point = editor2.visualPositionToXY(caretModel.getVisualPosition());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"editor.visualPositionToX\u2026aretModel.visualPosition)");
        Point cursorPosition = point;
        if (visibleArea.height > 0 && (cursorPosition.y < visibleArea.y || cursorPosition.y > visibleArea.y + visibleArea.height)) {
            Point pos = new Point(visibleArea.x + visibleArea.width / 2, visibleArea.y + visibleArea.height / 2);
            n = editor2.logicalPositionToOffset(editor2.xyToLogicalPosition(pos));
        } else {
            CaretModel caretModel2 = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"editor.caretModel");
            n = caretModel2.getOffset();
        }
        int offset = n;
        RangeMarker rangeMarker = editor2.getDocument().createRangeMarker(offset, offset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"editor.document.createRangeMarker(offset, offset)");
        RangeMarker rangeMarker2 = rangeMarker;
        Point point2 = editor2.offsetToXY(offset);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"editor.offsetToXY(offset)");
        Point offsetToXY = point2;
        int shift = offsetToXY.y - visibleArea.y;
        return new RangeMarkerWithOffset(rangeMarker2, shift);
    }

    /*
     * WARNING - void declaration
     */
    public final void restoreOriginalLocation() {
        Map $this$forEach$iv = this.map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void editor2;
            Map.Entry element$iv;
            Map.Entry $dstr$editor$value = element$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = $dstr$editor$value;
            Editor editor3 = (Editor)entry.getKey();
            entry = $dstr$editor$value;
            RangeMarkerWithOffset value = (RangeMarkerWithOffset)entry.getValue();
            this.restoreOriginalLocation((Editor)editor2, value);
        }
        this.map.clear();
    }

    private final void restoreOriginalLocation(Editor editor2, RangeMarkerWithOffset pair) {
        Point point = editor2.offsetToXY(pair.getRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"editor.offsetToXY(pair.range.startOffset)");
        Point newLocation = point;
        editor2.getScrollingModel().disableAnimation();
        editor2.getScrollingModel().scrollVertically(newLocation.y - pair.getShift());
        editor2.getScrollingModel().enableAnimation();
        pair.dispose();
    }

    public CodeVisionVisualVerticalPositionKeeper(Editor ... editors2) {
        Intrinsics.checkNotNullParameter((Object)editors2, (String)"editors");
        this.map = new HashMap();
        for (Editor editor2 : editors2) {
            ((Map)this.map).put(editor2, this.keep(editor2));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionVisualVerticalPositionKeeper$RangeMarkerWithOffset;", "Lcom/intellij/openapi/Disposable;", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "shift", "", "(Lcom/intellij/openapi/editor/RangeMarker;I)V", "getRange", "()Lcom/intellij/openapi/editor/RangeMarker;", "getShift", "()I", "dispose", "", "intellij.platform.lang.impl"})
    public static final class RangeMarkerWithOffset
    implements Disposable {
        @NotNull
        private final RangeMarker range;
        private final int shift;

        @Override
        public void dispose() {
            Disposer.dispose(new Disposable(this){
                final /* synthetic */ RangeMarkerWithOffset this$0;

                public final void dispose() {
                    this.this$0.getRange();
                }
                {
                    this.this$0 = rangeMarkerWithOffset;
                }
            });
        }

        @NotNull
        public final RangeMarker getRange() {
            return this.range;
        }

        public final int getShift() {
            return this.shift;
        }

        public RangeMarkerWithOffset(@NotNull RangeMarker range, int shift) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = range;
            this.shift = shift;
        }
    }
}

