/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions.onSave;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.CodeCleanupCodeProcessor;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInsight.actions.onSave.CodeCleanupOnSaveActionInfo;
import com.intellij.codeInsight.actions.onSave.FormatOnSaveOptions;
import com.intellij.codeInsight.actions.onSave.OptimizeImportsOnSaveOptions;
import com.intellij.codeInsight.actions.onSave.RearrangeCodeOnSaveActionInfo;
import com.intellij.ide.actionsOnSave.impl.ActionsOnSaveFileDocumentManagerListener;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;

public class FormatOnSaveAction
extends ActionsOnSaveFileDocumentManagerListener.ActionOnSave {
    public boolean isEnabledForProject(@NotNull Project project2) {
        if (project2 == null) {
            FormatOnSaveAction.$$$reportNull$$$0(0);
        }
        return FormatOnSaveOptions.getInstance(project2).isRunOnSaveEnabled() || OptimizeImportsOnSaveOptions.getInstance(project2).isRunOnSaveEnabled() || RearrangeCodeOnSaveActionInfo.isRearrangeCodeOnSaveEnabled(project2) || CodeCleanupOnSaveActionInfo.isCodeCleanupOnSaveEnabled(project2);
    }

    public void processDocuments(@NotNull Project project2, @NotNull @NotNull Document @NotNull [] documents) {
        if (project2 == null) {
            FormatOnSaveAction.$$$reportNull$$$0(1);
        }
        if (documents == null) {
            FormatOnSaveAction.$$$reportNull$$$0(2);
        }
        ArrayList<PsiFile> allFiles = new ArrayList<PsiFile>();
        ArrayList<PsiFile> filesToFormat = new ArrayList<PsiFile>();
        ArrayList<PsiFile> filesToOptimizeImports = new ArrayList<PsiFile>();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(project2);
        FormatOnSaveOptions formatOptions = FormatOnSaveOptions.getInstance(project2);
        OptimizeImportsOnSaveOptions optimizeImportsOptions = OptimizeImportsOnSaveOptions.getInstance(project2);
        for (Document document : documents) {
            PsiFile psiFile = manager.getPsiFile(document);
            if (psiFile == null || !LanguageFormatting.INSTANCE.isAutoFormatAllowed((PsiElement)psiFile)) continue;
            allFiles.add(psiFile);
            if (formatOptions.isRunOnSaveEnabled() && (formatOptions.isAllFileTypesSelected() || formatOptions.isFileTypeSelected(psiFile.getFileType()))) {
                filesToFormat.add(psiFile);
            }
            if (!optimizeImportsOptions.isRunOnSaveEnabled() || !optimizeImportsOptions.isAllFileTypesSelected() && !optimizeImportsOptions.isFileTypeSelected(psiFile.getFileType())) continue;
            filesToOptimizeImports.add(psiFile);
        }
        if (filesToFormat.isEmpty() && filesToOptimizeImports.isEmpty() && !RearrangeCodeOnSaveActionInfo.isRearrangeCodeOnSaveEnabled(project2) && !CodeCleanupOnSaveActionInfo.isCodeCleanupOnSaveEnabled(project2)) {
            return;
        }
        this.procesFiles(project2, allFiles, filesToFormat, filesToOptimizeImports);
    }

    private void procesFiles(@NotNull Project project2, @NotNull List<PsiFile> allFiles, final @NotNull List<PsiFile> filesToFormat, final @NotNull List<PsiFile> filesToOptimizeImports) {
        if (project2 == null) {
            FormatOnSaveAction.$$$reportNull$$$0(3);
        }
        if (allFiles == null) {
            FormatOnSaveAction.$$$reportNull$$$0(4);
        }
        if (filesToFormat == null) {
            FormatOnSaveAction.$$$reportNull$$$0(5);
        }
        if (filesToOptimizeImports == null) {
            FormatOnSaveAction.$$$reportNull$$$0(6);
        }
        boolean onlyChangedLines = VcsFacade.getInstance().hasActiveVcss(project2) && FormatOnSaveOptions.getInstance(project2).isFormatOnlyChangedLines();
        AbstractLayoutCodeProcessor processor = new ReformatCodeProcessor(project2, allFiles.toArray(PsiFile.EMPTY_ARRAY), null, onlyChangedLines){

            @Override
            @NotNull
            protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                FutureTask<Boolean> futureTask = filesToFormat.contains(file2) ? super.prepareTask(file2, processChangedTextOnly) : 1.emptyTask();
                if (futureTask == null) {
                    1.$$$reportNull$$$0(1);
                }
                return futureTask;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveAction$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepareTask";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepareTask";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (OptimizeImportsOnSaveOptions.getInstance(project2).isRunOnSaveEnabled()) {
            processor = new OptimizeImportsProcessor(processor){

                @Override
                @NotNull
                protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
                    if (file2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    FutureTask<Boolean> futureTask = filesToOptimizeImports.contains(file2) ? super.prepareTask(file2, processChangedTextOnly) : 2.emptyTask();
                    if (futureTask == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return futureTask;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveAction$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveAction$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "prepareTask";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "prepareTask";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        if (RearrangeCodeOnSaveActionInfo.isRearrangeCodeOnSaveEnabled(project2)) {
            processor = new RearrangeCodeProcessor(processor);
        }
        if (CodeCleanupOnSaveActionInfo.isCodeCleanupOnSaveEnabled(project2) && !DumbService.isDumb(project2)) {
            processor = new CodeCleanupCodeProcessor(processor);
        }
        processor.setProcessAllFilesAsSingleUndoStep(false);
        processor.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToFormat";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToOptimizeImports";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processDocuments";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "procesFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

