/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.formatting.service.FormattingService;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsProcessor
extends AbstractLayoutCodeProcessor {
    private final List<NotificationInfo> myOptimizerNotifications;

    public OptimizeImportsProcessor(@NotNull Project project2) {
        if (project2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(0);
        }
        super(project2, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText(), false);
        this.myOptimizerNotifications = new SmartList<NotificationInfo>();
    }

    public OptimizeImportsProcessor(@NotNull Project project2, @NotNull Module module) {
        if (project2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(1);
        }
        if (module == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(2);
        }
        super(project2, module, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText(), false);
        this.myOptimizerNotifications = new SmartList<NotificationInfo>();
    }

    public OptimizeImportsProcessor(@NotNull Project project2, @NotNull PsiDirectory directory, boolean includeSubdirs, boolean processOnlyVcsChangedFiles) {
        if (project2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(4);
        }
        super(project2, directory, includeSubdirs, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), processOnlyVcsChangedFiles);
        this.myOptimizerNotifications = new SmartList<NotificationInfo>();
    }

    public OptimizeImportsProcessor(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(6);
        }
        super(project2, file2, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), false);
        this.myOptimizerNotifications = new SmartList<NotificationInfo>();
    }

    public OptimizeImportsProcessor(@NotNull Project project2, PsiFile @NotNull [] files2, @Nullable Runnable postRunnable) {
        if (project2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(7);
        }
        if (files2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(8);
        }
        this(project2, files2, OptimizeImportsProcessor.getCommandName(), postRunnable);
    }

    public OptimizeImportsProcessor(@NotNull Project project2, PsiFile @NotNull [] files2, @NotNull @NlsContexts.Command String commandName2, @Nullable Runnable postRunnable) {
        if (project2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(9);
        }
        if (commandName2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(10);
        }
        if (files2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(11);
        }
        super(project2, files2, OptimizeImportsProcessor.getProgressText(), commandName2, postRunnable, false);
        this.myOptimizerNotifications = new SmartList<NotificationInfo>();
    }

    public OptimizeImportsProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        if (previousProcessor == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(12);
        }
        super(previousProcessor, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText());
        this.myOptimizerNotifications = new SmartList<NotificationInfo>();
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb(file2.getProject())) {
            FutureTask<Boolean> futureTask = OptimizeImportsProcessor.emptyTask();
            if (futureTask == null) {
                OptimizeImportsProcessor.$$$reportNull$$$0(14);
            }
            return futureTask;
        }
        List<Runnable> runnables = OptimizeImportsProcessor.collectOptimizers(file2);
        if (runnables.isEmpty()) {
            FutureTask<Boolean> futureTask = OptimizeImportsProcessor.emptyTask();
            if (futureTask == null) {
                OptimizeImportsProcessor.$$$reportNull$$$0(15);
            }
            return futureTask;
        }
        List<Object> hints = ApplicationManager.getApplication().isDispatchThread() ? Collections.emptyList() : ShowAutoImportPass.getImportHints(file2);
        return new FutureTask<Boolean>(() -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            CoreCodeStyleUtil.setSequentialProcessingAllowed((boolean)false);
            try {
                for (Runnable runnable : runnables) {
                    runnable.run();
                    this.myOptimizerNotifications.add(OptimizeImportsProcessor.getNotificationInfo(runnable));
                }
                this.putNotificationInfoIntoCollector();
                ShowAutoImportPass.fixAllImportsSilently(file2, hints);
            }
            finally {
                CoreCodeStyleUtil.setSequentialProcessingAllowed((boolean)true);
            }
        }, true);
    }

    @NotNull
    static List<Runnable> collectOptimizers(@NotNull PsiFile file2) {
        if (file2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(16);
        }
        FormattingService service2 = FormattingServiceUtil.findImportsOptimizingService((PsiFile)file2);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        List<PsiFile> files2 = file2.getViewProvider().getAllFiles();
        for (ImportOptimizer optimizer : service2.getImportOptimizers(file2)) {
            for (PsiFile psiFile : files2) {
                if (!optimizer.supports(psiFile)) continue;
                runnables.add(optimizer.processFile(psiFile));
            }
        }
        ArrayList<Runnable> arrayList = runnables;
        if (arrayList == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static NotificationInfo getNotificationInfo(@NotNull Runnable runnable) {
        if (runnable == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(18);
        }
        if (runnable instanceof ImportOptimizer.CollectingInfoRunnable) {
            String optimizerMessage = ((ImportOptimizer.CollectingInfoRunnable)runnable).getUserNotificationInfo();
            return optimizerMessage == null ? NotificationInfo.NOTHING_CHANGED_NOTIFICATION : new NotificationInfo(optimizerMessage);
        }
        if (runnable == EmptyRunnable.getInstance()) {
            NotificationInfo notificationInfo = NotificationInfo.NOTHING_CHANGED_NOTIFICATION;
            if (notificationInfo == null) {
                OptimizeImportsProcessor.$$$reportNull$$$0(19);
            }
            return notificationInfo;
        }
        NotificationInfo notificationInfo = NotificationInfo.SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION;
        if (notificationInfo == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(20);
        }
        return notificationInfo;
    }

    private void putNotificationInfoIntoCollector() {
        LayoutCodeInfoCollector collector2 = this.getInfoCollector();
        if (collector2 == null) {
            return;
        }
        boolean atLeastOneOptimizerChangedSomething = false;
        for (NotificationInfo info : this.myOptimizerNotifications) {
            atLeastOneOptimizerChangedSomething |= info.isSomethingChanged();
            if (info.getMessage() == null) continue;
            collector2.setOptimizeImportsNotification(info.getMessage());
            return;
        }
        String hint = atLeastOneOptimizerChangedSomething ? CodeInsightBundle.message("hint.text.imports.optimized", new Object[0]) : null;
        collector2.setOptimizeImportsNotification(hint);
    }

    @NotNull
    @NlsContexts.ProgressText
    private static String getProgressText() {
        String string2 = CodeInsightBundle.message("progress.text.optimizing.imports", new Object[0]);
        if (string2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @NotNull
    @NlsContexts.Command
    public static String getCommandName() {
        String string2 = CodeInsightBundle.message("process.optimize.imports", new Object[0]);
        if (string2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(22);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousProcessor";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/OptimizeImportsProcessor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/OptimizeImportsProcessor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTask";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOptimizers";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareTask";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectOptimizers";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class NotificationInfo {
        static final NotificationInfo NOTHING_CHANGED_NOTIFICATION = new NotificationInfo(false, null);
        static final NotificationInfo SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION = new NotificationInfo(true, null);
        private final boolean mySomethingChanged;
        private final @NlsContexts.HintText String myMessage;

        NotificationInfo(@NotNull @NlsContexts.HintText String message2) {
            if (message2 == null) {
                NotificationInfo.$$$reportNull$$$0(0);
            }
            this(true, message2);
        }

        public boolean isSomethingChanged() {
            return this.mySomethingChanged;
        }

        @NlsContexts.HintText
        public String getMessage() {
            return this.myMessage;
        }

        private NotificationInfo(boolean isSomethingChanged, @Nullable @NlsContexts.HintText String message2) {
            this.mySomethingChanged = isSomethingChanged;
            this.myMessage = message2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/actions/OptimizeImportsProcessor$NotificationInfo", "<init>"));
        }
    }
}

