/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.ReformatCodeRunOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class LastRunReformatCodeOptionsProvider {
    private static final String OPTIMIZE_IMPORTS_KEY = "LayoutCode.optimizeImports";
    private static final String REARRANGE_ENTRIES_KEY = "LayoutCode.rearrangeEntries";
    private static final String CODE_CLEANUP_KEY = "LayoutCode.codeCleanup";
    private static final String PROCESS_CHANGED_TEXT_KEY = "LayoutCode.processChangedText";
    private static final String DO_NOT_KEEP_LINE_BREAKS_KEY = "LayoutCode.doNotKeepLineBreaks";
    private final PropertiesComponent myPropertiesComponent;

    public LastRunReformatCodeOptionsProvider(@NotNull PropertiesComponent propertiesComponent) {
        if (propertiesComponent == null) {
            LastRunReformatCodeOptionsProvider.$$$reportNull$$$0(0);
        }
        this.myPropertiesComponent = propertiesComponent;
    }

    public ReformatCodeRunOptions getLastRunOptions(@NotNull PsiFile file2) {
        if (file2 == null) {
            LastRunReformatCodeOptionsProvider.$$$reportNull$$$0(1);
        }
        Language language = file2.getLanguage();
        ReformatCodeRunOptions settings = new ReformatCodeRunOptions(this.getLastTextRangeType());
        settings.setOptimizeImports(this.getLastOptimizeImports());
        settings.setRearrangeCode(this.isRearrangeCode(language));
        return settings;
    }

    public void saveRearrangeState(@NotNull Language language, boolean value) {
        if (language == null) {
            LastRunReformatCodeOptionsProvider.$$$reportNull$$$0(2);
        }
        String key = LastRunReformatCodeOptionsProvider.getRearrangeCodeKeyFor(language);
        this.myPropertiesComponent.setValue(key, Boolean.toString(value));
    }

    public void saveOptimizeImportsState(boolean value) {
        String optimizeImports = Boolean.toString(value);
        this.myPropertiesComponent.setValue(OPTIMIZE_IMPORTS_KEY, optimizeImports);
    }

    public boolean getLastOptimizeImports() {
        return this.myPropertiesComponent.getBoolean(OPTIMIZE_IMPORTS_KEY);
    }

    public TextRangeType getLastTextRangeType() {
        return this.myPropertiesComponent.getBoolean(PROCESS_CHANGED_TEXT_KEY) ? TextRangeType.VCS_CHANGED_TEXT : TextRangeType.WHOLE_FILE;
    }

    public void saveProcessVcsChangedTextState(boolean value) {
        String processOnlyVcsChangedText = Boolean.toString(value);
        this.myPropertiesComponent.setValue(PROCESS_CHANGED_TEXT_KEY, processOnlyVcsChangedText);
    }

    public void saveRearrangeCodeState(boolean value) {
        this.myPropertiesComponent.setValue(REARRANGE_ENTRIES_KEY, value);
    }

    public boolean getLastRearrangeCode() {
        return this.myPropertiesComponent.getBoolean(REARRANGE_ENTRIES_KEY);
    }

    public void saveCodeCleanupState(boolean value) {
        this.myPropertiesComponent.setValue(CODE_CLEANUP_KEY, value);
    }

    public boolean getLastCodeCleanup() {
        return this.myPropertiesComponent.getBoolean(CODE_CLEANUP_KEY);
    }

    public boolean isRearrangeCode(@NotNull Language language) {
        if (language == null) {
            LastRunReformatCodeOptionsProvider.$$$reportNull$$$0(3);
        }
        String key = LastRunReformatCodeOptionsProvider.getRearrangeCodeKeyFor(language);
        return this.myPropertiesComponent.getBoolean(key);
    }

    public boolean isDoNotKeepLineBreaks() {
        return this.myPropertiesComponent.getBoolean(DO_NOT_KEEP_LINE_BREAKS_KEY);
    }

    public void setDoNotKeepLineBreaks(boolean value) {
        this.myPropertiesComponent.setValue(DO_NOT_KEEP_LINE_BREAKS_KEY, value);
    }

    private static String getRearrangeCodeKeyFor(@NotNull Language language) {
        if (language == null) {
            LastRunReformatCodeOptionsProvider.$$$reportNull$$$0(4);
        }
        return REARRANGE_ENTRIES_KEY + language.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/LastRunReformatCodeOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastRunOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "saveRearrangeState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRearrangeCode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRearrangeCodeKeyFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

