/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.CodeCleanupCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileInEditorProcessor {
    private static final Logger LOG = Logger.getInstance(FileInEditorProcessor.class);
    private final Editor myEditor;
    private boolean myNoChangesDetected;
    private final boolean myProcessChangesTextOnly;
    private final boolean myProcessSelectedText;
    private final LayoutCodeOptions myOptions;
    private final Project myProject;
    private final PsiFile myFile;
    private AbstractLayoutCodeProcessor myProcessor;

    public FileInEditorProcessor(PsiFile file2, Editor editor2, LayoutCodeOptions runOptions) {
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myEditor = editor2;
        this.myOptions = runOptions;
        this.myProcessSelectedText = this.myEditor != null && runOptions.getTextRangeType() == TextRangeType.SELECTED_TEXT;
        this.myProcessChangesTextOnly = runOptions.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
    }

    public void processCode() {
        if (!CodeStyle.isFormattingEnabled((PsiFile)this.myFile)) {
            if (!FileInEditorProcessor.isInHeadlessMode() && !this.myEditor.isDisposed() && this.myEditor.getComponent().isShowing()) {
                FileInEditorProcessor.showHint(this.myEditor, new DisabledFormattingMessageBuilder());
            }
            return;
        }
        if (this.myOptions.isOptimizeImports() && this.myOptions.getTextRangeType() != TextRangeType.SELECTED_TEXT) {
            this.myProcessor = new OptimizeImportsProcessor(this.myProject, this.myFile);
        }
        if (this.myProcessChangesTextOnly && !VcsFacade.getInstance().hasChanges(this.myFile)) {
            this.myNoChangesDetected = true;
        }
        this.myProcessor = this.mixWithReformatProcessor(this.myProcessor);
        if (this.myOptions.isRearrangeCode()) {
            this.myProcessor = this.mixWithRearrangeProcessor(this.myProcessor);
        }
        if (this.myOptions.isCodeCleanup()) {
            this.myProcessor = this.mixWithCleanupProcessor(this.myProcessor);
        }
        if (this.shouldNotify()) {
            this.myProcessor.setCollectInfo(true);
            this.myProcessor.setPostRunnable(() -> {
                if (this.myEditor.isDisposed() || !this.myEditor.getComponent().isShowing()) {
                    return;
                }
                if (!(this.myProcessSelectedText && Objects.requireNonNull(this.myProcessor.getInfoCollector()).getSecondFormatNotification() == null || this.isExternalFormatterInUse())) {
                    FileInEditorProcessor.showHint(this.myEditor, new FormattedMessageBuilder());
                }
            });
        }
        this.myProcessor.run();
        if (this.myEditor != null && this.myOptions.getTextRangeType() == TextRangeType.WHOLE_FILE) {
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
        }
    }

    private boolean isExternalFormatterInUse() {
        return !(FormattingServiceUtil.findService((PsiFile)this.myFile, (boolean)true, (this.myOptions.getTextRangeType() == TextRangeType.WHOLE_FILE ? 1 : 0) != 0) instanceof CoreFormattingService);
    }

    @NotNull
    private AbstractLayoutCodeProcessor mixWithCleanupProcessor(@NotNull AbstractLayoutCodeProcessor processor) {
        if (processor == null) {
            FileInEditorProcessor.$$$reportNull$$$0(0);
        }
        processor = this.myProcessSelectedText ? new CodeCleanupCodeProcessor(processor, this.myEditor.getSelectionModel()) : new CodeCleanupCodeProcessor(processor);
        AbstractLayoutCodeProcessor abstractLayoutCodeProcessor = processor;
        if (abstractLayoutCodeProcessor == null) {
            FileInEditorProcessor.$$$reportNull$$$0(1);
        }
        return abstractLayoutCodeProcessor;
    }

    private AbstractLayoutCodeProcessor mixWithRearrangeProcessor(@NotNull AbstractLayoutCodeProcessor processor) {
        if (processor == null) {
            FileInEditorProcessor.$$$reportNull$$$0(2);
        }
        processor = this.myProcessSelectedText ? new RearrangeCodeProcessor(processor, this.myEditor.getSelectionModel()) : new RearrangeCodeProcessor(processor);
        return processor;
    }

    @NotNull
    private AbstractLayoutCodeProcessor mixWithReformatProcessor(@Nullable AbstractLayoutCodeProcessor processor) {
        ReformatCodeProcessor reformatCodeProcessor = processor != null ? (this.myProcessSelectedText ? new ReformatCodeProcessor(processor, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(processor, this.myProcessChangesTextOnly)) : (this.myProcessSelectedText ? new ReformatCodeProcessor(this.myFile, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(this.myFile, this.myProcessChangesTextOnly));
        if (this.myOptions.doNotKeepLineBreaks()) {
            reformatCodeProcessor.setDoNotKeepLineBreaks(this.myFile);
        }
        ReformatCodeProcessor reformatCodeProcessor2 = reformatCodeProcessor;
        if (reformatCodeProcessor2 == null) {
            FileInEditorProcessor.$$$reportNull$$$0(3);
        }
        return reformatCodeProcessor2;
    }

    @NotNull
    private static String joinWithCommaAndCapitalize(String reformatNotification, String rearrangeNotification) {
        Object firstNotificationLine;
        Object object = firstNotificationLine = reformatNotification != null ? reformatNotification : rearrangeNotification;
        if (reformatNotification != null && rearrangeNotification != null) {
            firstNotificationLine = (String)firstNotificationLine + ", " + rearrangeNotification;
        }
        firstNotificationLine = StringUtil.capitalize((String)firstNotificationLine);
        String string2 = firstNotificationLine;
        if (string2 == null) {
            FileInEditorProcessor.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static void showHint(@NotNull Editor editor2, @NotNull MessageBuilder messageBuilder) {
        if (editor2 == null) {
            FileInEditorProcessor.$$$reportNull$$$0(5);
        }
        if (messageBuilder == null) {
            FileInEditorProcessor.$$$reportNull$$$0(6);
        }
        FileInEditorProcessor.showHint(editor2, messageBuilder.getMessage(), messageBuilder.createHyperlinkListener());
    }

    public static void showHint(@NotNull Editor editor2, @NotNull @NlsContexts.HintText String info, @Nullable HyperlinkListener hyperlinkListener) {
        if (editor2 == null) {
            FileInEditorProcessor.$$$reportNull$$$0(7);
        }
        if (info == null) {
            FileInEditorProcessor.$$$reportNull$$$0(8);
        }
        JComponent component2 = HintUtil.createInformationLabel((String)info, (HyperlinkListener)hyperlinkListener, null, null);
        LightweightHint hint = new LightweightHint(component2);
        int flags = 42;
        if (EditorUtil.isPrimaryCaretVisible((Editor)editor2)) {
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, (short)2, flags, 0, false);
        } else {
            FileInEditorProcessor.showHintWithoutScroll(editor2, hint, flags);
        }
    }

    private static void showHintWithoutScroll(Editor editor2, LightweightHint hint, int flags) {
        short constraint;
        int y;
        Rectangle visibleArea = editor2.getScrollingModel().getVisibleArea();
        if (FileInEditorProcessor.isCaretAboveTop(editor2, visibleArea)) {
            y = visibleArea.y;
            constraint = 2;
        } else {
            y = visibleArea.y + visibleArea.height;
            constraint = 1;
        }
        Point hintPoint = new Point(visibleArea.x + visibleArea.width / 2, y);
        JComponent component2 = HintManagerImpl.getExternalComponent((Editor)editor2);
        Point convertedPoint = SwingUtilities.convertPoint(editor2.getContentComponent(), hintPoint, component2);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, convertedPoint, flags, 0, false, constraint);
    }

    private static boolean isCaretAboveTop(Editor editor2, Rectangle area) {
        Caret caret = editor2.getCaretModel().getCurrentCaret();
        VisualPosition caretVisualPosition = caret.getVisualPosition();
        int caretY = editor2.visualPositionToXY((VisualPosition)caretVisualPosition).y;
        return caretY < area.y;
    }

    private boolean shouldNotify() {
        if (FileInEditorProcessor.isInHeadlessMode()) {
            return false;
        }
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        return es.isShowNotificationAfterReformat() && this.myEditor != null;
    }

    private static boolean isInHeadlessMode() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode() || application.isHeadlessEnvironment();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/FileInEditorProcessor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/FileInEditorProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "mixWithCleanupProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mixWithReformatProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "joinWithCommaAndCapitalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mixWithCleanupProcessor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mixWithRearrangeProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MessageBuilder {
        private MessageBuilder() {
        }

        @NlsContexts.HintText
        public abstract String getMessage();

        @NotNull
        public abstract Runnable getHyperlinkRunnable();

        public final HyperlinkListener createHyperlinkListener() {
            return new HyperlinkAdapter(){

                @Override
                protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.getHyperlinkRunnable().run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/actions/FileInEditorProcessor$MessageBuilder$1", "hyperlinkActivated"));
                }
            };
        }
    }

    private static class ShowReformatDialogRunnable
    implements Runnable {
        private final Editor myEditor;

        private ShowReformatDialogRunnable(Editor editor2) {
            this.myEditor = editor2;
        }

        @Override
        public void run() {
            AnAction action2 = ActionManager.getInstance().getAction("ShowReformatFileDialog");
            DataManager manager = DataManager.getInstance();
            if (manager != null) {
                DataContext context2 = manager.getDataContext((Component)this.myEditor.getContentComponent());
                action2.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"", (DataContext)context2));
            }
        }
    }

    private class FormattedMessageBuilder
    extends MessageBuilder {
        private FormattedMessageBuilder() {
        }

        @Override
        @NotNull
        public String getMessage() {
            HtmlBuilder builder2 = new HtmlBuilder();
            LayoutCodeInfoCollector notifications = FileInEditorProcessor.this.myProcessor.getInfoCollector();
            LOG.assertTrue(notifications != null);
            if (notifications.isEmpty() && !FileInEditorProcessor.this.myNoChangesDetected) {
                if (notifications.getSecondFormatNotification() != null) {
                    builder2.append(notifications.getSecondFormatNotification()).br();
                } else if (FileInEditorProcessor.this.myProcessChangesTextOnly) {
                    builder2.append(LangBundle.message("formatter.in.editor.message.already.formatted", new Object[0])).br();
                } else {
                    builder2.append(LangBundle.message("formatter.in.editor.message.content.already.formatted", new Object[0])).br();
                }
            } else {
                if (notifications.hasReformatOrRearrangeNotification()) {
                    String reformatInfo = notifications.getReformatCodeNotification();
                    String rearrangeInfo = notifications.getRearrangeCodeNotification();
                    builder2.append(FileInEditorProcessor.joinWithCommaAndCapitalize(reformatInfo, rearrangeInfo));
                    if (FileInEditorProcessor.this.myProcessChangesTextOnly) {
                        builder2.append(LangBundle.message("formatter.in.editor.message.changes.since.last.revision", new Object[0]));
                    }
                    builder2.br();
                } else if (FileInEditorProcessor.this.myNoChangesDetected) {
                    builder2.append(LangBundle.message("formatter.in.editor.message.no.changes.since.last.revision", new Object[0])).br();
                }
                String optimizeImportsNotification = notifications.getOptimizeImportsNotification();
                if (optimizeImportsNotification != null) {
                    builder2.append(optimizeImportsNotification).br();
                }
                if (notifications.getSecondFormatNotification() != null) {
                    builder2.append(notifications.getSecondFormatNotification()).br();
                }
            }
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowReformatFileDialog"));
            String color = ColorUtil.toHtmlColor(JBColor.gray);
            builder2.append(HtmlChunk.span("color:" + color).child(HtmlChunk.raw(LangBundle.message("formatter.in.editor.link.show.reformat.dialog", new Object[0]))).addText(shortcutText));
            String string2 = builder2.wrapWith("html").toString();
            if (string2 == null) {
                FormattedMessageBuilder.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public Runnable getHyperlinkRunnable() {
            return new ShowReformatDialogRunnable(FileInEditorProcessor.this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FileInEditorProcessor$FormattedMessageBuilder", "getMessage"));
        }
    }

    private class DisabledFormattingMessageBuilder
    extends MessageBuilder {
        private DisabledFormattingMessageBuilder() {
        }

        @Override
        @NotNull
        public String getMessage() {
            VirtualFile virtualFile2 = FileInEditorProcessor.this.myFile.getVirtualFile();
            String message2 = virtualFile2 == null ? LangBundle.message("formatter.unavailable.message", new Object[0]) : LangBundle.message("formatter.unavailable.for.0.message", virtualFile2.getName());
            String string2 = new HtmlBuilder().append(message2).append(HtmlChunk.p().child(HtmlChunk.span().child(HtmlChunk.link("", LangBundle.message("formatter.unavailable.show.settings.link", new Object[0]))))).wrapWithHtmlBody().toString();
            if (string2 == null) {
                DisabledFormattingMessageBuilder.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public Runnable getHyperlinkRunnable() {
            Runnable runnable = () -> ShowSettingsUtilImpl.showSettingsDialog((Project)FileInEditorProcessor.this.myProject, (String)"preferences.sourceCode", (String)"Do not format");
            if (runnable == null) {
                DisabledFormattingMessageBuilder.$$$reportNull$$$0(1);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/actions/FileInEditorProcessor$DisabledFormattingMessageBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHyperlinkRunnable";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

