/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeCleanupCodeProcessor
extends AbstractLayoutCodeProcessor {
    private SelectionModel mySelectionModel;

    public CodeCleanupCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        if (previousProcessor == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(0);
        }
        super(previousProcessor, CodeInsightBundle.message("command.cleanup.code", new Object[0]), CodeCleanupCodeProcessor.getProgressText());
        this.mySelectionModel = null;
    }

    public CodeCleanupCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @NotNull SelectionModel selectionModel) {
        if (previousProcessor == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(1);
        }
        if (selectionModel == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(2);
        }
        super(previousProcessor, CodeInsightBundle.message("command.cleanup.code", new Object[0]), CodeCleanupCodeProcessor.getProgressText());
        this.mySelectionModel = null;
        this.mySelectionModel = selectionModel;
    }

    public CodeCleanupCodeProcessor(@NotNull Project project2, PsiFile @NotNull [] files2, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        if (project2 == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(3);
        }
        if (files2 == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(4);
        }
        super(project2, files2, CodeCleanupCodeProcessor.getProgressText(), CodeInsightBundle.message("command.cleanup.code", new Object[0]), postRunnable, processChangedTextOnly);
        this.mySelectionModel = null;
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(5);
        }
        return new FutureTask<Boolean>(() -> {
            if (!file2.isValid()) {
                return false;
            }
            Collection<TextRange> ranges2 = this.getRanges(file2, processChangedTextOnly);
            GlobalInspectionContextBase.cleanupElements(this.myProject, null, descriptor -> CodeCleanupCodeProcessor.isInRanges(ranges2, descriptor), file2);
            return true;
        });
    }

    private Collection<TextRange> getRanges(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(6);
        }
        if (this.mySelectionModel != null) {
            return CodeCleanupCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        if (processChangedTextOnly) {
            return VcsFacade.getInstance().getChangedTextRanges(this.myProject, file2);
        }
        return new SmartList<TextRange>(file2.getTextRange());
    }

    private static boolean isInRanges(Collection<? extends TextRange> ranges2, @NotNull ProblemDescriptor descriptor) {
        if (descriptor == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(7);
        }
        for (TextRange textRange : ranges2) {
            if (!textRange.containsOffset(descriptor.getStartElement().getTextOffset()) && !textRange.containsOffset(descriptor.getEndElement().getTextOffset())) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.ProgressText
    public static String getProgressText() {
        return CodeInsightBundle.message("process.cleanup.code", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/CodeCleanupCodeProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRanges";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

