/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorHighlightingPass
implements HighlightingPass {
    public static final TextEditorHighlightingPass[] EMPTY_ARRAY = new TextEditorHighlightingPass[0];
    @NotNull
    protected final Document myDocument;
    @NotNull
    protected final Project myProject;
    private final boolean myRunIntentionPassAfter;
    private final long myInitialDocStamp;
    private final long myInitialPsiStamp;
    private volatile int[] myCompletionPredecessorIds;
    private volatile int[] myStartingPredecessorIds;
    private volatile int myId;
    private volatile boolean myDumb;
    private EditorColorsScheme myColorsScheme;

    protected TextEditorHighlightingPass(@NotNull Project project2, @NotNull Document document, boolean runIntentionPassAfter) {
        if (project2 == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(1);
        }
        this.myCompletionPredecessorIds = ArrayUtilRt.EMPTY_INT_ARRAY;
        this.myStartingPredecessorIds = ArrayUtilRt.EMPTY_INT_ARRAY;
        this.myDocument = document;
        this.myProject = project2;
        this.myRunIntentionPassAfter = runIntentionPassAfter;
        this.myInitialDocStamp = document.getModificationStamp();
        this.myInitialPsiStamp = PsiModificationTracker.getInstance(project2).getModificationCount();
    }

    protected TextEditorHighlightingPass(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(2);
        }
        if (document == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(3);
        }
        this(project2, document, true);
    }

    public final void collectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(4);
        }
        if (!this.isValid()) {
            return;
        }
        GlobalInspectionContextBase.assertUnderDaemonProgress();
        this.myDumb = DumbService.getInstance(this.myProject).isDumb();
        this.doCollectInformation(progress);
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    public void setColorsScheme(@Nullable EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    protected boolean isDumbMode() {
        return this.myDumb;
    }

    @NotNull
    public Condition<?> getExpiredCondition() {
        Condition<Object> condition = o -> ReadAction.compute(() -> !this.isValid());
        if (condition == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(5);
        }
        return condition;
    }

    protected boolean isValid() {
        PsiElement context2;
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (this.isDumbMode() && !DumbService.isDumbAware(this)) {
            return false;
        }
        if (PsiModificationTracker.getInstance(this.myProject).getModificationCount() != this.myInitialPsiStamp) {
            return false;
        }
        if (this.myDocument.getModificationStamp() != this.myInitialDocStamp) {
            return false;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myDocument);
        return file2 != null && file2.isValid() && ((context2 = file2.getContext()) == null || context2 == file2 || context2.isValid());
    }

    public final void applyInformationToEditor() {
        if (!this.isValid()) {
            return;
        }
        if (DumbService.getInstance(this.myProject).isDumb() && !DumbService.isDumbAware(this)) {
            Document document = this.getDocument();
            PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
            if (file2 != null) {
                DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().markFileUpToDate(this.getDocument(), this.getId());
            }
            return;
        }
        this.doApplyInformationToEditor();
    }

    public abstract void doCollectInformation(@NotNull ProgressIndicator var1);

    public abstract void doApplyInformationToEditor();

    public final int getId() {
        return this.myId;
    }

    public final void setId(int id2) {
        this.myId = id2;
    }

    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list2 = Collections.emptyList();
        if (list2 == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public final int @NotNull [] getCompletionPredecessorIds() {
        if (this.myCompletionPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(7);
        }
        return this.myCompletionPredecessorIds;
    }

    public final void setCompletionPredecessorIds(int @NotNull [] completionPredecessorIds) {
        if (completionPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(8);
        }
        this.myCompletionPredecessorIds = completionPredecessorIds;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(9);
        }
        return document;
    }

    public final int @NotNull [] getStartingPredecessorIds() {
        if (this.myStartingPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(10);
        }
        return this.myStartingPredecessorIds;
    }

    public final void setStartingPredecessorIds(int @NotNull [] startingPredecessorIds) {
        if (startingPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(11);
        }
        this.myStartingPredecessorIds = startingPredecessorIds;
    }

    @NonNls
    public String toString() {
        return (this.getClass().isAnonymousClass() ? this.getClass().getSuperclass() : this.getClass()).getSimpleName() + "; id=" + this.getId();
    }

    public boolean isRunIntentionPassAfter() {
        return this.myRunIntentionPassAfter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeHighlighting/TextEditorHighlightingPass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionPredecessorIds";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingPredecessorIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeHighlighting/TextEditorHighlightingPass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpiredCondition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPredecessorIds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartingPredecessorIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionPredecessorIds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setStartingPredecessorIds";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

