/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorSchemeImporter;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.ide.actions.QuickChangeColorSchemeAction;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.lang.LangBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorColorSchemeDropHandler
extends CustomFileDropHandler {
    public boolean canHandle(@NotNull Transferable t, @Nullable Editor editor2) {
        if (t == null) {
            EditorColorSchemeDropHandler.$$$reportNull$$$0(0);
        }
        return EditorColorSchemeDropHandler.getColorSchemeFile(t) != null;
    }

    private static VirtualFile getColorSchemeFile(@NotNull Transferable t) {
        List list2;
        File io;
        if (t == null) {
            EditorColorSchemeDropHandler.$$$reportNull$$$0(1);
        }
        File file2 = io = (list2 = FileCopyPasteUtil.getFileList((Transferable)t)) != null && list2.size() == 1 ? (File)ContainerUtil.getFirstItem(list2) : null;
        if (io == null || !StringUtil.endsWithIgnoreCase(io.getName(), ".icls")) {
            return null;
        }
        return VfsUtil.findFileByIoFile(io, true);
    }

    public boolean handleDrop(@NotNull Transferable t, @Nullable Editor editor2, Project project2) {
        if (t == null) {
            EditorColorSchemeDropHandler.$$$reportNull$$$0(2);
        }
        VirtualFile file2 = EditorColorSchemeDropHandler.getColorSchemeFile(t);
        assert (file2 != null);
        if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)LangBundle.message("dialog.title.install.color.scheme", new Object[0]), (String)LangBundle.message("message.would.you.like.to.install.and.apply.0.editor.color.scheme", file2.getName())).yesText(LangBundle.message("button.install", new Object[0]))).noText(LangBundle.message("button.open.in.editor", new Object[0]))).ask(project2)) {
            try {
                ColorSchemeImporter importer = new ColorSchemeImporter();
                EditorColorsManager colorsManager = EditorColorsManager.getInstance();
                List<String> names = ContainerUtil.map(colorsManager.getAllSchemes(), Scheme::getName);
                EditorColorsScheme imported = importer.importScheme(DefaultProjectFactory.getInstance().getDefaultProject(), file2, colorsManager.getGlobalScheme(), name2 -> {
                    String preferredName = name2 != null ? name2 : "Unnamed";
                    String newName2 = SchemeNameGenerator.getUniqueName((String)preferredName, candidate -> names.contains(candidate));
                    EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl((EditorColorsScheme)EmptyColorScheme.INSTANCE);
                    newScheme.setName(newName2);
                    newScheme.setDefaultMetaInfo((AbstractColorsScheme)EmptyColorScheme.INSTANCE);
                    return newScheme;
                });
                if (imported != null) {
                    colorsManager.addColorsScheme(imported);
                    String message2 = importer.getAdditionalImportInfo((Scheme)imported);
                    if (message2 == null) {
                        message2 = ApplicationBundle.message((String)"settings.editor.scheme.import.success", (Object[])new Object[]{file2.getPresentableUrl(), imported.getName()});
                    }
                    colorsManager.setGlobalScheme(imported);
                    Notification notification = new Notification("ColorSchemeDrop", LangBundle.message("notification.title.color.scheme.added", new Object[0]), message2, NotificationType.INFORMATION);
                    QuickChangeColorSchemeAction.changeLafIfNecessary((EditorColorsScheme)imported, () -> new Alarm().addRequest(() -> Notifications.Bus.notify((Notification)notification, (Project)project2), 300));
                }
            }
            catch (SchemeImportException e) {
                String title = e.isWarning() ? LangBundle.message("notification.title.color.scheme.added", new Object[0]) : LangBundle.message("notification.title.color.scheme.import.failed", new Object[0]);
                NotificationType type = e.isWarning() ? NotificationType.WARNING : NotificationType.ERROR;
                Notification notification = new Notification("ColorSchemeDrop", title, e.getMessage(), type);
                notification.notify(project2);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "t";
        objectArray2[1] = "com/intellij/application/options/colors/EditorColorSchemeDropHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorSchemeFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDrop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

