/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.FormatterEnabledAccessor;
import com.intellij.application.options.codeStyle.properties.StringAccessor;
import com.intellij.application.options.codeStyle.properties.VisualGuidesAccessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GeneralCodeStylePropertyMapper
extends AbstractCodeStylePropertyMapper {
    private static final Logger LOG = Logger.getInstance(AbstractCodeStylePropertyMapper.class);
    public static final String COMMON_DOMAIN_ID = "all";
    private static final Set<String> GENERAL_FIELDS = ContainerUtil.newHashSet("LINE_SEPARATOR", "RIGHT_MARGIN", "WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN", "FORMATTER_TAGS_ENABLED", "FORMATTER_ON_TAG", "FORMATTER_OFF_TAG", "FORMATTER_TAGS_ACCEPT_REGEXP");
    private static final Set<String> INDENT_FIELDS = ContainerUtil.newHashSet("INDENT_SIZE", "USE_TAB_CHARACTER", "TAB_SIZE", "SMART_TABS", "CONTINUATION_INDENT_SIZE");

    public GeneralCodeStylePropertyMapper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            GeneralCodeStylePropertyMapper.$$$reportNull$$$0(0);
        }
        super(settings);
    }

    @Override
    @NotNull
    protected List<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> getSupportedFields() {
        ArrayList<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> supportedFields = new ArrayList<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor>(2);
        supportedFields.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(this.getRootSettings(), GENERAL_FIELDS));
        supportedFields.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(this.getRootSettings().OTHER_INDENT_OPTIONS, INDENT_FIELDS));
        ArrayList<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> arrayList = supportedFields;
        if (arrayList == null) {
            GeneralCodeStylePropertyMapper.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    protected boolean useDeclaredFields() {
        return true;
    }

    @Override
    @NotNull
    public String getLanguageDomainId() {
        return COMMON_DOMAIN_ID;
    }

    @Override
    @Nullable
    protected CodeStylePropertyAccessor<?> getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            GeneralCodeStylePropertyMapper.$$$reportNull$$$0(2);
        }
        if (field == null) {
            GeneralCodeStylePropertyMapper.$$$reportNull$$$0(3);
        }
        if (codeStyleObject instanceof CodeStyleSettings && "LINE_SEPARATOR".equals(field.getName())) {
            return new LineSeparatorAccessor(codeStyleObject, field);
        }
        return super.getAccessor(codeStyleObject, field);
    }

    @Override
    @Nullable
    public String getPropertyDescription(@NotNull String externalName) {
        String key;
        if (externalName == null) {
            GeneralCodeStylePropertyMapper.$$$reportNull$$$0(4);
        }
        return OptionsBundle.INSTANCE.containsKey(key = "codestyle.property.description." + externalName) ? OptionsBundle.message((String)("codestyle.property.description." + externalName), (Object[])new Object[0]) : null;
    }

    @Override
    protected void addAdditionalAccessors(@NotNull Map<String, CodeStylePropertyAccessor<?>> accessorMap) {
        if (accessorMap == null) {
            GeneralCodeStylePropertyMapper.$$$reportNull$$$0(5);
        }
        accessorMap.put("visual_guides", new VisualGuidesAccessor(this.getRootSettings(), null));
        accessorMap.put("formatter_enabled", new FormatterEnabledAccessor(this.getRootSettings()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/properties/GeneralCodeStylePropertyMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/properties/GeneralCodeStylePropertyMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescription";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalAccessors";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineSeparatorAccessor
    extends StringAccessor {
        LineSeparatorAccessor(@NotNull Object object, @NotNull Field field) {
            if (object == null) {
                LineSeparatorAccessor.$$$reportNull$$$0(0);
            }
            if (field == null) {
                LineSeparatorAccessor.$$$reportNull$$$0(1);
            }
            super(object, field);
        }

        @Override
        @Nullable
        protected String fromExternal(@NotNull String str) {
            if (str == null) {
                LineSeparatorAccessor.$$$reportNull$$$0(2);
            }
            if (str.equals("lf")) {
                return "\n";
            }
            if (str.equals("cr")) {
                return "\r";
            }
            if (str.equals("crlf")) {
                return "\r\f";
            }
            return null;
        }

        @Override
        @NotNull
        protected String toExternal(@NotNull String value) {
            if (value == null) {
                LineSeparatorAccessor.$$$reportNull$$$0(3);
            }
            if ("\n".equals(value)) {
                return "lf";
            }
            if ("\r".equals(value)) {
                return "cr";
            }
            if ("\r\n".equals(value)) {
                return "crlf";
            }
            LOG.error("Unexpected field value: " + value);
            return "";
        }

        @Override
        protected boolean isEmpty(@NotNull String value) {
            if (value == null) {
                LineSeparatorAccessor.$$$reportNull$$$0(4);
            }
            return StringUtil.isEmpty(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/codeStyle/properties/GeneralCodeStylePropertyMapper$LineSeparatorAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromExternal";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toExternal";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEmpty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

