/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.excludedFiles;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.excludedFiles.ExcludedFilesScopeDialog;
import com.intellij.application.options.codeStyle.excludedFiles.NamedScopeDescriptor;
import com.intellij.application.options.codeStyle.excludedFiles.NamedScopeToGlobConverter;
import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedFilesList
extends JBList<FileSetDescriptor> {
    private final ToolbarDecorator myFileListDecorator = ToolbarDecorator.createDecorator((JList)((Object)this)).setRemoveAction(new AnActionButtonRunnable(){

        public void run(AnActionButton button2) {
            ExcludedFilesList.this.removeDescriptor();
        }
    }).disableUpDownActions();
    private DefaultListModel<FileSetDescriptor> myModel;
    @Nullable
    private CodeStyleSchemesModel mySchemesModel;

    public ExcludedFilesList() {
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExcludedFilesList.this.onSelectionChange();
            }
        });
    }

    public void initModel() {
        this.myModel = ExcludedFilesList.createDefaultListModel((Object[])new FileSetDescriptor[0]);
        this.setModel(this.myModel);
    }

    private void onSelectionChange() {
        int i = this.getSelectedIndex();
        AnActionButton removeButton = ToolbarDecorator.findRemoveButton((JComponent)this.myFileListDecorator.getActionsPanel());
        ObjectUtils.consumeIfNotNull(removeButton, button2 -> button2.setEnabled(i >= 0));
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedFilesList.$$$reportNull$$$0(0);
        }
        this.myModel.clear();
        for (FileSetDescriptor descriptor : settings.getExcludedFiles().getDescriptors("namedScope")) {
            if (NamedScopeToGlobConverter.convert((NamedScopeDescriptor)descriptor) != null) continue;
            this.myModel.addElement(descriptor);
        }
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedFilesList.$$$reportNull$$$0(1);
        }
        settings.getExcludedFiles().setDescriptors("namedScope", this.getDescriptors());
    }

    @NotNull
    private List<FileSetDescriptor> getDescriptors() {
        ArrayList<FileSetDescriptor> descriptors = new ArrayList<FileSetDescriptor>();
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            descriptors.add(this.myModel.get(i));
        }
        Collections.sort(descriptors, (d1, d2) -> {
            int result2 = StringUtil.compare(d1.getName(), d2.getName(), false);
            if (result2 != 0) {
                return result2;
            }
            return StringUtil.compare(d1.getPattern(), d2.getPattern(), false);
        });
        ArrayList<FileSetDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            ExcludedFilesList.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedFilesList.$$$reportNull$$$0(3);
        }
        return !settings.getExcludedFiles().getDescriptors("namedScope").equals(this.getDescriptors());
    }

    public ToolbarDecorator getDecorator() {
        return this.myFileListDecorator;
    }

    private void addDescriptor() {
        assert (this.mySchemesModel != null);
        List<NamedScope> availableScopes = this.getAvailableScopes();
        if (!availableScopes.isEmpty()) {
            ExcludedFilesScopeDialog dialog = new ExcludedFilesScopeDialog(this.mySchemesModel.getProject(), availableScopes);
            dialog.show();
            if (dialog.isOK()) {
                FileSetDescriptor descriptor = dialog.getDescriptor();
                if (descriptor != null) {
                    int insertAt = this.getSelectedIndex() < 0 ? this.getItemsCount() : this.getSelectedIndex() + 1;
                    int exiting = this.myModel.indexOf(descriptor);
                    if (exiting < 0) {
                        this.myModel.add(insertAt, descriptor);
                        this.setSelectedValue(descriptor, true);
                    } else {
                        this.setSelectedValue(this.myModel.get(exiting), true);
                    }
                }
            } else if (dialog.getExitCode() == 2) {
                this.editScope(null);
            }
        } else {
            this.editScope(null);
        }
    }

    private List<NamedScope> getAvailableScopes() {
        Set<String> usedNames = this.getUsedScopeNames();
        ArrayList<NamedScope> namedScopes = new ArrayList<NamedScope>();
        for (NamedScopesHolder holder : this.getScopeHolders()) {
            for (NamedScope scope : holder.getEditableScopes()) {
                if (usedNames.contains(scope.getScopeId())) continue;
                namedScopes.add(scope);
            }
        }
        return namedScopes;
    }

    private Set<String> getUsedScopeNames() {
        HashSet<String> usedScopeNames = new HashSet<String>();
        for (int i = 0; i < this.myModel.size(); ++i) {
            FileSetDescriptor descriptor = this.myModel.get(i);
            if (!(descriptor instanceof NamedScopeDescriptor)) continue;
            usedScopeNames.add(descriptor.getName());
        }
        return usedScopeNames;
    }

    private void removeDescriptor() {
        int i = this.getSelectedIndex();
        if (i >= 0) {
            this.myModel.remove(i);
        }
    }

    private void editDescriptor() {
        FileSetDescriptor selectedDescriptor;
        int i = this.getSelectedIndex();
        FileSetDescriptor fileSetDescriptor = selectedDescriptor = i >= 0 ? this.myModel.get(i) : null;
        if (selectedDescriptor instanceof NamedScopeDescriptor) {
            this.ensureScopeExists((NamedScopeDescriptor)selectedDescriptor);
            this.editScope(selectedDescriptor.getName());
        } else {
            this.editScope(null);
        }
    }

    public void setSchemesModel(@NotNull CodeStyleSchemesModel schemesModel) {
        if (schemesModel == null) {
            ExcludedFilesList.$$$reportNull$$$0(4);
        }
        this.mySchemesModel = schemesModel;
    }

    public void editScope(@Nullable String selectedName) {
        NamedScope scope;
        assert (this.mySchemesModel != null);
        EditScopesDialog scopesDialog = EditScopesDialog.showDialog(this.getScopeHolderProject(), selectedName);
        if (scopesDialog.isOK() && (scope = scopesDialog.getSelectedScope()) != null) {
            String newName2 = scope.getScopeId();
            FileSetDescriptor newDesciptor = null;
            if (selectedName == null) {
                newDesciptor = this.findDescriptor(newName2);
                if (newDesciptor == null) {
                    newDesciptor = new NamedScopeDescriptor(scope);
                    this.myModel.addElement(newDesciptor);
                }
            } else {
                FileSetDescriptor oldDescriptor = this.findDescriptor(selectedName);
                if (!selectedName.equals(newName2)) {
                    int index = this.myModel.indexOf(oldDescriptor);
                    this.myModel.removeElement(oldDescriptor);
                    newDesciptor = this.findDescriptor(newName2);
                    if (newDesciptor == null) {
                        newDesciptor = new NamedScopeDescriptor(scope);
                        this.myModel.add(index, newDesciptor);
                    }
                } else if (oldDescriptor != null) {
                    PackageSet fileSet = scope.getValue();
                    oldDescriptor.setPattern(fileSet != null ? fileSet.getText() : null);
                }
            }
            if (newDesciptor != null) {
                this.setSelectedValue(newDesciptor, true);
            }
        }
    }

    private void ensureScopeExists(@NotNull NamedScopeDescriptor descriptor) {
        if (descriptor == null) {
            ExcludedFilesList.$$$reportNull$$$0(5);
        }
        List<NamedScopesHolder> holders = this.getScopeHolders();
        for (NamedScopesHolder holder : holders) {
            if (holder.getScope(descriptor.getName()) == null) continue;
            return;
        }
        DependencyValidationManager projectScopeHolder = DependencyValidationManager.getInstance(this.getScopeHolderProject());
        NamedScope newScope = projectScopeHolder.createScope(descriptor.getName(), descriptor.getFileSet());
        projectScopeHolder.addScope(newScope);
    }

    private Project getScopeHolderProject() {
        assert (this.mySchemesModel != null);
        CodeStyleScheme scheme = this.mySchemesModel.getSelectedScheme();
        return this.mySchemesModel.isProjectScheme(scheme) ? this.mySchemesModel.getProject() : ProjectManager.getInstance().getDefaultProject();
    }

    @Nullable
    private FileSetDescriptor findDescriptor(@NotNull String name2) {
        if (name2 == null) {
            ExcludedFilesList.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < this.myModel.size(); ++i) {
            if (!name2.equals(this.myModel.get(i).getName())) continue;
            return this.myModel.get(i);
        }
        return null;
    }

    private List<NamedScopesHolder> getScopeHolders() {
        ArrayList<NamedScopesHolder> holders = new ArrayList<NamedScopesHolder>();
        Project project2 = this.getScopeHolderProject();
        holders.add(DependencyValidationManager.getInstance(project2));
        holders.add(NamedScopeManager.getInstance(project2));
        return holders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/excludedFiles/ExcludedFilesList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemesModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/excludedFiles/ExcludedFilesList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSchemesModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureScopeExists";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

