/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.additional;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.OptionGroup;
import com.intellij.util.ui.JBUI;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceArrangementPanel {
    @NotNull
    private final JComboBox<SelectedMode> myForceRearrangeComboBox = new ComboBox();
    @NotNull
    private final JPanel myPanel;

    public ForceArrangementPanel() {
        this.myForceRearrangeComboBox.setModel((ComboBoxModel<SelectedMode>)new EnumComboBoxModel(SelectedMode.class));
        this.myForceRearrangeComboBox.setMaximumSize(this.myForceRearrangeComboBox.getPreferredSize());
        this.myPanel = this.createPanel();
    }

    public int getRearrangeMode() {
        Object item = this.myForceRearrangeComboBox.getSelectedItem();
        assert (item != null) : this.myForceRearrangeComboBox.getSelectedIndex();
        return ((SelectedMode)((Object)item)).rearrangeMode;
    }

    public void setSelectedMode(@NotNull SelectedMode mode) {
        if (mode == null) {
            ForceArrangementPanel.$$$reportNull$$$0(0);
        }
        this.myForceRearrangeComboBox.setSelectedItem((Object)mode);
    }

    public void setSelectedMode(int mode) {
        SelectedMode toSetUp = SelectedMode.getByMode(mode);
        assert (toSetUp != null);
        this.setSelectedMode(toSetUp);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ForceArrangementPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private JPanel createPanel() {
        OptionGroup group = new OptionGroup(ApplicationBundle.message((String)"arrangement.settings.additional.title", (Object[])new Object[0]));
        JPanel textWithComboPanel = new JPanel();
        textWithComboPanel.setLayout(new BoxLayout(textWithComboPanel, 2));
        textWithComboPanel.add(new JLabel(ApplicationBundle.message((String)"arrangement.settings.additional.force.combobox.name", (Object[])new Object[0])));
        textWithComboPanel.add(Box.createRigidArea(JBUI.size(5, 0)));
        textWithComboPanel.add(this.myForceRearrangeComboBox);
        group.add((JComponent)textWithComboPanel);
        return group.createPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedMode";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SelectedMode {
        FROM_DIALOG("arrangement.settings.additional.force.rearrange.according.to.dialog", 0),
        ALWAYS("arrangement.settings.additional.force.rearrange.always", 1),
        NEVER("arrangement.settings.additional.force.rearrange.never", 2);

        public final int rearrangeMode;
        private final String myKey;

        private SelectedMode(String key, int mode) {
            this.myKey = key;
            this.rearrangeMode = mode;
        }

        @Nullable
        static SelectedMode getByMode(int mode) {
            for (SelectedMode currentMode : SelectedMode.values()) {
                if (currentMode.rearrangeMode != mode) continue;
                return currentMode;
            }
            return null;
        }

        public String toString() {
            return ApplicationBundle.message((String)this.myKey, (Object[])new Object[0]);
        }
    }
}

