/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.DynamicBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommenterForm
implements CodeStyleSettingsCustomizable {
    private JPanel myCommenterPanel;
    private JBCheckBox myLineCommentAtFirstColumnCb;
    private JBCheckBox myLineCommentAddSpaceCb;
    private JBCheckBox myLineCommentAddSpaceOnReformatCb;
    private JBCheckBox myBlockCommentAtFirstJBCheckBox;
    private JBCheckBox myBlockCommentAddSpaceCb;
    private final Language myLanguage;

    public CommenterForm(Language language) {
        this(language, ApplicationBundle.message((String)"title.naming.comment.code", (Object[])new Object[0]));
    }

    public CommenterForm(Language language, @Nullable @NlsContexts.BorderTitle String title) {
        this.myLanguage = language;
        this.$$$setupUI$$$();
        if (title != null) {
            this.myCommenterPanel.setBorder(IdeBorderFactory.createTitledBorder((String)title));
        }
        this.myLineCommentAtFirstColumnCb.addActionListener(e -> {
            if (this.myLineCommentAtFirstColumnCb.isSelected()) {
                this.myLineCommentAddSpaceCb.setSelected(false);
                this.myLineCommentAddSpaceOnReformatCb.setSelected(false);
            }
            this.myLineCommentAddSpaceCb.setEnabled(!this.myLineCommentAtFirstColumnCb.isSelected());
            this.myLineCommentAddSpaceOnReformatCb.setEnabled(this.myLineCommentAddSpaceCb.isSelected());
        });
        this.myLineCommentAddSpaceCb.addActionListener(e -> {
            boolean addSpace = this.myLineCommentAddSpaceCb.isSelected();
            this.myLineCommentAddSpaceOnReformatCb.setEnabled(addSpace);
            this.myLineCommentAddSpaceOnReformatCb.setSelected(addSpace);
        });
        this.myLineCommentAddSpaceOnReformatCb.setVisible(false);
        this.customizeSettings();
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CommenterForm.$$$reportNull$$$0(0);
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        this.myLineCommentAtFirstColumnCb.setSelected(langSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myBlockCommentAtFirstJBCheckBox.setSelected(langSettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        this.myLineCommentAddSpaceCb.setSelected(langSettings.LINE_COMMENT_ADD_SPACE && !langSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myLineCommentAddSpaceCb.setEnabled(!langSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myLineCommentAddSpaceOnReformatCb.setEnabled(langSettings.LINE_COMMENT_ADD_SPACE);
        this.myLineCommentAddSpaceOnReformatCb.setSelected(langSettings.LINE_COMMENT_ADD_SPACE_ON_REFORMAT);
        this.myBlockCommentAddSpaceCb.setSelected(langSettings.BLOCK_COMMENT_ADD_SPACE);
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CommenterForm.$$$reportNull$$$0(1);
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        langSettings.LINE_COMMENT_AT_FIRST_COLUMN = this.myLineCommentAtFirstColumnCb.isSelected();
        langSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = this.myBlockCommentAtFirstJBCheckBox.isSelected();
        langSettings.LINE_COMMENT_ADD_SPACE = this.myLineCommentAddSpaceCb.isSelected();
        langSettings.LINE_COMMENT_ADD_SPACE_ON_REFORMAT = this.myLineCommentAddSpaceOnReformatCb.isSelected();
        langSettings.BLOCK_COMMENT_ADD_SPACE = this.myBlockCommentAddSpaceCb.isSelected();
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CommenterForm.$$$reportNull$$$0(2);
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        return this.myLineCommentAtFirstColumnCb.isSelected() != langSettings.LINE_COMMENT_AT_FIRST_COLUMN || this.myBlockCommentAtFirstJBCheckBox.isSelected() != langSettings.BLOCK_COMMENT_AT_FIRST_COLUMN || this.myLineCommentAddSpaceCb.isSelected() != langSettings.LINE_COMMENT_ADD_SPACE || this.myBlockCommentAddSpaceCb.isSelected() != langSettings.BLOCK_COMMENT_ADD_SPACE || this.myLineCommentAddSpaceOnReformatCb.isSelected() != langSettings.LINE_COMMENT_ADD_SPACE_ON_REFORMAT;
    }

    public JPanel getCommenterPanel() {
        return this.myCommenterPanel;
    }

    @Override
    public void showAllStandardOptions() {
        this.setAllOptionsVisible(true);
    }

    @Override
    public void showStandardOptions(String ... optionNames) {
        for (String optionName : optionNames) {
            if (CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_ADD_SPACE.name().equals(optionName)) {
                this.myLineCommentAddSpaceCb.setVisible(true);
            }
            if (CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_ADD_SPACE_ON_REFORMAT.name().equals(optionName)) {
                this.myLineCommentAddSpaceOnReformatCb.setVisible(true);
                continue;
            }
            if (CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_AT_FIRST_COLUMN.name().equals(optionName)) {
                this.myLineCommentAtFirstColumnCb.setVisible(true);
                continue;
            }
            if (CodeStyleSettingsCustomizable.CommenterOption.BLOCK_COMMENT_AT_FIRST_COLUMN.name().equals(optionName)) {
                this.myBlockCommentAtFirstJBCheckBox.setVisible(true);
                continue;
            }
            if (!CodeStyleSettingsCustomizable.CommenterOption.BLOCK_COMMENT_ADD_SPACE.name().equals(optionName)) continue;
            this.myBlockCommentAddSpaceCb.setVisible(true);
        }
    }

    private void setAllOptionsVisible(boolean isVisible) {
        this.myLineCommentAtFirstColumnCb.setVisible(isVisible);
        this.myLineCommentAddSpaceCb.setVisible(isVisible);
        this.myBlockCommentAtFirstJBCheckBox.setVisible(isVisible);
        this.myBlockCommentAddSpaceCb.setVisible(isVisible);
        this.myLineCommentAddSpaceOnReformatCb.setVisible(isVisible);
    }

    private void customizeSettings() {
        this.setAllOptionsVisible(false);
        LanguageCodeStyleSettingsProvider settingsProvider = LanguageCodeStyleSettingsProvider.forLanguage(this.myLanguage);
        if (settingsProvider != null) {
            settingsProvider.customizeSettings(this, LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS);
        }
        this.myCommenterPanel.setVisible(this.myLineCommentAtFirstColumnCb.isVisible() || this.myLineCommentAddSpaceCb.isVisible() || this.myLineCommentAddSpaceOnReformatCb.isVisible() || this.myBlockCommentAtFirstJBCheckBox.isVisible() || this.myBlockCommentAddSpaceCb.isVisible());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JPanel jPanel;
        this.myCommenterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLineCommentAtFirstColumnCb = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle("messages/ApplicationBundle", CommenterForm.class).getString("checkbox.line.comment.at.first.column"));
        jPanel.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLineCommentAddSpaceCb = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle("messages/ApplicationBundle", CommenterForm.class).getString("checkbox.line.comment.add.space"));
        jPanel.add((Component)jBCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLineCommentAddSpaceOnReformatCb = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle("messages/ApplicationBundle", CommenterForm.class).getString("checkbox.line.comment.add.space.on.reformat"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myBlockCommentAtFirstJBCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle("messages/ApplicationBundle", CommenterForm.class).getString("checkbox.block.comment.at.first.column"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBlockCommentAddSpaceCb = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle("messages/ApplicationBundle", CommenterForm.class).getString("checkbox.block.comment.add.space"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCommenterPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "settings";
        objectArray2[1] = "com/intellij/application/options/codeStyle/CommenterForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

