/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.PredefinedCodeStyleListener;
import com.intellij.application.options.codeStyle.CodeStyleBlankLinesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSpacesPanel;
import com.intellij.application.options.codeStyle.WrappingAndBracesPanel;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Weighted;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabbedLanguageCodeStylePanel
extends CodeStyleAbstractPanel {
    private CodeStyleAbstractPanel myActiveTab;
    private List<CodeStyleAbstractPanel> myTabs;
    private JPanel myPanel;
    private TabbedPaneWrapper myTabbedPane;
    private final PredefinedCodeStyle[] myPredefinedCodeStyles;
    private JPopupMenu myCopyFromMenu;
    @Nullable
    private TabChangeListener myListener;
    private final EventDispatcher<PredefinedCodeStyleListener> myPredefinedCodeStyleEventDispatcher;
    private Ref<LanguageCodeStyleSettingsProvider> myProviderRef;
    private static final WeightedComparator WEIGHTED_COMPARATOR = new WeightedComparator();

    protected TabbedLanguageCodeStylePanel(@Nullable Language language, CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings) {
        if (settings == null) {
            TabbedLanguageCodeStylePanel.$$$reportNull$$$0(0);
        }
        super(language, currentSettings, settings);
        this.myPredefinedCodeStyleEventDispatcher = EventDispatcher.create(PredefinedCodeStyleListener.class);
        this.myPredefinedCodeStyles = this.getPredefinedStyles();
        CodeStyleSettingsProvider.EXTENSION_POINT_NAME.addExtensionPointListener(new ExtensionPointListener<CodeStyleSettingsProvider>(){

            @Override
            public void extensionAdded(@NotNull CodeStyleSettingsProvider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!extension2.hasSettingsPage() && TabbedLanguageCodeStylePanel.this.getDefaultLanguage() == extension2.getLanguage()) {
                    TabbedLanguageCodeStylePanel.this.createTab(extension2);
                }
            }

            @Override
            public void extensionRemoved(@NotNull CodeStyleSettingsProvider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!extension2.hasSettingsPage() && TabbedLanguageCodeStylePanel.this.getDefaultLanguage() == extension2.getLanguage()) {
                    String tabTitle = extension2.getConfigurableDisplayName();
                    for (int i = 0; i < TabbedLanguageCodeStylePanel.this.myTabbedPane.getTabCount(); ++i) {
                        if (!TabbedLanguageCodeStylePanel.this.myTabbedPane.getTitleAt(i).equals(tabTitle)) continue;
                        TabbedLanguageCodeStylePanel.this.myTabbedPane.removeTabAt(i);
                        TabbedLanguageCodeStylePanel.this.myTabs.stream().filter(panel2 -> panel2.getTabTitle().equals(tabTitle)).findFirst().ifPresent(panel2 -> TabbedLanguageCodeStylePanel.this.myTabs.remove(panel2));
                        return;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/application/options/TabbedLanguageCodeStylePanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    protected void initTabs(CodeStyleSettings settings) {
        this.addIndentOptionsTab(settings);
        if (this.getProvider() != null) {
            this.addSpacesTab(settings);
            this.addWrappingAndBracesTab(settings);
            this.addBlankLinesTab(settings);
        }
    }

    protected void addIndentOptionsTab(CodeStyleSettings settings) {
        IndentOptionsEditor indentOptionsEditor;
        if (this.getProvider() != null && (indentOptionsEditor = this.getProvider().getIndentOptionsEditor()) != null) {
            MyIndentOptionsWrapper indentOptionsWrapper = new MyIndentOptionsWrapper(settings, indentOptionsEditor);
            this.addTab(indentOptionsWrapper);
        }
    }

    protected void addSpacesTab(CodeStyleSettings settings) {
        this.addTab(new MySpacesPanel(settings));
    }

    protected void addBlankLinesTab(CodeStyleSettings settings) {
        this.addTab(new MyBlankLinesPanel(settings));
    }

    protected void addWrappingAndBracesTab(CodeStyleSettings settings) {
        this.addTab(new MyWrappingAndBracesPanel(settings));
    }

    protected void ensureTabs() {
        if (this.myTabs == null) {
            this.myPanel = new JPanel();
            this.myPanel.setLayout(new BorderLayout());
            this.myTabbedPane = new TabbedPaneWrapper((Disposable)this);
            this.myTabbedPane.addChangeListener(__ -> {
                String title;
                if (this.myListener != null && (title = this.myTabbedPane.getSelectedTitle()) != null) {
                    this.myListener.tabChanged(this, title);
                }
            });
            this.myTabs = new ArrayList<CodeStyleAbstractPanel>();
            this.myPanel.add(this.myTabbedPane.getComponent());
            this.initTabs(this.getSettings());
        }
        assert (!this.myTabs.isEmpty());
    }

    public void showSetFrom(Component component2) {
        this.initCopyFromMenu();
        DefaultActionGroup group = new DefaultActionGroup();
        JBTreeTraverser traverser = (JBTreeTraverser)JBTreeTraverser.of(o -> {
            Component[] componentArray;
            if (o instanceof JMenu) {
                Component[] componentArray2 = new Component[2];
                componentArray2[0] = new TitledSeparator(((JMenu)o).getText());
                componentArray = componentArray2;
                componentArray2[1] = ((JMenu)o).getPopupMenu();
            } else {
                componentArray = o instanceof JPopupMenu ? ((JPopupMenu)o).getComponents() : null;
            }
            return componentArray;
        }).withRoot(this.myCopyFromMenu);
        for (final Component c : traverser.traverse(TreeTraversal.LEAVES_DFS)) {
            if (c instanceof JSeparator) {
                group.addSeparator();
                continue;
            }
            if (c instanceof TitledSeparator) {
                group.addSeparator(((TitledSeparator)c).getText());
                continue;
            }
            if (!(c instanceof JMenuItem)) continue;
            group.add((AnAction)new DumbAwareAction(((JMenuItem)c).getText(), "", ObjectUtils.notNull(((JMenuItem)c).getIcon(), EmptyIcon.ICON_16)){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ((JMenuItem)c).doClick();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/TabbedLanguageCodeStylePanel$2", "actionPerformed"));
                }
            });
        }
        int maxRows = group.getChildrenCount() > 17 ? 15 : -1;
        DataContext dataContext = DataManager.getInstance().getDataContext(component2);
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, maxRows, null, "popup@TabbedLanguageCodeStylePanel").showUnderneathOf(component2);
    }

    private void initCopyFromMenu() {
        if (this.myCopyFromMenu == null) {
            this.myCopyFromMenu = new JBPopupMenu();
            this.myCopyFromMenu.setFocusable(false);
            this.setupCopyFromMenu(this.myCopyFromMenu);
        }
    }

    protected final void addTab(CodeStyleAbstractPanel tab) {
        this.myTabs.add(tab);
        tab.setShouldUpdatePreview(true);
        this.addPanelToWatch(tab.getPanel());
        this.myTabbedPane.addTab(tab.getTabTitle(), tab.getPanel());
        if (this.myActiveTab == null) {
            this.myActiveTab = tab;
        }
    }

    private void addTab(Configurable configurable2) {
        CodeStyleConfigurableWrapperPanel wrapper2 = new CodeStyleConfigurableWrapperPanel(configurable2, this.getSettings());
        this.addTab(wrapper2);
    }

    protected final void createTab(CodeStyleSettingsProvider provider2) {
        if (provider2.hasSettingsPage()) {
            return;
        }
        CodeStyleConfigurable configurable2 = provider2.createConfigurable(this.getCurrentSettings(), this.getSettings());
        this.addTab(configurable2);
    }

    @Override
    public final void setModel(@NotNull CodeStyleSchemesModel model2) {
        if (model2 == null) {
            TabbedLanguageCodeStylePanel.$$$reportNull$$$0(1);
        }
        super.setModel(model2);
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.setModel(model2);
        }
    }

    @Override
    protected int getRightMargin() {
        this.ensureTabs();
        return this.myActiveTab.getRightMargin();
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        this.ensureTabs();
        return this.myActiveTab.createHighlighter(scheme);
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        this.ensureTabs();
        FileType fileType = this.myActiveTab.getFileType();
        if (fileType == null) {
            TabbedLanguageCodeStylePanel.$$$reportNull$$$0(2);
        }
        return fileType;
    }

    @Override
    protected String getPreviewText() {
        this.ensureTabs();
        return this.myActiveTab.getPreviewText();
    }

    @Override
    protected void updatePreview(boolean useDefaultSample) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.updatePreview(useDefaultSample);
        }
    }

    @Override
    public void onSomethingChanged() {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.setShouldUpdatePreview(true);
            tab.onSomethingChanged();
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.apply(settings);
        }
    }

    @Override
    public void dispose() {
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            Disposer.dispose(tab);
        }
        super.dispose();
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            if (!tab.isModified(settings)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.resetImpl(settings);
        }
    }

    @Override
    public void setupCopyFromMenu(JPopupMenu copyMenu) {
        super.setupCopyFromMenu(copyMenu);
        if (this.myPredefinedCodeStyles.length > 0) {
            this.fillPredefinedStylesAndLanguages(copyMenu);
        } else {
            this.fillLanguages(copyMenu);
        }
    }

    private void fillPredefinedStylesAndLanguages(JPopupMenu copyMenu) {
        this.fillPredefinedStyles(copyMenu);
        LanguageCodeStyleSettingsProvider provider2 = this.getProvider();
        int n = 0;
        if (provider2 != null) {
            n = provider2.getApplicableLanguages().size();
        }
        if (n > 0) {
            copyMenu.addSeparator();
            if (n <= 15) {
                this.fillLanguages(copyMenu);
            } else {
                JMenu langs = new JMenu(ApplicationBundle.message((String)"code.style.set.from.menu.language", (Object[])new Object[0])){

                    @Override
                    public void paint(Graphics g) {
                        GraphicsUtil.setupAntialiasing(g);
                        super.paint(g);
                    }
                };
                copyMenu.add(langs);
                this.fillLanguages(langs);
            }
        }
    }

    private void fillLanguages(JComponent parentMenu) {
        List<Language> languages = this.getProvider() != null ? this.getProvider().getApplicableLanguages() : Collections.emptyList();
        for (Language lang : languages) {
            if (lang.equals(this.getDefaultLanguage())) continue;
            String langName = LanguageCodeStyleSettingsProvider.getLanguageName(lang);
            JBMenuItem langItem = new JBMenuItem(langName);
            langItem.addActionListener(__ -> this.applyLanguageSettings(lang));
            parentMenu.add((Component)langItem);
        }
    }

    private void fillPredefinedStyles(JComponent parentMenu) {
        for (PredefinedCodeStyle predefinedCodeStyle : this.myPredefinedCodeStyles) {
            JBMenuItem predefinedItem = new JBMenuItem(predefinedCodeStyle.getName());
            parentMenu.add((Component)predefinedItem);
            predefinedItem.addActionListener(__ -> this.applyPredefinedStyle(predefinedCodeStyle.getName()));
        }
    }

    protected void addPredefinedCodeStyleListener(@NotNull PredefinedCodeStyleListener listener2) {
        if (listener2 == null) {
            TabbedLanguageCodeStylePanel.$$$reportNull$$$0(3);
        }
        this.myPredefinedCodeStyleEventDispatcher.addListener(listener2, this);
    }

    private PredefinedCodeStyle[] getPredefinedStyles() {
        Language language = this.getDefaultLanguage();
        if (language == null) {
            return PredefinedCodeStyle.EMPTY_ARRAY;
        }
        PredefinedCodeStyle[] predefinedStyles = PredefinedCodeStyle.EP_NAME.getExtensions();
        PredefinedCodeStyle[] styles = (PredefinedCodeStyle[])Arrays.stream(predefinedStyles).filter(s -> s.isApplicableToLanguage(language)).toArray(PredefinedCodeStyle[]::new);
        if (styles.length >= 2 && ContainerUtil.exists(styles, s -> s instanceof Weighted)) {
            Arrays.sort(styles, WEIGHTED_COMPARATOR);
        }
        return styles;
    }

    private void applyLanguageSettings(Language lang) {
        Project currProject = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        CodeStyleSettings rootSettings = CodeStyle.getSettings((Project)currProject);
        CodeStyleSettings targetSettings = this.getSettings();
        this.applyLanguageSettings(lang, rootSettings, targetSettings);
        this.reset(targetSettings);
        this.onSomethingChanged();
    }

    protected void applyLanguageSettings(Language lang, CodeStyleSettings rootSettings, CodeStyleSettings targetSettings) {
        CommonCodeStyleSettings sourceCommonSettings = rootSettings.getCommonSettings(lang);
        CommonCodeStyleSettings targetCommonSettings = targetSettings.getCommonSettings(this.getDefaultLanguage());
        targetCommonSettings.copyFrom(sourceCommonSettings);
    }

    private void applyPredefinedStyle(String styleName) {
        for (PredefinedCodeStyle style : this.myPredefinedCodeStyles) {
            if (!style.getName().equals(styleName)) continue;
            this.applyPredefinedSettings(style);
            this.myPredefinedCodeStyleEventDispatcher.getMulticaster().styleApplied(style);
        }
    }

    @Nullable
    private LanguageCodeStyleSettingsProvider getProvider() {
        if (this.myProviderRef == null) {
            this.myProviderRef = Ref.create(LanguageCodeStyleSettingsProvider.forLanguage(this.getDefaultLanguage()));
        }
        return this.myProviderRef.get();
    }

    @Override
    @NotNull
    public OptionsContainingConfigurable getOptionIndexer() {
        return new OptionsContainingConfigurable(){

            @NotNull
            public Map<String, Set<String>> processListOptionsWithPaths() {
                HashMap<String, Set<String>> result2 = new HashMap<String, Set<String>>();
                for (CodeStyleAbstractPanel tab : TabbedLanguageCodeStylePanel.this.myTabs) {
                    result2.put(tab.getTabTitle(), tab.processListOptions());
                }
                HashMap<String, Set<String>> hashMap = result2;
                if (hashMap == null) {
                    4.$$$reportNull$$$0(0);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/TabbedLanguageCodeStylePanel$4", "processListOptionsWithPaths"));
            }
        };
    }

    public void setListener(@Nullable TabChangeListener listener2) {
        this.myListener = listener2;
    }

    public void changeTab(@NotNull String tabTitle) {
        if (tabTitle == null) {
            TabbedLanguageCodeStylePanel.$$$reportNull$$$0(4);
        }
        this.myTabbedPane.setSelectedTitle(tabTitle);
    }

    @Override
    public void highlightOptions(@NotNull String searchString) {
        if (searchString == null) {
            TabbedLanguageCodeStylePanel.$$$reportNull$$$0(5);
        }
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.highlightOptions(searchString);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/TabbedLanguageCodeStylePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabTitle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/TabbedLanguageCodeStylePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedCodeStyleListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "changeTab";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlightOptions";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface TabChangeListener {
        public void tabChanged(@NotNull TabbedLanguageCodeStylePanel var1, @NotNull String var2);
    }

    protected class MyIndentOptionsWrapper
    extends CodeStyleAbstractPanel {
        private final IndentOptionsEditor myEditor;
        private final JPanel myTopPanel;

        protected MyIndentOptionsWrapper(CodeStyleSettings settings, IndentOptionsEditor editor2) {
            super(settings);
            this.myTopPanel = new JPanel(new BorderLayout());
            JPanel leftPanel = new JPanel(new BorderLayout());
            this.myTopPanel.add((Component)leftPanel, "West");
            JPanel rightPanel = new JPanel();
            this.installPreviewPanel(rightPanel);
            this.myEditor = editor2;
            if (this.myEditor != null) {
                JPanel panel2 = this.myEditor.createPanel();
                panel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)panel2, (boolean)true);
                scroll.setPreferredSize(new Dimension(panel2.getPreferredSize().width + scroll.getVerticalScrollBar().getPreferredSize().width + 5, -1));
                leftPanel.add((Component)scroll, "Center");
            }
            this.myTopPanel.add((Component)rightPanel, "Center");
        }

        @Override
        protected int getRightMargin() {
            return TabbedLanguageCodeStylePanel.this.getProvider() != null ? TabbedLanguageCodeStylePanel.this.getProvider().getRightMargin(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) : -1;
        }

        @Override
        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme, null);
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            Language language = TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
            LanguageFileType languageFileType = language != null ? language.getAssociatedFileType() : FileTypes.PLAIN_TEXT;
            if (languageFileType == null) {
                MyIndentOptionsWrapper.$$$reportNull$$$0(0);
            }
            return languageFileType;
        }

        @Override
        protected String getPreviewText() {
            return TabbedLanguageCodeStylePanel.this.getProvider() != null ? TabbedLanguageCodeStylePanel.this.getProvider().getCodeSample(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) : "";
        }

        @Override
        protected String getFileExt() {
            String ext;
            if (TabbedLanguageCodeStylePanel.this.getProvider() != null && (ext = TabbedLanguageCodeStylePanel.this.getProvider().getFileExt()) != null) {
                return ext;
            }
            return super.getFileExt();
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null) {
                return;
            }
            this.myEditor.apply(settings, indentOptions);
        }

        @Override
        public boolean isModified(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null) {
                return false;
            }
            return this.myEditor.isModified(settings, indentOptions);
        }

        @Override
        public JComponent getPanel() {
            return this.myTopPanel;
        }

        @Override
        protected void resetImpl(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null && TabbedLanguageCodeStylePanel.this.getProvider() != null) {
                this.myEditor.setEnabled(false);
                indentOptions = settings.getIndentOptions((FileType)TabbedLanguageCodeStylePanel.this.getProvider().getLanguage().getAssociatedFileType());
            }
            assert (indentOptions != null);
            this.myEditor.reset(settings, indentOptions);
        }

        @Nullable
        protected CommonCodeStyleSettings.IndentOptions getIndentOptions(CodeStyleSettings settings) {
            return settings.getCommonSettings(this.getDefaultLanguage()).getIndentOptions();
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }

        @Override
        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string2 = ApplicationBundle.message((String)"title.tabs.and.indents", (Object[])new Object[0]);
            if (string2 == null) {
                MyIndentOptionsWrapper.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        public void onSomethingChanged() {
            super.onSomethingChanged();
            this.myEditor.setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/application/options/TabbedLanguageCodeStylePanel$MyIndentOptionsWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabTitle";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class CodeStyleConfigurableWrapperPanel
    extends CodeStyleAbstractPanel {
        private final Configurable myConfigurable;
        private JComponent myComponent;

        CodeStyleConfigurableWrapperPanel(@NotNull Configurable configurable2, CodeStyleSettings settings) {
            if (configurable2 == null) {
                CodeStyleConfigurableWrapperPanel.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                CodeStyleConfigurableWrapperPanel.$$$reportNull$$$0(1);
            }
            super(settings);
            this.myConfigurable = configurable2;
            Disposer.register(this, () -> this.myConfigurable.disposeUIResources());
        }

        @Override
        protected int getRightMargin() {
            return 0;
        }

        @Override
        @Nullable
        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return null;
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            Language language = this.getDefaultLanguage();
            LanguageFileType languageFileType = language != null ? language.getAssociatedFileType() : FileTypes.PLAIN_TEXT;
            if (languageFileType == null) {
                CodeStyleConfigurableWrapperPanel.$$$reportNull$$$0(2);
            }
            return languageFileType;
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }

        @Override
        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string2 = this.myConfigurable.getDisplayName();
            if (string2 == null) {
                CodeStyleConfigurableWrapperPanel.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        @Override
        public void apply(CodeStyleSettings settings) throws ConfigurationException {
            if (this.myConfigurable instanceof CodeStyleConfigurable) {
                ((CodeStyleConfigurable)this.myConfigurable).apply(settings);
            } else {
                this.myConfigurable.apply();
            }
        }

        @Override
        public boolean isModified(CodeStyleSettings settings) {
            return this.myConfigurable.isModified();
        }

        @Override
        @Nullable
        public JComponent getPanel() {
            if (this.myComponent == null) {
                this.myComponent = this.myConfigurable.createComponent();
            }
            return this.myComponent;
        }

        @Override
        protected void resetImpl(CodeStyleSettings settings) {
            if (this.myConfigurable instanceof CodeStyleConfigurable) {
                ((CodeStyleConfigurable)this.myConfigurable).reset(settings);
            } else {
                this.myConfigurable.reset();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/TabbedLanguageCodeStylePanel$CodeStyleConfigurableWrapperPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/TabbedLanguageCodeStylePanel$CodeStyleConfigurableWrapperPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class MyWrappingAndBracesPanel
    extends WrappingAndBracesPanel {
        public MyWrappingAndBracesPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }
    }

    class MyBlankLinesPanel
    extends CodeStyleBlankLinesPanel {
        MyBlankLinesPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }
    }

    protected class MySpacesPanel
    extends CodeStyleSpacesPanel {
        public MySpacesPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected boolean shouldHideOptions() {
            return true;
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }
    }

    private static final class WeightedComparator
    implements Comparator<Object> {
        private WeightedComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            double w1 = o1 instanceof Weighted ? ((Weighted)o1).getWeight() : Double.POSITIVE_INFINITY;
            double w2 = o2 instanceof Weighted ? ((Weighted)o2).getWeight() : Double.POSITIVE_INFINITY;
            return Double.compare(w1, w2);
        }
    }
}

