/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SortedComboBoxModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesComboBox
extends ComboBox<Module> {
    private final SortedComboBoxModel<Module> myModel;
    private boolean myAllowEmptySelection;

    public ModulesComboBox() {
        this(new SortedComboBoxModel<Module>(ModulesAlphaComparator.INSTANCE));
    }

    private ModulesComboBox(SortedComboBoxModel<Module> model2) {
        super(model2);
        this.myModel = model2;
        this.setRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer()));
        this.setSwingPopup(false);
    }

    public void allowEmptySelection(@NotNull @NlsContexts.ListItem String emptySelectionText) {
        if (emptySelectionText == null) {
            ModulesComboBox.$$$reportNull$$$0(0);
        }
        this.myAllowEmptySelection = true;
        this.myModel.add(null);
        this.setRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer(emptySelectionText)));
    }

    public void setModules(@NotNull Collection<? extends Module> modules2) {
        if (modules2 == null) {
            ModulesComboBox.$$$reportNull$$$0(1);
        }
        this.myModel.setAll(modules2);
        if (this.myAllowEmptySelection) {
            this.myModel.add(null);
        }
    }

    public void fillModules(@NotNull Project project2) {
        if (project2 == null) {
            ModulesComboBox.$$$reportNull$$$0(2);
        }
        this.fillModules(project2, null);
    }

    public void fillModules(@NotNull Project project2, @Nullable ModuleType moduleType) {
        if (project2 == null) {
            ModulesComboBox.$$$reportNull$$$0(3);
        }
        Module[] allModules = ModuleManager.getInstance(project2).getModules();
        if (moduleType == null) {
            this.setModules(Arrays.asList(allModules));
        } else {
            ArrayList<Module> modules2 = new ArrayList<Module>();
            for (Module module : allModules) {
                if (!moduleType.equals((Object)ModuleType.get((Module)module))) continue;
                modules2.add(module);
            }
            this.setModules(modules2);
        }
    }

    public void setSelectedModule(@Nullable Module module) {
        this.myModel.setSelectedItem(module);
    }

    @Nullable
    public Module getSelectedModule() {
        return this.myModel.getSelectedItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptySelectionText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/ModulesComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "allowEmptySelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setModules";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fillModules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

