/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleAwareProjectConfigurable<T extends UnnamedConfigurable>
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final Project myProject;
    private final @NlsContexts.ConfigurableName String myDisplayName;
    private final String myHelpTopic;
    private final Map<Module, AtomicNotNullLazyValue<T>> myConfigurablesProviders;
    private static final String PROJECT_ITEM_KEY = "thisisnotthemoduleyouarelookingfor";

    public ModuleAwareProjectConfigurable(@NotNull Project project2, @NlsContexts.ConfigurableName String displayName, @NonNls String helpTopic) {
        if (project2 == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(0);
        }
        this.myConfigurablesProviders = new HashMap<Module, AtomicNotNullLazyValue<T>>();
        this.myProject = project2;
        this.myDisplayName = displayName;
        this.myHelpTopic = helpTopic;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpTopic() {
        return this.myHelpTopic;
    }

    protected boolean isSuitableForModule(@NotNull Module module) {
        if (module == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(1);
        }
        return true;
    }

    public JComponent createComponent() {
        Object configurable2;
        if (this.myProject.isDefault() && (configurable2 = this.createDefaultProjectConfigurable()) != null) {
            AtomicNotNullLazyValue<UnnamedConfigurable> projectConfigurableProvider = AtomicNotNullLazyValue.createValue(() -> configurable2);
            this.myConfigurablesProviders.put(null, projectConfigurableProvider);
            return projectConfigurableProvider.getValue().createComponent();
        }
        List<Module> modules2 = ContainerUtil.filter(ModuleAttachProcessor.getSortedModules(this.myProject), module -> this.isSuitableForModule((Module)module));
        Object projectConfigurable = this.createProjectConfigurable();
        if (modules2.size() == 1 && projectConfigurable == null) {
            Module module2 = modules2.get(0);
            AtomicNotNullLazyValue<UnnamedConfigurable> onlyModuleConfigurableProvider = AtomicNotNullLazyValue.createValue(() -> this.createModuleConfigurable(module2));
            this.myConfigurablesProviders.put(module2, onlyModuleConfigurableProvider);
            return onlyModuleConfigurableProvider.getValue().createComponent();
        }
        Splitter splitter = new Splitter(false, 0.25f);
        CollectionListModel<Module> listDataModel = new CollectionListModel<Module>(modules2);
        JBList moduleList = new JBList(listDataModel);
        new ListSpeedSearch((JList)moduleList, o -> o == null ? this.getProjectConfigurableItemName() : o.getName());
        moduleList.setSelectionMode(0);
        moduleList.setCellRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer(){

            @Override
            public void customize(@NotNull JList<? extends Module> list2, Module module, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    this.setText(ModuleAwareProjectConfigurable.this.getProjectConfigurableItemName());
                    this.setIcon(ModuleAwareProjectConfigurable.this.getProjectConfigurableItemIcon());
                } else {
                    super.customize(list2, module, index, selected, hasFocus);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/ModuleAwareProjectConfigurable$1", "customize"));
            }
        }));
        splitter.setFirstComponent((JComponent)new JBScrollPane((Component)moduleList));
        CardLayout layout = new CardLayout();
        JPanel cardPanel = new JPanel(layout);
        splitter.setSecondComponent(cardPanel);
        if (projectConfigurable != null) {
            this.myConfigurablesProviders.put(null, AtomicNotNullLazyValue.createValue(() -> projectConfigurable));
            JComponent component2 = projectConfigurable.createComponent();
            if (component2 != null) {
                cardPanel.add((Component)component2, PROJECT_ITEM_KEY);
                listDataModel.add(0, null);
            }
        }
        for (Module module3 : modules2) {
            this.myConfigurablesProviders.put(module3, AtomicNotNullLazyValue.createValue(() -> {
                T configurable2 = this.createModuleConfigurable(module3);
                JComponent component2 = configurable2.createComponent();
                if (component2 == null) {
                    component2 = new JPanel();
                }
                cardPanel.add((Component)component2, module3.getName());
                configurable2.reset();
                return configurable2;
            }));
        }
        moduleList.addListSelectionListener(__ -> this.showModuleConfigurable(layout, cardPanel, (Module)moduleList.getSelectedValue()));
        if (moduleList.getItemsCount() > 0) {
            moduleList.setSelectedIndex(0);
            this.showModuleConfigurable(layout, cardPanel, listDataModel.getElementAt(0));
        }
        return splitter;
    }

    private void showModuleConfigurable(@NotNull CardLayout layout, @NotNull JPanel cardPanel, @Nullable Module selectedModule) {
        if (layout == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(2);
        }
        if (cardPanel == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(3);
        }
        this.myConfigurablesProviders.get(selectedModule).getValue();
        layout.show(cardPanel, selectedModule == null ? PROJECT_ITEM_KEY : selectedModule.getName());
    }

    @Nullable
    protected T createDefaultProjectConfigurable() {
        return null;
    }

    @Nullable
    protected T createProjectConfigurable() {
        return null;
    }

    @NotNull
    @NlsContexts.Label
    protected String getProjectConfigurableItemName() {
        String string2 = this.myProject.getName();
        if (string2 == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Nullable
    protected Icon getProjectConfigurableItemIcon() {
        return AllIcons.Nodes.Project;
    }

    @NotNull
    protected abstract T createModuleConfigurable(Module var1);

    public boolean isModified() {
        for (AtomicNotNullLazyValue<T> configurableProvider : this.myConfigurablesProviders.values()) {
            if (!configurableProvider.isComputed() || !((UnnamedConfigurable)configurableProvider.getValue()).isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (AtomicNotNullLazyValue<T> configurableProvider : this.myConfigurablesProviders.values()) {
            if (!configurableProvider.isComputed()) continue;
            ((UnnamedConfigurable)configurableProvider.getValue()).apply();
        }
    }

    public void reset() {
        for (AtomicNotNullLazyValue<T> configurableProvider : this.myConfigurablesProviders.values()) {
            if (!configurableProvider.isComputed()) continue;
            ((UnnamedConfigurable)configurableProvider.getValue()).reset();
        }
    }

    public void disposeUIResources() {
        for (AtomicNotNullLazyValue<T> configurableProvider : this.myConfigurablesProviders.values()) {
            if (!configurableProvider.isComputed()) continue;
            ((UnnamedConfigurable)configurableProvider.getValue()).disposeUIResources();
        }
        this.myConfigurablesProviders.clear();
    }

    @NotNull
    public String getId() {
        String string2 = this.getClass().getName();
        if (string2 == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    protected final Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(6);
        }
        return project2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cardPanel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/ModuleAwareProjectConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/ModuleAwareProjectConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfigurableItemName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForModule";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showModuleConfigurable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

