/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.components.fields.IntegerField;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentOptionsEditor
extends OptionGroup
implements CodeStyleSettingsCustomizable {
    private JTextField myIndentField;
    private JCheckBox myCbUseTab;
    private JTextField myTabSizeField;
    private JLabel myTabSizeLabel;
    private JLabel myIndentLabel;
    @Nullable
    private final LanguageCodeStyleSettingsProvider myProvider;

    public IndentOptionsEditor() {
        this(null);
    }

    public IndentOptionsEditor(@Nullable LanguageCodeStyleSettingsProvider provider2) {
        this.myProvider = provider2;
    }

    public JPanel createPanel() {
        this.addComponents();
        if (this.myProvider != null) {
            this.myProvider.customizeSettings(this, LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS);
        }
        return super.createPanel();
    }

    protected void addComponents() {
        this.addTabOptions();
        this.addTabSizeField();
        this.addIndentField();
    }

    protected void addIndentField() {
        this.myIndentField = this.createIndentTextField(IndentOptionsEditor.getIndentLabel(), 0, 32, 4);
        this.myIndentLabel = new JLabel(IndentOptionsEditor.getIndentLabel());
        this.add(this.myIndentLabel, this.myIndentField);
    }

    protected void addTabSizeField() {
        this.myTabSizeField = this.createIndentTextField(IndentOptionsEditor.getTabSizeLabel(), 1, 16, 4);
        this.myTabSizeLabel = new JLabel(IndentOptionsEditor.getTabSizeLabel());
        this.add(this.myTabSizeLabel, this.myTabSizeField);
    }

    @Deprecated(forRemoval=true)
    protected JTextField createIndentTextField() {
        return this.createIndentTextField(null, Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
    }

    protected IntegerField createIndentTextField(@Nullable String valueName, int minSize, int maxSize, int defaultValue) {
        IntegerField field = new IntegerField(valueName, minSize, maxSize);
        field.setDefaultValue(Integer.valueOf(defaultValue));
        field.setColumns(4);
        if (defaultValue < 0) {
            field.setCanBeEmpty(true);
        }
        field.setMinimumSize(field.getPreferredSize());
        return field;
    }

    protected void addTabOptions() {
        this.myCbUseTab = new JCheckBox(ApplicationBundle.message((String)"checkbox.indent.use.tab.character", (Object[])new Object[0]));
        this.add(this.myCbUseTab);
    }

    @Override
    public void showAllStandardOptions() {
        this.setVisible(true);
    }

    @Override
    public void showStandardOptions(String ... optionNames) {
        this.setVisible(false);
        for (String optionName : optionNames) {
            if (CodeStyleSettingsCustomizable.IndentOption.INDENT_SIZE.toString().equals(optionName)) {
                this.myIndentLabel.setVisible(true);
                this.myIndentField.setVisible(true);
                continue;
            }
            if (CodeStyleSettingsCustomizable.IndentOption.TAB_SIZE.toString().equals(optionName)) {
                this.myTabSizeField.setVisible(true);
                this.myTabSizeLabel.setVisible(true);
                continue;
            }
            if (!CodeStyleSettingsCustomizable.IndentOption.USE_TAB_CHARACTER.toString().equals(optionName)) continue;
            this.myCbUseTab.setVisible(true);
        }
    }

    protected static boolean isFieldModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    protected static boolean isFieldModified(JTextField textField, int value) {
        if (textField instanceof IntegerField) {
            return ((IntegerField)textField).getValue() != value;
        }
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        boolean isModified = IndentOptionsEditor.isFieldModified(this.myTabSizeField, options.TAB_SIZE);
        isModified |= IndentOptionsEditor.isFieldModified(this.myCbUseTab, options.USE_TAB_CHARACTER);
        return isModified |= IndentOptionsEditor.isFieldModified(this.myIndentField, options.INDENT_SIZE);
    }

    protected int getUIIndent() {
        assert (this.myIndentField instanceof IntegerField);
        return ((IntegerField)this.myIndentField).getValue();
    }

    protected int getUITabSize() {
        assert (this.myTabSizeField instanceof IntegerField);
        return ((IntegerField)this.myTabSizeField).getValue();
    }

    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        options.INDENT_SIZE = this.getUIIndent();
        options.TAB_SIZE = this.getUITabSize();
        options.USE_TAB_CHARACTER = this.myCbUseTab.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            IndentOptionsEditor.$$$reportNull$$$0(0);
        }
        if (options == null) {
            IndentOptionsEditor.$$$reportNull$$$0(1);
        }
        ((IntegerField)this.myTabSizeField).setValue(Integer.valueOf(options.TAB_SIZE));
        this.myCbUseTab.setSelected(options.USE_TAB_CHARACTER);
        ((IntegerField)this.myIndentField).setValue(Integer.valueOf(options.INDENT_SIZE));
    }

    @Deprecated(forRemoval=true)
    protected int getFieldValue(JTextField field, int minValue, int defValue) {
        if (field instanceof IntegerField) {
            return ((IntegerField)field).getValue();
        }
        try {
            return Math.max(Integer.parseInt(field.getText()), minValue);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public void setEnabled(boolean enabled) {
        this.myIndentField.setEnabled(enabled);
        this.myIndentLabel.setEnabled(enabled);
        this.myTabSizeField.setEnabled(enabled);
        this.myTabSizeLabel.setEnabled(enabled);
        this.myCbUseTab.setEnabled(enabled);
    }

    protected void setVisible(boolean visible) {
        this.myIndentField.setVisible(visible);
        this.myIndentLabel.setVisible(visible);
        this.myTabSizeField.setVisible(visible);
        this.myTabSizeLabel.setVisible(visible);
        this.myCbUseTab.setVisible(visible);
    }

    @NlsContexts.Label
    private static String getIndentLabel() {
        return ApplicationBundle.message((String)"editbox.indent.indent", (Object[])new Object[0]);
    }

    @NlsContexts.Label
    private static String getTabSizeLabel() {
        return ApplicationBundle.message((String)"editbox.indent.tab.size", (Object[])new Object[0]);
    }

    protected final boolean isUseTabsSelected() {
        return this.myCbUseTab.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
        }
        objectArray[1] = "com/intellij/application/options/IndentOptionsEditor";
        objectArray[2] = "reset";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

