/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.CollectorBasedRoot;
import com.intellij.analysis.problemsView.toolWindow.ProblemsTreeModel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanelProvider;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewTab;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewProjectErrorsPanelProvider;", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewPanelProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ACTION_IDS", "", "", "create", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewTab;", "Companion", "intellij.platform.lang.impl"})
public final class ProblemsViewProjectErrorsPanelProvider
implements ProblemsViewPanelProvider {
    private final List<String> ACTION_IDS;
    private final Project project;
    @NotNull
    public static final String ID = "ProjectErrors";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ProblemsViewTab create() {
        ProblemsViewState state = ProblemsViewState.Companion.getInstance(this.project);
        ProblemsViewPanel panel2 = new ProblemsViewPanel(this.project, ID, state, ProblemsViewBundle.messagePointer("problems.view.project", new Object[0]));
        ProblemsTreeModel problemsTreeModel = panel2.getTreeModel();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)problemsTreeModel), (String)"panel.treeModel");
        problemsTreeModel.setRoot(new CollectorBasedRoot(panel2));
        Tree tree = panel2.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"panel.tree");
        StatusText statusText = tree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"panel.tree.emptyText");
        StatusText status = statusText;
        status.setText(ProblemsViewBundle.message("problems.view.project.empty", new Object[0]));
        if (Registry.is("ide.problems.view.empty.status.actions")) {
            String string2 = ProblemsViewBundle.message("problems.view.project.empty.or", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProblemsViewBundle.messa\u2026s.view.project.empty.or\")");
            String or = string2;
            int index = 0;
            for (String id2 : this.ACTION_IDS) {
                String shortcut;
                AnAction action2;
                if (ActionUtil.getAction((String)id2) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"ActionUtil.getAction(id) ?: continue");
                String text2 = action2.getTemplateText();
                CharSequence charSequence = text2;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                if (index == 0) {
                    status.appendText(".");
                    status.appendLine("");
                } else {
                    status.appendText(" ").appendText(or).appendText(" ");
                }
                status.appendText(text2, SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, new ActionListener(action2, panel2){
                    final /* synthetic */ AnAction $action;
                    final /* synthetic */ ProblemsViewPanel $panel;

                    public final void actionPerformed(@Nullable ActionEvent event) {
                        ActionUtil.invokeAction((AnAction)this.$action, (Component)((Component)((Object)this.$panel)), (String)"ProblemsView", null, null);
                    }
                    {
                        this.$action = anAction;
                        this.$panel = problemsViewPanel;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2), (String)"KeymapUtil.getFirstKeyboardShortcutText(action)");
                if (!StringsKt.isBlank((CharSequence)shortcut)) {
                    status.appendText(" (").appendText(shortcut).appendText(")");
                }
                ++index;
            }
        }
        return panel2;
    }

    public ProblemsViewProjectErrorsPanelProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.ACTION_IDS = CollectionsKt.listOf((Object[])new String[]{"CompileDirty", "InspectCode"});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewProjectErrorsPanelProvider$Companion;", "", "()V", "ID", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

