/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.toolWindow.HighlightingProblem;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020\u0004H\u0016J\b\u0010'\u001a\u00020\tH\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/ProblemNode;", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "parent", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "problem", "Lcom/intellij/analysis/problemsView/Problem;", "(Lcom/intellij/analysis/problemsView/toolWindow/Node;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/analysis/problemsView/Problem;)V", "<set-?>", "", "column", "getColumn", "()I", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "line", "getLine", "getProblem", "()Lcom/intellij/analysis/problemsView/Problem;", "severity", "getSeverity", "", "text", "getText", "()Ljava/lang/String;", "equals", "", "other", "", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "getVirtualFile", "hashCode", "update", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.lang.impl"})
public final class ProblemNode
extends Node {
    @NotNull
    private String text;
    private int line;
    private int column;
    private int severity;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Problem problem;

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public final int getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public OpenFileDescriptor getDescriptor() {
        OpenFileDescriptor openFileDescriptor;
        Project project2 = this.getProject();
        if (project2 != null) {
            Project project3;
            Project it = project3 = project2;
            boolean bl = false;
            openFileDescriptor = new OpenFileDescriptor(it, this.file, this.line, this.column);
        } else {
            openFileDescriptor = null;
        }
        return openFileDescriptor;
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.ALWAYS;
    }

    @Override
    @NotNull
    public String getName() {
        return this.text;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.file;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        Navigatable navigatable;
        Problem problem = this.problem;
        if (!(problem instanceof Navigatable)) {
            problem = null;
        }
        if ((navigatable = (Navigatable)((Object)problem)) == null) {
            navigatable = (Navigatable)((Object)this.getDescriptor());
        }
        return navigatable;
    }

    @Override
    protected void update(@NotNull Project project2, @NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        this.text = this.problem.getText();
        Problem problem = this.problem;
        if (!(problem instanceof FileProblem)) {
            problem = null;
        }
        FileProblem fileProblem = (FileProblem)problem;
        this.line = fileProblem != null ? fileProblem.getLine() : -1;
        Problem problem2 = this.problem;
        if (!(problem2 instanceof FileProblem)) {
            problem2 = null;
        }
        FileProblem fileProblem2 = (FileProblem)problem2;
        this.column = fileProblem2 != null ? fileProblem2.getColumn() : -1;
        Problem problem3 = this.problem;
        if (!(problem3 instanceof HighlightingProblem)) {
            problem3 = null;
        }
        HighlightingProblem highlightingProblem = (HighlightingProblem)problem3;
        this.severity = highlightingProblem != null ? highlightingProblem.getSeverity() : -1;
        presentation2.addText(this.text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation2.setIcon(this.problem.getIcon());
        presentation2.setTooltip(this.problem.getDescription());
        if (this.line >= 0) {
            presentation2.addText(" :" + (this.line + 1), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public int hashCode() {
        return Objects.hash(this.getProject(), this.problem);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (!(object2 instanceof ProblemNode)) {
            object2 = null;
        }
        ProblemNode problemNode = (ProblemNode)((Object)object2);
        if (problemNode == null) {
            return false;
        }
        ProblemNode that = problemNode;
        return Intrinsics.areEqual((Object)that.getProject(), (Object)this.getProject()) && Intrinsics.areEqual((Object)that.problem, (Object)this.problem);
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final Problem getProblem() {
        return this.problem;
    }

    public ProblemNode(@NotNull Node parent, @NotNull VirtualFile file2, @NotNull Problem problem) {
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        super(parent);
        this.file = file2;
        this.problem = problem;
        this.text = "";
    }
}

