/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.CommonBundle;
import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.analysis.problemsView.toolWindow.HighlightingFileRoot;
import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel;
import com.intellij.analysis.problemsView.toolWindow.HighlightingProblem;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewTab;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewToolWindowUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AsyncDescriptionSupplier;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnimatedIcon;
import com.intellij.xml.util.XmlStringUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001:B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010/\u001a\u00020\fH\u0002J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\fH\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010\u001d\u001a\u000209H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000eR\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\u0004\u0018\u00010%8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000eR\u0014\u0010,\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0012\u00a8\u0006;"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "provider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "(Lcom/intellij/analysis/problemsView/ProblemsProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;)V", "asyncDescriptionRequested", "Ljava/util/concurrent/atomic/AtomicBoolean;", "column", "", "getColumn", "()I", "description", "", "getDescription", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "group", "getGroup", "getHighlighter", "()Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "getInfo", "()Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "line", "getLine", "loading", "position", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "getPosition", "()Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "getProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "severity", "getSeverity", "text", "getText", "computePosition", "offset", "equals", "", "other", "", "level", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "hashCode", "requestAsyncDescription", "", "Lcom/intellij/codeInsight/daemon/impl/AsyncDescriptionSupplier;", "CachedPosition", "intellij.platform.lang.impl"})
public final class HighlightingProblem
implements FileProblem {
    private AtomicBoolean asyncDescriptionRequested;
    private AtomicBoolean loading;
    private CachedPosition position;
    @NotNull
    private final ProblemsProvider provider;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final RangeHighlighterEx highlighter;

    private final Icon getIcon(HighlightDisplayLevel level) {
        CharSequence charSequence = this.getText();
        return charSequence.length() == 0 || this.asyncDescriptionRequested.get() ? (Icon)AnimatedIcon.Default.INSTANCE : (this.getSeverity() >= level.getSeverity().myVal ? level.getIcon() : null);
    }

    @Nullable
    public final HighlightInfo getInfo() {
        HighlightInfo info = HighlightInfo.fromRangeHighlighter((RangeHighlighter)this.highlighter);
        if (info instanceof AsyncDescriptionSupplier) {
            this.requestAsyncDescription((AsyncDescriptionSupplier)((Object)info));
        }
        return info;
    }

    private final void requestAsyncDescription(AsyncDescriptionSupplier info) {
        if (!this.asyncDescriptionRequested.compareAndSet(false, true)) {
            return;
        }
        this.loading.set(true);
        info.requestDescription().onSuccess(new Consumer(this){
            final /* synthetic */ HighlightingProblem this$0;

            public final void accept(String it) {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ requestAsyncDescription.1 this$0;

                    public final void run() {
                        HighlightingPanel panel2;
                        Disposable disposable;
                        ProblemsViewTab problemsViewTab = ProblemsViewToolWindowUtils.INSTANCE.getTabById(this.this$0.this$0.getProvider().getProject(), "CurrentFile");
                        if (!(problemsViewTab instanceof HighlightingPanel)) {
                            problemsViewTab = null;
                        }
                        if ((disposable = (panel2 = (HighlightingPanel)problemsViewTab)) != null && (disposable = ((HighlightingPanel)disposable).getCurrentRoot$intellij_platform_lang_impl()) != null) {
                            ((HighlightingFileRoot)disposable).problemUpdated(this.this$0.this$0);
                        }
                        HighlightingProblem.access$getLoading$p(this.this$0.this$0).set(false);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = highlightingProblem;
            }
        });
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Object object;
        Object object2;
        HighlightInfo highlightInfo = this.getInfo();
        HighlightSeverity severity = highlightInfo == null ? HighlightSeverity.INFORMATION : highlightInfo.getSeverity();
        Object object3 = HighlightDisplayLevel.find(severity);
        if (object3 == null || (object3 = ((HighlightDisplayLevel)object3).getIcon()) == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.ERROR");
            object3 = object2 = this.getIcon(highlightDisplayLevel);
        }
        if (object3 == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.WARNING");
            object2 = object = this.getIcon(highlightDisplayLevel);
        }
        if (object2 == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.WEAK_WARNING");
            Icon icon2 = highlightDisplayLevel.getIcon();
            object = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"HighlightDisplayLevel.WEAK_WARNING.icon");
        }
        return object;
    }

    @Override
    @NotNull
    public String getText() {
        Object object;
        int pos;
        Object text2;
        block4: {
            int n;
            Object object2 = this.getInfo();
            if (object2 == null || (object2 = ((HighlightInfo)object2).getDescription()) == null) {
                String string2 = CommonBundle.getLoadingTreeNodeText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CommonBundle.getLoadingTreeNodeText()");
                return string2;
            }
            text2 = object2;
            CharSequence $this$indexOfFirst$iv = (CharSequence)text2;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!StringUtil.isLineBreak(it)) continue;
                n = index$iv;
                break block4;
            }
            n = pos = -1;
        }
        if (pos < 0 || StringsKt.startsWith((String)text2, (String)"<html>", (boolean)true)) {
            object = text2;
        } else {
            Object object3 = text2;
            int n = 0;
            String string3 = ((String)object3).substring(n, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string3 + "\u2026";
        }
        return object;
    }

    @Override
    @Nullable
    public String getGroup() {
        Object object = this.getInfo();
        if (object == null || (object = ((HighlightInfo)object).getInspectionToolId()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"info?.inspectionToolId ?: return null");
        Object id2 = object;
        return HighlightDisplayKey.getDisplayNameByKey(HighlightDisplayKey.findById((String)id2));
    }

    @Override
    @Nullable
    public String getDescription() {
        int n;
        Object text2;
        block3: {
            Object object = this.getInfo();
            if (object == null || (object = ((HighlightInfo)object).getDescription()) == null) {
                return null;
            }
            text2 = object;
            CharSequence charSequence = (CharSequence)text2;
            if (charSequence.length() == 0) {
                return null;
            }
            CharSequence $this$indexOfFirst$iv = (CharSequence)text2;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!StringUtil.isLineBreak(it)) continue;
                n = index$iv;
                break block3;
            }
            n = -1;
        }
        int pos = n;
        return pos < 0 || StringsKt.startsWith((String)text2, (String)"<html>", (boolean)true) ? null : "<html>" + StringUtil.join(StringUtil.splitByLines(XmlStringUtil.escapeString((String)text2)), "<br/>");
    }

    public final int getSeverity() {
        Object object = this.getInfo();
        return object != null && (object = ((HighlightInfo)object).getSeverity()) != null ? ((HighlightSeverity)object).myVal : -1;
    }

    public int hashCode() {
        return this.highlighter.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof HighlightingProblem && Intrinsics.areEqual((Object)((HighlightingProblem)other).highlighter, (Object)this.highlighter);
    }

    @Override
    public int getLine() {
        CachedPosition cachedPosition = this.getPosition();
        return cachedPosition != null ? cachedPosition.getLine() : -1;
    }

    @Override
    public int getColumn() {
        CachedPosition cachedPosition = this.getPosition();
        return cachedPosition != null ? cachedPosition.getColumn() : -1;
    }

    private final CachedPosition getPosition() {
        CachedPosition cachedPosition;
        HighlightInfo highlightInfo = this.getInfo();
        if (highlightInfo != null) {
            int n;
            int it = n = highlightInfo.getActualStartOffset();
            boolean bl = false;
            CachedPosition cachedPosition2 = this.position;
            if (cachedPosition2 == null || it != cachedPosition2.getOffset()) {
                this.position = this.computePosition(it);
            }
            cachedPosition = this.position;
        } else {
            cachedPosition = null;
        }
        return cachedPosition;
    }

    private final CachedPosition computePosition(int offset) {
        if (offset < 0) {
            return null;
        }
        Document document = ProblemsView.getDocument(this.getProvider().getProject(), this.getFile());
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"ProblemsView.getDocument\u2026ect, file) ?: return null");
        Document document2 = document;
        if (offset > document2.getTextLength()) {
            return null;
        }
        int line = document2.getLineNumber(offset);
        return new CachedPosition(offset, line, offset - document2.getLineStartOffset(line));
    }

    @Override
    @NotNull
    public ProblemsProvider getProvider() {
        return this.provider;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final RangeHighlighterEx getHighlighter() {
        return this.highlighter;
    }

    public HighlightingProblem(@NotNull ProblemsProvider provider2, @NotNull VirtualFile file2, @NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.provider = provider2;
        this.file = file2;
        this.highlighter = highlighter;
        this.asyncDescriptionRequested = new AtomicBoolean(false);
        this.loading = new AtomicBoolean(false);
    }

    public static final /* synthetic */ AtomicBoolean access$getLoading$p(HighlightingProblem $this) {
        return $this.loading;
    }

    public static final /* synthetic */ void access$setLoading$p(HighlightingProblem $this, AtomicBoolean atomicBoolean) {
        $this.loading = atomicBoolean;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "", "offset", "", "line", "column", "(III)V", "getColumn", "()I", "getLine", "getOffset", "intellij.platform.lang.impl"})
    private static final class CachedPosition {
        private final int offset;
        private final int line;
        private final int column;

        public final int getOffset() {
            return this.offset;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        public CachedPosition(int offset, int line, int column) {
            this.offset = offset;
            this.line = line;
            this.column = column;
        }
    }
}

