/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.ProblemsListener;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/CollectorBasedRoot;", "Lcom/intellij/analysis/problemsView/toolWindow/Root;", "panel", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel;", "(Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel;)V", "collector", "Lcom/intellij/analysis/problemsView/ProblemsCollector;", "(Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel;Lcom/intellij/analysis/problemsView/ProblemsCollector;)V", "getCollector", "()Lcom/intellij/analysis/problemsView/ProblemsCollector;", "getFileProblemCount", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileProblems", "", "Lcom/intellij/analysis/problemsView/Problem;", "getOtherProblemCount", "getOtherProblems", "getProblemCount", "getProblemFiles", "intellij.platform.lang.impl"})
public final class CollectorBasedRoot
extends Root {
    @NotNull
    private final ProblemsCollector collector;

    @Override
    public int getProblemCount() {
        return this.collector.getProblemCount();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getProblemFiles() {
        return this.collector.getProblemFiles();
    }

    @Override
    public int getFileProblemCount(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.collector.getFileProblemCount(file2);
    }

    @Override
    @NotNull
    public Collection<Problem> getFileProblems(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.collector.getFileProblems(file2);
    }

    @Override
    public int getOtherProblemCount() {
        return this.collector.getOtherProblemCount();
    }

    @Override
    @NotNull
    public Collection<Problem> getOtherProblems() {
        return this.collector.getOtherProblems();
    }

    @NotNull
    public final ProblemsCollector getCollector() {
        return this.collector;
    }

    public CollectorBasedRoot(@NotNull ProblemsViewPanel panel2, @NotNull ProblemsCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        super(panel2);
        this.collector = collector2;
    }

    public CollectorBasedRoot(@NotNull ProblemsViewPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Project project2 = panel2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"panel.project");
        this(panel2, ProblemsCollector.Companion.getInstance(project2));
        Project project3 = panel2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"panel.project");
        project3.getMessageBus().connect(this).subscribe(ProblemsListener.TOPIC, this);
    }
}

