/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.SimpleApplicationBootstrapperKt;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.idea.ApplicationLoader;
import com.intellij.idea.Main;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyBean;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.testFramework.UITestUtil;
import com.intellij.util.SystemProperties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0000\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"doLoadApp", "", "setupEventQueue", "Lkotlin/Function0;", "loadHeadlessAppInUnitTestMode", "intellij.platform.testFramework"})
public final class SimpleApplicationBootstrapperKt {
    public static final void loadHeadlessAppInUnitTestMode() {
        SimpleApplicationBootstrapperKt.doLoadApp((Function0<Unit>)((Function0)loadHeadlessAppInUnitTestMode.1.INSTANCE));
    }

    public static final void doLoadApp(@NotNull Function0<Unit> setupEventQueue) {
        Intrinsics.checkNotNullParameter(setupEventQueue, (String)"setupEventQueue");
        boolean isHeadless = true;
        if (Intrinsics.areEqual((Object)System.getProperty("java.awt.headless"), (Object)"false")) {
            isHeadless = false;
        } else {
            UITestUtil.setHeadlessProperty(true);
        }
        Main.setHeadlessInTestMode((boolean)isHeadless);
        PluginManagerCore.isUnitTestMode = true;
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        PluginManagerCore.scheduleDescriptorLoading();
        CompletableFuture<PluginSet> completableFuture = PluginManagerCore.getInitPluginFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"PluginManagerCore.getInitPluginFuture()");
        CompletableFuture<PluginSet> loadedModuleFuture = completableFuture;
        setupEventQueue.invoke();
        ApplicationImpl app = new ApplicationImpl(true, true, isHeadless, true);
        if (SystemProperties.getBooleanProperty("tests.assertOnMissedCache", true)) {
            RecursionManager.assertOnMissedCache((Disposable)app);
        }
        PluginSet pluginSet = null;
        try {
            PluginSet pluginSet2 = loadedModuleFuture.get(40L, TimeUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)pluginSet2, (String)"loadedModuleFuture.get(40, TimeUnit.SECONDS)");
            pluginSet = pluginSet2;
            app.registerComponents(pluginSet.getEnabledModules(), (Application)app, null, null);
            ApplicationLoader.initConfigurationStore((ApplicationImpl)app);
            RegistryKeyBean.Companion.addKeysFromPlugins();
            Registry.markAsLoaded();
            CompletableFuture preloadServiceFuture = ApplicationLoader.preloadServices$default(pluginSet.getEnabledModules(), (ComponentManagerImpl)((ComponentManagerImpl)app), (String)"", (boolean)false, (int)8, null);
            app.loadComponents();
            preloadServiceFuture.get(40L, TimeUnit.SECONDS);
            ForkJoinTask.invokeAll(ApplicationLoader.callAppInitialized((ApplicationImpl)app));
            StartUpMeasurer.setCurrentState(LoadingState.APP_STARTED);
            PersistentFS persistentFS = PersistentFS.getInstance();
            if (persistentFS == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl");
            }
            ((PersistentFSImpl)persistentFS).cleanPersistedContents();
        }
        catch (TimeoutException e) {
            throw (Throwable)new RuntimeException("Cannot preload services in 40 seconds: " + ThreadDumper.dumpThreadsToString(), e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        catch (InterruptedException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }
}

