/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.driver.android;

import android.database.Cursor;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.driver.android.AndroidCursor;
import app.cash.sqldelight.driver.android.AndroidStatement;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u001f\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u0004H\u0016J\u001f\u0010$\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020)H\u0016J-\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u0002H+0.0\u0014H\u0016\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0015H\u0016J\b\u00102\u001a\u00020\u0004H\u0016J\b\u00103\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\"\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lapp/cash/sqldelight/driver/android/AndroidQuery;", "Landroidx/sqlite/db/SupportSQLiteQuery;", "Lapp/cash/sqldelight/driver/android/AndroidStatement;", "sql", "", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "argCount", "", "windowSizeBytes", "", "<init>", "(Ljava/lang/String;Landroidx/sqlite/db/SupportSQLiteDatabase;ILjava/lang/Long;)V", "getSql", "()Ljava/lang/String;", "getArgCount", "()I", "Ljava/lang/Long;", "binds", "", "Lkotlin/Function1;", "Landroidx/sqlite/db/SupportSQLiteProgram;", "", "bindBytes", "index", "bytes", "", "bindLong", "long", "(ILjava/lang/Long;)V", "bindDouble", "double", "", "(ILjava/lang/Double;)V", "bindString", "string", "bindBoolean", "boolean", "", "(ILjava/lang/Boolean;)V", "execute", "", "executeQuery", "R", "mapper", "Lapp/cash/sqldelight/db/SqlCursor;", "Lapp/cash/sqldelight/db/QueryResult;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "bindTo", "statement", "toString", "close", "android-driver"})
@SourceDebugExtension(value={"SMAP\nAndroidSqliteDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSqliteDriver.kt\napp/cash/sqldelight/driver/android/AndroidQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1#2:353\n*E\n"})
final class AndroidQuery
implements SupportSQLiteQuery,
AndroidStatement {
    @NotNull
    private final String sql;
    @NotNull
    private final SupportSQLiteDatabase database;
    private final int argCount;
    @Nullable
    private final Long windowSizeBytes;
    @NotNull
    private final List<Function1<SupportSQLiteProgram, Unit>> binds;

    public AndroidQuery(@NotNull String sql, @NotNull SupportSQLiteDatabase database, int argCount, @Nullable Long windowSizeBytes) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.sql = sql;
        this.database = database;
        this.argCount = argCount;
        this.windowSizeBytes = windowSizeBytes;
        int n = this.getArgCount();
        AndroidQuery androidQuery = this;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(null);
        }
        androidQuery.binds = arrayList;
    }

    @NotNull
    public String getSql() {
        return this.sql;
    }

    public int getArgCount() {
        return this.argCount;
    }

    public void bindBytes(int index, @Nullable byte[] bytes) {
        this.binds.set(index, (Function1<SupportSQLiteProgram, Unit>)((Function1)arg_0 -> AndroidQuery.bindBytes$lambda$0(bytes, index, arg_0)));
    }

    public void bindLong(int index, @Nullable Long l) {
        this.binds.set(index, (Function1<SupportSQLiteProgram, Unit>)((Function1)arg_0 -> AndroidQuery.bindLong$lambda$0(l, index, arg_0)));
    }

    public void bindDouble(int index, @Nullable Double d) {
        this.binds.set(index, (Function1<SupportSQLiteProgram, Unit>)((Function1)arg_0 -> AndroidQuery.bindDouble$lambda$0(d, index, arg_0)));
    }

    public void bindString(int index, @Nullable String string) {
        this.binds.set(index, (Function1<SupportSQLiteProgram, Unit>)((Function1)arg_0 -> AndroidQuery.bindString$lambda$0(string, index, arg_0)));
    }

    public void bindBoolean(int index, @Nullable Boolean bl) {
        this.binds.set(index, (Function1<SupportSQLiteProgram, Unit>)((Function1)arg_0 -> AndroidQuery.bindBoolean$lambda$0(bl, index, arg_0)));
    }

    @NotNull
    public Void execute() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R executeQuery(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
        Object object;
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Closeable closeable = (Closeable)this.database.query((SupportSQLiteQuery)this);
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)closeable;
            boolean bl = false;
            object = ((QueryResult)mapper.invoke((Object)new AndroidCursor(cursor, this.windowSizeBytes))).getValue();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (R)object;
    }

    public void bindTo(@NotNull SupportSQLiteProgram statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Iterator<Function1<SupportSQLiteProgram, Unit>> iterator = this.binds.iterator();
        while (iterator.hasNext()) {
            Function1<SupportSQLiteProgram, Unit> action;
            Function1<SupportSQLiteProgram, Unit> function1 = action = iterator.next();
            Intrinsics.checkNotNull(function1);
            function1.invoke((Object)statement);
        }
    }

    @NotNull
    public String toString() {
        return this.getSql();
    }

    @Override
    public void close() {
    }

    private static final Unit bindBytes$lambda$0(byte[] $bytes, int $index, SupportSQLiteProgram it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($bytes == null) {
            it.bindNull($index + 1);
        } else {
            it.bindBlob($index + 1, $bytes);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindLong$lambda$0(Long $long, int $index, SupportSQLiteProgram it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($long == null) {
            it.bindNull($index + 1);
        } else {
            it.bindLong($index + 1, $long.longValue());
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindDouble$lambda$0(Double $double, int $index, SupportSQLiteProgram it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($double == null) {
            it.bindNull($index + 1);
        } else {
            it.bindDouble($index + 1, $double.doubleValue());
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindString$lambda$0(String $string, int $index, SupportSQLiteProgram it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($string == null) {
            it.bindNull($index + 1);
        } else {
            it.bindString($index + 1, $string);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindBoolean$lambda$0(Boolean $boolean, int $index, SupportSQLiteProgram it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($boolean == null) {
            it.bindNull($index + 1);
        } else {
            it.bindLong($index + 1, $boolean != false ? 1L : 0L);
        }
        return Unit.INSTANCE;
    }
}

